/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.transport.TTransportException;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.Connection;
import org.scale7.cassandra.pelops.IConnection;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class ManagerOperand {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(ManagerOperand.class);
    static final int SAFE_NODE_CHANGE_DELAY = 60000;
    static final int RETRY_NODE_DELAY = 1000;
    static final int CHANGE_NODE_DELAY = 500;
    static final int MAX_ATTEMPTS = 8;
    private Cluster cluster;
    private String keyspace;
    private Cluster.Node[] nodesSnapshot;
    private int chosenNodeIdx = 0;
    private long lastNodeWrite = 0L;
    private int safeNodeChangeDelay;
    private IConnection connection;

    ManagerOperand(Cluster cluster, String keyspace, int safeNodeChangeDelay) {
        this.cluster = cluster;
        this.keyspace = keyspace;
        this.safeNodeChangeDelay = safeNodeChangeDelay;
        this.nodesSnapshot = cluster.getNodes();
    }

    ManagerOperand(Cluster cluster, String keyspace) {
        this(cluster, keyspace, 60000);
    }

    ManagerOperand(Cluster cluster) {
        this(cluster, null, 60000);
    }

    ManagerOperand(Cluster cluster, int safeNodeChangeDelay) {
        this(cluster, null, safeNodeChangeDelay);
    }

    protected void openClient() throws Exception {
        int attempts = 0;
        Cluster.Node chosenNode = null;
        while (true) {
            try {
                chosenNode = this.nodesSnapshot[this.chosenNodeIdx];
                if (logger.isDebugEnabled()) {
                    logger.debug("Attempting operation against node '{}'...", (Object)chosenNode.getAddress());
                }
                this.connection = new Connection(chosenNode, this.keyspace);
                this.connection.open();
                this.lastNodeWrite = System.currentTimeMillis();
                return;
            }
            catch (Exception e) {
                this.closeClient();
                if (++attempts < 8 && (e instanceof TimedOutException || e instanceof TTransportException || e instanceof UnavailableException)) {
                    if (System.currentTimeMillis() - this.lastNodeWrite < (long)this.safeNodeChangeDelay) {
                        logger.warn("Retrying opening connection to same node after previous failure to avoid potential synchronization issues");
                        Thread.sleep(1000L);
                        continue;
                    }
                    logger.warn("Failed management operation against node '{}'", (Object)(chosenNode != null ? chosenNode.getAddress() : "null"));
                    ++this.chosenNodeIdx;
                    if (this.chosenNodeIdx == this.nodesSnapshot.length) {
                        this.chosenNodeIdx = 0;
                        this.nodesSnapshot = this.cluster.getNodes();
                    }
                    Thread.sleep(500L);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void closeClient() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected <ReturnType> ReturnType tryOperation(IManagerOperation<ReturnType> operation) throws Exception {
        this.openClient();
        try {
            ReturnType result = operation.execute(this.connection.getAPI());
            this.closeClient();
            return result;
        }
        catch (Exception e) {
            this.closeClient();
            throw e;
        }
    }

    protected static interface IManagerOperation<ReturnType> {
        public ReturnType execute(Cassandra.Client var1) throws Exception;
    }
}

