/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.model.SensitivityZoneFactory;
import au.org.ala.sds.util.AUWorkarounds;
import au.org.ala.sds.util.Configuration;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GeoLocationHelper {
    static final Logger logger = Logger.getLogger(GeoLocationHelper.class);

    public static Set<SensitivityZone> getZonesContainingPoint(String latitude, String longitude) throws Exception {
        HashSet<SensitivityZone> zones = new HashSet<SensitivityZone>();
        URL url = new URL(Configuration.getInstance().getLayersServiceUrl() + "/intersect/" + GeoLocationHelper.getLayersForUri() + "/" + latitude + "/" + longitude);
        URLConnection connection = url.openConnection();
        logger.debug((Object)("Looking up location using " + url));
        InputStream inStream = connection.getInputStream();
        logger.debug((Object)"Parsing location results");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readValue(inStream, JsonNode.class);
        for (JsonNode node : rootNode) {
            JsonNode valueNode = node.get("value");
            if (valueNode == null) continue;
            String field = node.get("field").getTextValue();
            String value = valueNode.getTextValue();
            if (!StringUtils.isNotBlank((String)value) || !StringUtils.isNotBlank((String)field)) continue;
            Set<SensitivityZone> auZones = AUWorkarounds.getZones(field, value, latitude, longitude);
            zones.addAll(auZones);
            SensitivityZone sensitivityZone = SensitivityZoneFactory.getZoneByName(value);
            if (sensitivityZone == null) continue;
            zones.add(sensitivityZone);
        }
        if (zones.isEmpty()) {
            logger.debug((Object)("Zone could not be determined from location: Lat " + latitude + ", Long " + longitude));
            zones.add(SensitivityZoneFactory.getZone("NOTAUS"));
        }
        return zones;
    }

    public static List<SensitivityZone> filterForZoneType(List<SensitivityZone> zones, SensitivityZone.ZoneType type) {
        ArrayList<SensitivityZone> newZones = new ArrayList<SensitivityZone>();
        for (SensitivityZone zone : zones) {
            if (zone.getType() != type) continue;
            newZones.add(zone);
        }
        return newZones;
    }

    private static String getLayersForUri() throws Exception {
        return StringUtils.join(Configuration.getInstance().getGeospatialLayers(), (String)",");
    }
}

