/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dao;

import au.org.ala.sds.dao.DataStreamCsvDao;
import au.org.ala.sds.dao.DataStreamDao;
import au.org.ala.sds.dao.DataStreamExcelDao;
import java.io.FileInputStream;
import java.io.InputStream;

public class DataStreamDaoFactory {
    public static DataStreamDao createDao(String fileName) throws Exception {
        return DataStreamDaoFactory.createDao(fileName, new FileInputStream(fileName));
    }

    public static DataStreamDao createDao(String fileName, InputStream inputStream) {
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            return new DataStreamExcelDao(fileName, inputStream);
        }
        if (fileName.endsWith(".csv")) {
            return new DataStreamCsvDao(fileName, inputStream);
        }
        if (fileName.endsWith(".tsv")) {
            return new DataStreamCsvDao(fileName, inputStream, '\t');
        }
        throw new IllegalArgumentException("Data file extension not supported - use .xls, .xlsx, .csv or .tsv");
    }
}

