/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.fuzzy;

import org.gbif.ecat.fuzzy.StringDistance;

public final class LevensteinDistance
implements StringDistance {
    @Override
    public float getDistance(String target, String other) {
        int i;
        char[] sa = target.toCharArray();
        int n = sa.length;
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int m = other.length();
        if (n == 0 || m == 0) {
            if (n == m) {
                return 1.0f;
            }
            return 0.0f;
        }
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = other.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = sa[i - 1] == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return 1.0f - (float)p[n] / (float)Math.max(other.length(), sa.length);
    }
}

