/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.cfg;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsGbifOrg {
    protected static final Logger log = LoggerFactory.getLogger(RsGbifOrg.class);
    public static final String DICTIONARY_URL = "http://rs.gbif.org/dictionaries/";
    public static final String FILENAME_BLACKLIST = "blacklisted.txt";
    public static final String FILENAME_SUPRAGENERIC = "suprageneric.txt";
    public static final String FILENAME_EPITHETA = "epitheta.txt";
    public static final String FILENAME_EPITHETA_AMIGOUS = "epitheta_ambigous.txt";
    public static final String FILENAME_AUTHORS = "authors.txt";
    public static final String FILENAME_GENERA = "genera.txt";
    public static final String FILENAME_GENERA_AMIGOUS = "genera_ambigous.txt";

    public static URL authorityUrl(String filename) {
        return RsGbifOrg.dictionaryUrl("authority/" + filename);
    }

    public static URL dictionaryUrl(String filename) {
        try {
            return new URL("http://rs.gbif.org/dictionaries//" + filename);
        }
        catch (MalformedURLException e) {
            log.error("Cannot create dictionary url for file " + filename, (Throwable)e);
            return null;
        }
    }

    public static URL synonymUrl(String filename) {
        return RsGbifOrg.dictionaryUrl("synonyms/" + filename);
    }
}

