/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.DuplicateDAO;
import au.org.ala.biocache.model.DuplicateRecordDetails;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.BiocacheConversions$;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u00015\u0011\u0001\u0003R;qY&\u001c\u0017\r^3E\u0003>KU\u000e\u001d7\u000b\u0005\r!\u0011a\u00013b_*\u0011QAB\u0001\tE&|7-Y2iK*\u0011q\u0001C\u0001\u0004C2\f'BA\u0005\u000b\u0003\ry'o\u001a\u0006\u0002\u0017\u0005\u0011\u0011-^\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!\u0001\u0004#va2L7-\u0019;f\t\u0006{\u0005\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\t)\u0002\u0001C\u0004\u001e\u0001\t\u0007I\u0011\u0003\u0010\u0002\r1|wmZ3s+\u0005y\u0002C\u0001\u0011%\u001b\u0005\t#B\u0001\u0012$\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0011BA\u0013\"\u0005\u0019aunZ4fe\"1q\u0005\u0001Q\u0001\n}\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0005*\u0001\u0001\u0007\t\u0019!C\u0001U\u0005\u0011\u0002/\u001a:tSN$XM\\2f\u001b\u0006t\u0017mZ3s+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003-\u0001XM]:jgR,gnY3\n\u0005Aj#A\u0005)feNL7\u000f^3oG\u0016l\u0015M\\1hKJD\u0011B\r\u0001A\u0002\u0003\u0007I\u0011A\u001a\u0002-A,'o]5ti\u0016t7-Z'b]\u0006<WM]0%KF$\"\u0001N\u001c\u0011\u0005=)\u0014B\u0001\u001c\u0011\u0005\u0011)f.\u001b;\t\u000fa\n\u0014\u0011!a\u0001W\u0005\u0019\u0001\u0010J\u0019\t\ri\u0002\u0001\u0015)\u0003,\u0003M\u0001XM]:jgR,gnY3NC:\fw-\u001a:!Q\tID\b\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u00061\u0011N\u001c6fGRT!!\u0011\"\u0002\r\u001d|wn\u001a7f\u0015\u0005\u0019\u0015aA2p[&\u0011QI\u0010\u0002\u0007\u0013:TWm\u0019;\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\u00061Q.\u00199qKJ,\u0012!\u0013\t\u0003\u0015Fk\u0011a\u0013\u0006\u0003\u00196\u000b\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003\u001d>\u000bqA[1dWN|gN\u0003\u0002Q\u0005\u0006Ia-Y:uKJDX\u000e\\\u0005\u0003%.\u0013Ab\u00142kK\u000e$X*\u00199qKJDa\u0001\u0016\u0001!\u0002\u0013I\u0015aB7baB,'\u000f\t\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u00035a\u0017m\u001d;Sk:\u0014vn^&fsV\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006!A.\u00198h\u0015\u0005i\u0016\u0001\u00026bm\u0006L!a\u0018.\u0003\rM#(/\u001b8h\u0011\u0019\t\u0007\u0001)A\u00051\u0006qA.Y:u%Vt'k\\<LKf\u0004\u0003bB2\u0001\u0005\u0004%\taV\u0001\u0012\tV\u0003F*S\"B)\u0016\u001bv,\u0012(U\u0013RK\u0006BB3\u0001A\u0003%\u0001,\u0001\nE+Bc\u0015jQ!U\u000bN{VI\u0014+J)f\u0003\u0003bB4\u0001\u0005\u0004%\taV\u0001\u0016\u001f\u000e\u001bu\fR+Q\u0019&\u001b\u0015\tV#T?\u0016sE+\u0013+Z\u0011\u0019I\u0007\u0001)A\u00051\u00061rjQ\"`\tV\u0003F*S\"B)\u0016\u001bv,\u0012(U\u0013RK\u0006\u0005C\u0003l\u0001\u0011\u0005A.A\u0007tCZ,G)\u001e9mS\u000e\fG/\u001a\u000b\u0003i5DQA\u001c6A\u0002=\fQ\u0002\u001d:j[\u0006\u0014\u0018PU3d_J$\u0007C\u00019t\u001b\u0005\t(B\u0001:\u0005\u0003\u0015iw\u000eZ3m\u0013\t!\u0018O\u0001\fEkBd\u0017nY1uKJ+7m\u001c:e\t\u0016$\u0018-\u001b7t\u0011\u00151\b\u0001\"\u0001x\u0003]!W\r\\3uK>\u00137o\u001c7fi\u0016$U\u000f\u001d7jG\u0006$X\r\u0006\u00025q\")\u00110\u001ea\u0001u\u0006!Q/^5e!\tYhP\u0004\u0002\u0010y&\u0011Q\u0010E\u0001\u0007!J,G-\u001a4\n\u0005}{(BA?\u0011\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\t\u0001cZ3u\tV\u0004H.[2bi\u0016LeNZ8\u0015\t\u0005\u001d\u0011Q\u0002\t\u0005\u001f\u0005%q.C\u0002\u0002\fA\u0011aa\u00149uS>t\u0007BB=\u0002\u0002\u0001\u0007!\u0010C\u0004\u0002\u0012\u0001!\t!a\u0005\u0002!\u001d,G\u000fR;qY&\u001c\u0017\r^3t\r>\u0014HCCA\u000b\u0003[\t\t$!\u000e\u0002:A)\u0011qCA\u0014_:!\u0011\u0011DA\u0012\u001d\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u0003K\u0001\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003S\tYC\u0001\u0003MSN$(bAA\u0013!!9\u0011qFA\b\u0001\u0004Q\u0018\u0001\u00027tS\u0012Dq!a\r\u0002\u0010\u0001\u0007!0\u0001\u0003zK\u0006\u0014\bbBA\u001c\u0003\u001f\u0001\rA_\u0001\u0006[>tG\u000f\u001b\u0005\b\u0003w\ty\u00011\u0001{\u0003\r!\u0017-\u001f\u0005\b\u0003\u007f\u0001A\u0011AA!\u0003U9W\r\u001e'bgR$U\u000f\u001d7jG\u0006$\u0018n\u001c8Sk:$\"!a\u0011\u0011\t=\tIA\u001f\u0005\b\u0003\u000f\u0002A\u0011IA%\u0003U\u0019X\r\u001e'bgR$U\u000f\u001d7jG\u0006$\u0018n\u001c8Sk:$2\u0001NA&\u0011!\ti%!\u0012A\u0002\u0005=\u0013\u0001\u00023bi\u0016\u0004B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+b\u0016\u0001B;uS2LA!!\u0017\u0002T\t!A)\u0019;f\u0001")
public class DuplicateDAOImpl
implements DuplicateDAO {
    private final Logger logger = LoggerFactory.getLogger((String)"DuplicateDAO");
    @Inject
    private PersistenceManager persistenceManager;
    private final ObjectMapper mapper = new ObjectMapper();
    private final String lastRunRowKey;
    private final String DUPLICATES_ENTITY;
    private final String OCC_DUPLICATES_ENTITY;

    public Logger logger() {
        return this.logger;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    public void persistenceManager_$eq(PersistenceManager x$1) {
        this.persistenceManager = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public String lastRunRowKey() {
        return this.lastRunRowKey;
    }

    public String DUPLICATES_ENTITY() {
        return this.DUPLICATES_ENTITY;
    }

    public String OCC_DUPLICATES_ENTITY() {
        return this.OCC_DUPLICATES_ENTITY;
    }

    @Override
    public void saveDuplicate(DuplicateRecordDetails primaryRecord) {
        String stringValue = this.mapper().writeValueAsString((Object)primaryRecord);
        Config$.MODULE$.persistenceManager().put(primaryRecord.uuid(), this.OCC_DUPLICATES_ENTITY(), "value", stringValue, true, false);
        Predef$.MODULE$.refArrayOps((Object[])primaryRecord.duplicates()).foreach((Function1)new Serializable(this, stringValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DuplicateDAOImpl $outer;
            private final String stringValue$1;

            public final String apply(DuplicateRecordDetails duplicate) {
                String duplicateAsString = this.$outer.mapper().writeValueAsString((Object)duplicate);
                return Config$.MODULE$.persistenceManager().put(duplicate.uuid(), this.$outer.OCC_DUPLICATES_ENTITY(), "value", this.stringValue$1, true, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.stringValue$1 = stringValue$1;
            }
        });
        Config$.MODULE$.persistenceManager().put(new StringBuilder().append((Object)primaryRecord.taxonConceptLsid()).append((Object)"|").append((Object)primaryRecord.year()).append((Object)"|").append((Object)primaryRecord.month()).append((Object)"|").append((Object)primaryRecord.day()).toString(), this.DUPLICATES_ENTITY(), "value", stringValue, true, false);
    }

    @Override
    public void deleteObsoleteDuplicate(String uuid) {
        Option<DuplicateRecordDetails> duplicate = this.getDuplicateInfo(uuid);
        if (duplicate.isDefined()) {
            this.logger().info(new StringBuilder().append((Object)"Deleting ").append((Object)((DuplicateRecordDetails)duplicate.get()).getRowKey()).append((Object)" - ").append((Object)uuid).toString());
            String otherKey = new StringBuilder().append((Object)((DuplicateRecordDetails)duplicate.get()).taxonConceptLsid()).append((Object)"|").append((Object)((DuplicateRecordDetails)duplicate.get()).year()).append((Object)"|").append((Object)((DuplicateRecordDetails)duplicate.get()).month()).append((Object)"|").append((Object)((DuplicateRecordDetails)duplicate.get()).day()).toString();
            this.persistenceManager().delete(uuid, this.OCC_DUPLICATES_ENTITY());
            this.persistenceManager().deleteColumns(otherKey, this.DUPLICATES_ENTITY(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{uuid}));
        }
    }

    @Override
    public Option<DuplicateRecordDetails> getDuplicateInfo(String uuid) {
        Option<String> stringValue = this.persistenceManager().get(uuid, this.OCC_DUPLICATES_ENTITY(), "value");
        return stringValue.isDefined() ? new Some(this.mapper().readValue((String)stringValue.get(), DuplicateRecordDetails.class)) : None$.MODULE$;
    }

    @Override
    public List<DuplicateRecordDetails> getDuplicatesFor(String lsid, String year, String month, String day) {
        Nil$ nil$;
        if (this.kvpMap$1(lsid, year, month, day).isDefined()) {
            ((IterableLike)this.kvpMap$1(lsid, year, month, day).get()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DuplicateDAOImpl $outer;

                public final ArrayBuffer<DuplicateRecordDetails> apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String value = (String)tuple2._2();
                        ArrayBuffer arrayBuffer = this.$outer.au$org$ala$biocache$dao$DuplicateDAOImpl$$buf$1().$plus$eq(this.$outer.mapper().readValue(value, DuplicateRecordDetails.class));
                        return arrayBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            nil$ = this.au$org$ala$biocache$dao$DuplicateDAOImpl$$buf$1().toList();
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    @Override
    public Option<String> getLastDuplicationRun() {
        return this.persistenceManager().get(this.lastRunRowKey(), this.DUPLICATES_ENTITY(), this.lastRunRowKey());
    }

    @Override
    public void setLastDuplicationRun(Date date) {
        this.persistenceManager().put(this.lastRunRowKey(), this.DUPLICATES_ENTITY(), this.lastRunRowKey(), BiocacheConversions$.MODULE$.dateToString(date), true, false);
    }

    private final Option kvpMap$1(String lsid$1, String year$1, String month$1, String day$1) {
        return this.persistenceManager().get(new StringBuilder().append((Object)lsid$1).append((Object)"|").append((Object)year$1).append((Object)"|").append((Object)month$1).append((Object)"|").append((Object)day$1).toString(), this.DUPLICATES_ENTITY());
    }

    public final ArrayBuffer au$org$ala$biocache$dao$DuplicateDAOImpl$$buf$1() {
        return new ArrayBuffer();
    }

    public DuplicateDAOImpl() {
        this.lastRunRowKey = "DDLastRun";
        this.DUPLICATES_ENTITY = "duplicates";
        this.OCC_DUPLICATES_ENTITY = "occ_duplicates";
    }
}

