/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.StarRecord;
import org.gbif.dwc.record.StarRecordImpl;
import org.gbif.dwc.terms.Term;
import org.gbif.dwcaio.shaded.com.google.common.base.Strings;
import org.gbif.dwcaio.shaded.com.google.common.collect.Iterators;
import org.gbif.dwcaio.shaded.com.google.common.collect.PeekingIterator;
import org.gbif.utils.file.ClosableIterator;

class StarRecordIterator
implements ClosableIterator<StarRecord> {
    private final StarRecordImpl rec;
    private final ClosableIterator<Record> coreIter;
    private final Set<ClosableIterator<?>> closeable = new HashSet();
    private final Map<Term, PeekingIterator<Record>> extensionIters = new HashMap<Term, PeekingIterator<Record>>();
    private final Map<Term, Integer> extensionRecordsSkipped = new HashMap<Term, Integer>();

    StarRecordIterator(ClosableIterator<Record> coreIt, Map<Term, ClosableIterator<Record>> extensionIts) {
        this.coreIter = coreIt;
        ArrayList<Term> rowTypes = new ArrayList<Term>();
        if (extensionIts != null) {
            for (Term extTerm : extensionIts.keySet()) {
                rowTypes.add(extTerm);
                this.closeable.add(extensionIts.get(extTerm));
                this.extensionIters.put(extTerm, Iterators.peekingIterator((Iterator)extensionIts.get(extTerm)));
                this.extensionRecordsSkipped.put(extTerm, 0);
            }
        }
        this.rec = new StarRecordImpl(rowTypes);
    }

    public void close() throws IOException {
        try {
            this.coreIter.close();
            for (ClosableIterator<?> it : this.closeable) {
                it.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Optional result = this.closeable.stream().flatMap(o -> {
            try {
                o.close();
                return null;
            }
            catch (Exception ex) {
                return Stream.of(ex);
            }
        }).reduce((ex1, ex2) -> {
            ex1.addSuppressed((Throwable)ex2);
            return ex1;
        });
        if (result.isPresent()) {
            throw new IOException((Throwable)result.get());
        }
    }

    public boolean hasNext() {
        return this.coreIter.hasNext();
    }

    public StarRecord next() {
        Record core = (Record)this.coreIter.next();
        this.rec.newCoreRecord(core);
        if (core.id() != null) {
            String id = core.id();
            block0: for (Map.Entry<Term, PeekingIterator<Record>> ext : this.extensionIters.entrySet()) {
                PeekingIterator<Record> it = ext.getValue();
                Term rowType = ext.getKey();
                while (it.hasNext()) {
                    String extId = it.peek().id();
                    if (Strings.isNullOrEmpty(extId)) {
                        it.next();
                        continue;
                    }
                    if (id.equals(extId)) {
                        this.rec.addRecord(rowType, it.next());
                        continue;
                    }
                    if (id.compareTo(extId) <= 0) continue block0;
                    it.next();
                    this.extensionRecordsSkipped.put(rowType, this.extensionRecordsSkipped.get(rowType) + 1);
                }
            }
        }
        return this.rec;
    }
}

