/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.gbif.dwc.ArchiveField;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.RecordImpl;
import org.gbif.dwc.terms.Term;
import org.gbif.utils.file.ClosableIterator;
import org.gbif.utils.file.tabular.TabularDataFileReader;

class DwcRecordIterator
implements ClosableIterator<Record> {
    private final TabularDataFileReader<List<String>> tabularFileReader;
    private final ArchiveField id;
    private final Map<Term, ArchiveField> fields;
    private final Term rowType;
    private final boolean replaceEntities;
    private final boolean replaceNulls;
    private List<String> nextLine;
    private boolean end = false;

    DwcRecordIterator(TabularDataFileReader<List<String>> tabularFileReader, ArchiveField id, Map<Term, ArchiveField> fields, Term rowType, boolean replaceNulls, boolean replaceEntities) {
        this.tabularFileReader = tabularFileReader;
        this.id = id;
        this.fields = fields;
        this.rowType = rowType;
        this.replaceNulls = replaceNulls;
        this.replaceEntities = replaceEntities;
    }

    public void close() throws IOException {
        this.end = true;
        this.tabularFileReader.close();
        this.nextLine = null;
    }

    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        if (this.end) {
            return false;
        }
        try {
            this.nextLine = (List)this.tabularFileReader.read();
        }
        catch (IOException | ParseException var2) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            throw new IllegalStateException(var2);
        }
        return this.nextLine != null;
    }

    public Record next() {
        RecordImpl record;
        if (this.hasNext()) {
            record = new RecordImpl(this.id, this.fields, this.rowType, this.replaceNulls, this.replaceEntities);
            List<String> currentLine = this.nextLine;
            this.nextLine = null;
            record.setRow(currentLine.toArray(new String[currentLine.size()]));
        } else {
            this.end = true;
            record = null;
        }
        return record;
    }

    public String toString() {
        return String.format("DwcRecordIterator %s, %s, %s, %s, %s, %s", this.id, this.fields, this.rowType, this.replaceNulls, this.replaceEntities, this.tabularFileReader);
    }
}

