/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.rs;

import java.net.MalformedURLException;
import java.net.URL;
import org.gbif.common.shaded.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsGbifOrg {
    private static final Logger LOG = LoggerFactory.getLogger(RsGbifOrg.class);
    private static final Joiner PATH_JOINER = Joiner.on("/").skipNulls();
    public static final String DOMAIN = "http://rs.gbif.org/";
    public static final String FILENAME_BLACKLIST = "blacklisted.txt";
    public static final String FILENAME_SUPRAGENERIC = "suprageneric.txt";
    public static final String FILENAME_EPITHETA = "epitheta.txt";
    public static final String FILENAME_EPITHETA_AMIGOUS = "epitheta_ambigous.txt";
    public static final String FILENAME_AUTHORS = "authors.txt";
    public static final String FILENAME_GENERA = "genera.txt";
    public static final String FILENAME_GENERA_AMIGOUS = "genera_ambigous.txt";

    public static URL url(String ... path) {
        try {
            if (path == null) {
                return new URL(DOMAIN);
            }
            return new URL(DOMAIN + PATH_JOINER.join(path));
        }
        catch (MalformedURLException e) {
            LOG.error("Cannot create rs.gbif.org url for path " + PATH_JOINER.join(path), (Throwable)e);
            return null;
        }
    }

    public static URL dictionaryUrl(String filename) {
        return RsGbifOrg.url("dictionaries", filename);
    }

    public static URL authorityUrl(String filename) {
        return RsGbifOrg.url("dictionaries", "authority", filename);
    }

    public static URL synonymUrl(String filename) {
        return RsGbifOrg.url("dictionaries", "synonyms", filename);
    }
}

