/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.html;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.gbif.common.shaded.com.google.common.base.Preconditions;
import org.owasp.html.PolicyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanHtmlSanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(BeanHtmlSanitizer.class);

    public static <T> T sanitize(T obj, PolicyFactory policy, Set<String> exclusion) {
        Preconditions.checkNotNull(obj, "The provided object can not be null");
        Preconditions.checkNotNull(policy, "The provided policy can not be null");
        try {
            Map properties = PropertyUtils.describe(obj);
            for (String property : properties.keySet()) {
                if (exclusion != null && exclusion.contains(property) || !String.class.equals((Object)PropertyUtils.getPropertyType(obj, (String)property))) continue;
                PropertyUtils.setProperty(obj, (String)property, (Object)policy.sanitize((String)properties.get(property)));
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Issue while applying HTML sanitization", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Issue while applying HTML sanitization", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Issue while applying HTML sanitization", (Throwable)e);
        }
        return obj;
    }

    public static <T> T sanitize(T obj, PolicyFactory policy) {
        return BeanHtmlSanitizer.sanitize(obj, policy, null);
    }
}

