/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class JsonSchemaValidator {
    private final SchemaNode root = new SchemaNode(null);
    static final Map<String, SchemaAttribute> knownAttributes = Collections.unmodifiableMap(Arrays.asList(SchemaAttribute.values()).stream().collect(Collectors.toMap(SchemaAttribute::getKey, Function.identity())));

    public JsonSchemaValidator(String jsonString) {
        this((Map)Utils.fromJSONString((String)jsonString));
    }

    public JsonSchemaValidator(Map jsonSchema) {
        this.root.isRequired = true;
        LinkedList errs = new LinkedList();
        this.root.validateSchema(jsonSchema, errs);
        if (!errs.isEmpty()) {
            throw new RuntimeException("Invalid schema. " + StrUtils.join(errs, (char)'|'));
        }
    }

    public List<String> validateJson(Object data) {
        LinkedList<String> errs = new LinkedList<String>();
        this.root.validate(null, data, errs);
        return errs.isEmpty() ? null : errs;
    }

    static enum Type {
        STRING(o -> o instanceof String),
        ARRAY(o -> o instanceof List, (key, o, schemaNode, errs) -> {
            List<Object> l;
            List<Object> list = l = o instanceof List ? (List<Object>)o : Collections.singletonList(o);
            if (schemaNode.elementType != null) {
                for (Object elem : l) {
                    if (schemaNode.elementType.validate(elem)) continue;
                    errs.add("Expected elements of type : " + key + " but found : " + Utils.toJSONString((Object)o));
                    break;
                }
            }
        }),
        NUMBER(o -> o instanceof Number, (key, o, schemaNode, errs) -> {
            if (o instanceof String) {
                try {
                    Double.parseDouble((String)o);
                }
                catch (NumberFormatException e) {
                    errs.add(e.getClass().getName() + " " + e.getMessage());
                }
            }
        }),
        INTEGER(o -> o instanceof Integer, (key, o, schemaNode, errs) -> {
            if (o instanceof String) {
                try {
                    Integer.parseInt((String)o);
                }
                catch (NumberFormatException e) {
                    errs.add(e.getClass().getName() + " " + e.getMessage());
                }
            }
        }),
        BOOLEAN(o -> o instanceof Boolean, (key, o, schemaNode, errs) -> {
            if (o instanceof String) {
                try {
                    Boolean.parseBoolean((String)o);
                }
                catch (Exception e) {
                    errs.add(e.getClass().getName() + " " + e.getMessage());
                }
            }
        }),
        ENUM(o -> o instanceof List, (key, o, schemaNode, errs) -> {
            HashSet enumVals;
            if (schemaNode.validationInfo instanceof HashSet && !(enumVals = (HashSet)schemaNode.validationInfo).contains(o)) {
                errs.add("value of enum " + key + " must be one of" + enumVals);
            }
        }),
        OBJECT(o -> o instanceof Map),
        UNKNOWN(o -> true);

        final String _name = this.name().toLowerCase(Locale.ROOT);
        final Predicate typeValidator;
        private final TypeValidator validator;

        private Type(Predicate validator) {
            this(validator, null);
        }

        private Type(Predicate validator, TypeValidator v) {
            this.typeValidator = validator;
            this.validator = v;
        }

        boolean validate(Object o) {
            return this.typeValidator.test(o);
        }

        void validateData(String key, Object o, SchemaNode attr, List<String> errs) {
            if (this.validator != null) {
                this.validator.validateData(key, o, attr, errs);
                return;
            }
            if (!this.typeValidator.test(o)) {
                errs.add("Expected type : " + this._name + " but found : " + o + "in object : " + Utils.toJSONString((Object)o));
            }
        }

        static Type get(Object type) {
            for (Type t : Type.values()) {
                if (!t._name.equals(type)) continue;
                return t;
            }
            return null;
        }
    }

    static interface TypeValidator {
        public void validateData(String var1, Object var2, SchemaNode var3, List<String> var4);
    }

    static enum SchemaAttribute {
        type(true, Type.STRING),
        properties(false, Type.OBJECT){

            @Override
            public void validateSchema(Map attrSchema, SchemaNode schemaNode, List<String> errors) {
                Object additional;
                super.validateSchema(attrSchema, schemaNode, errors);
                if (schemaNode.type != Type.OBJECT) {
                    return;
                }
                Object val = attrSchema.get(this.key);
                if (val == null && Boolean.TRUE.equals(additional = attrSchema.get(1.additionalProperties.key))) {
                    schemaNode.additionalProperties = Boolean.TRUE;
                }
            }
        }
        ,
        additionalProperties(false, Type.BOOLEAN),
        items(false, Type.OBJECT){

            @Override
            public void validateSchema(Map attrSchema, SchemaNode schemaNode, List<String> errors) {
                super.validateSchema(attrSchema, schemaNode, errors);
                Object itemsVal = attrSchema.get(this.key);
                if (itemsVal != null) {
                    if (schemaNode.type != Type.ARRAY) {
                        errors.add("Only 'array' can have 'items'");
                        return;
                    }
                    if (itemsVal instanceof Map) {
                        Map val = (Map)itemsVal;
                        Object value = val.get(2.type.key);
                        Type t = Type.get(String.valueOf(value));
                        if (t == null) {
                            errors.add("Unknown array type " + Utils.toJSONString((Object)attrSchema));
                        } else {
                            schemaNode.elementType = t;
                        }
                    }
                }
            }
        }
        ,
        __default(false, Type.UNKNOWN),
        description(false, Type.STRING),
        documentation(false, Type.STRING),
        oneOf(false, Type.ARRAY),
        __enum(false, Type.ARRAY){

            @Override
            void validateSchema(Map attrSchema, SchemaNode schemaNode, List<String> errors) {
                if (attrSchema.get(Type.ENUM._name) != null) {
                    schemaNode.elementType = schemaNode.type;
                    schemaNode.type = Type.ENUM;
                }
            }

            @Override
            void postValidateSchema(Map attrSchema, SchemaNode schemaNode, List<String> errs) {
                Object val = attrSchema.get(this.key);
                if (val == null) {
                    return;
                }
                if (val instanceof List) {
                    List list = (List)val;
                    for (Object o : list) {
                        if (schemaNode.elementType.validate(o)) continue;
                        errs.add("Invalid value : " + o + " Expected type : " + schemaNode.elementType._name);
                    }
                    if (!errs.isEmpty()) {
                        return;
                    }
                    schemaNode.validationInfo = new HashSet(list);
                } else {
                    errs.add("'enum' should have a an array as value in Object " + Utils.toJSONString((Object)attrSchema));
                }
            }
        }
        ,
        id(false, Type.STRING),
        _ref(false, Type.STRING),
        _schema(false, Type.STRING),
        required(false, Type.ARRAY){

            @Override
            public void postValidateSchema(Map attrSchema, SchemaNode attr, List<String> errors) {
                Object val = attrSchema.get(this.key);
                if (val instanceof List) {
                    List list = (List)val;
                    if (attr.children != null) {
                        for (Map.Entry<String, SchemaNode> e : attr.children.entrySet()) {
                            if (!list.contains(e.getKey())) continue;
                            e.getValue().isRequired = true;
                        }
                    }
                }
            }
        };

        final String key = this.name().replaceAll("__", "").replace('_', '$');
        final boolean _required;
        final Type typ;

        public String getKey() {
            return this.key;
        }

        void validateSchema(Map attrSchema, SchemaNode schemaNode, List<String> errors) {
            Object val = attrSchema.get(this.key);
            if (val == null) {
                if (this._required) {
                    errors.add("Missing required attribute '" + this.key + "' in object " + Utils.toJSONString((Object)attrSchema));
                }
            } else if (!this.typ.validate(val)) {
                errors.add(this.key + " should be of type " + this.typ._name);
            }
        }

        void postValidateSchema(Map attrSchema, SchemaNode schemaNode, List<String> errs) {
        }

        private SchemaAttribute(boolean required, Type type) {
            this._required = required;
            this.typ = type;
        }
    }

    private static class SchemaNode {
        final SchemaNode parent;
        Type type;
        Type elementType;
        boolean isRequired = false;
        Object validationInfo;
        Boolean additionalProperties;
        Map<String, SchemaNode> children;

        private SchemaNode(SchemaNode parent) {
            this.parent = parent;
        }

        private void validateSchema(Map jsonSchema, List<String> errs) {
            Type type;
            Object typeStr = jsonSchema.get("type");
            if (typeStr == null) {
                errs.add("'type' is missing ");
            }
            if ((type = Type.get(typeStr)) == null) {
                errs.add("Unknown type " + typeStr + " in object " + Utils.toJSONString((Object)jsonSchema));
                return;
            }
            this.type = type;
            for (SchemaAttribute schemaAttribute : SchemaAttribute.values()) {
                schemaAttribute.validateSchema(jsonSchema, this, errs);
            }
            jsonSchema.keySet().forEach(o -> {
                if (!knownAttributes.containsKey(o)) {
                    errs.add("Unknown key : " + o);
                }
            });
            if (!errs.isEmpty()) {
                return;
            }
            if (type == Type.OBJECT) {
                Map m = (Map)jsonSchema.get("properties");
                if (m != null) {
                    for (Map.Entry o2 : m.entrySet()) {
                        Map.Entry e = o2;
                        if (e.getValue() instanceof Map) {
                            Map od = (Map)e.getValue();
                            if (this.children == null) {
                                this.children = new LinkedHashMap<String, SchemaNode>();
                            }
                            SchemaNode child = new SchemaNode(this);
                            this.children.put((String)e.getKey(), child);
                            child.validateSchema(od, errs);
                            continue;
                        }
                        errs.add("Invalid Object definition for field " + e.getKey());
                    }
                } else {
                    this.additionalProperties = Boolean.TRUE;
                }
            }
            for (SchemaAttribute attr : SchemaAttribute.values()) {
                attr.postValidateSchema(jsonSchema, this, errs);
            }
        }

        private void validate(String key, Object data, List<String> errs) {
            if (data == null) {
                if (this.isRequired) {
                    errs.add("Missing field '" + key + "'");
                    return;
                }
            } else {
                this.type.validateData(key, data, this, errs);
                if (!errs.isEmpty()) {
                    return;
                }
                if (this.children != null && this.type == Type.OBJECT) {
                    for (Map.Entry<String, SchemaNode> e : this.children.entrySet()) {
                        e.getValue().validate(e.getKey(), ((Map)data).get(e.getKey()), errs);
                    }
                    if (Boolean.TRUE != this.additionalProperties) {
                        for (Map.Entry<String, SchemaNode> o : ((Map)data).keySet()) {
                            if (this.children.containsKey(o)) continue;
                            errs.add("Unknown field '" + o + "' in object : " + Utils.toJSONString((Object)data));
                        }
                    }
                }
            }
        }
    }
}

