/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.join.FrontierQuery;
import org.apache.solr.search.join.GraphTermsCollector;

public class GraphQuery
extends Query {
    private Query q;
    private String fromField;
    private String toField;
    private Query traversalFilter;
    private int maxDepth = -1;
    private boolean useAutn = true;
    private boolean onlyLeafNodes = false;
    private boolean returnRoot = true;

    public GraphQuery(Query q, String fromField, String toField) {
        this(q, fromField, toField, null);
    }

    public GraphQuery(Query q, String fromField, String toField, Query traversalFilter) {
        this.q = q;
        this.fromField = fromField;
        this.toField = toField;
        this.traversalFilter = traversalFilter;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        GraphQueryWeight graphWeight = new GraphQueryWeight((SolrIndexSearcher)searcher);
        return graphWeight;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("[[" + this.q.toString() + "]," + this.fromField + "=" + this.toField + "]");
        if (this.traversalFilter != null) {
            sb.append(" [TraversalFilter: " + this.traversalFilter.toString() + "]");
        }
        sb.append("[maxDepth=" + this.maxDepth + "]");
        sb.append("[returnRoot=" + this.returnRoot + "]");
        sb.append("[onlyLeafNodes=" + this.onlyLeafNodes + "]");
        sb.append("[useAutn=" + this.useAutn + "]");
        return sb.toString();
    }

    public Query getTraversalFilter() {
        return this.traversalFilter;
    }

    public void setTraversalFilter(Query traversalFilter) {
        this.traversalFilter = traversalFilter;
    }

    public Query getQ() {
        return this.q;
    }

    public void setQ(Query q) {
        this.q = q;
    }

    public String getFromField() {
        return this.fromField;
    }

    public void setFromField(String fromField) {
        this.fromField = fromField;
    }

    public String getToField() {
        return this.toField;
    }

    public void setToField(String toField) {
        this.toField = toField;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean isUseAutn() {
        return this.useAutn;
    }

    public void setUseAutn(boolean useAutn) {
        this.useAutn = useAutn;
    }

    public boolean isOnlyLeafNodes() {
        return this.onlyLeafNodes;
    }

    public void setOnlyLeafNodes(boolean onlyLeafNodes) {
        this.onlyLeafNodes = onlyLeafNodes;
    }

    public boolean isReturnRoot() {
        return this.returnRoot;
    }

    public void setReturnRoot(boolean returnRoot) {
        this.returnRoot = returnRoot;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.fromField);
        result = 31 * result + this.maxDepth;
        result = 31 * result + (this.onlyLeafNodes ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.q);
        result = 31 * result + (this.returnRoot ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.toField);
        result = 31 * result + Objects.hashCode(this.traversalFilter);
        result = 31 * result + (this.useAutn ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((GraphQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(GraphQuery other) {
        return Objects.equals(this.fromField, other.fromField) && this.maxDepth == other.maxDepth && this.onlyLeafNodes == other.onlyLeafNodes && this.returnRoot == other.returnRoot && this.useAutn == other.useAutn && Objects.equals(this.q, other.q) && Objects.equals(this.toField, other.toField) && Objects.equals(this.traversalFilter, other.traversalFilter);
    }

    private static class GraphScorer
    extends Scorer {
        final DocIdSetIterator iter;
        final float score;

        public GraphScorer(Weight w, DocIdSetIterator iter, float score) throws IOException {
            super(w);
            this.iter = iter == null ? DocIdSet.EMPTY.iterator() : iter;
            this.score = score;
        }

        public float score() throws IOException {
            return this.score;
        }

        public DocIdSetIterator iterator() {
            return this.iter;
        }

        public int docID() {
            return this.iter.docID();
        }

        public int freq() throws IOException {
            return 1;
        }
    }

    protected class GraphQueryWeight
    extends Weight {
        SolrIndexSearcher fromSearcher;
        private float queryNorm;
        private float queryWeight;
        private int frontierSize;
        private int currentDepth;
        private Filter filter;
        private DocSet resultSet;

        public GraphQueryWeight(SolrIndexSearcher searcher) {
            super(null);
            this.queryNorm = 1.0f;
            this.queryWeight = 1.0f;
            this.frontierSize = 0;
            this.currentDepth = -1;
            this.fromSearcher = searcher;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            boolean exists;
            Scorer cs = this.scorer(context);
            boolean bl = exists = cs != null && cs.iterator().advance(doc) == doc;
            if (exists) {
                ArrayList subs = new ArrayList();
                return Explanation.match((float)1.0f, (String)"Graph Match", subs);
            }
            ArrayList subs = new ArrayList();
            return Explanation.noMatch((String)"No Graph Match.", subs);
        }

        public float getValueForNormalization() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryWeight = norm * topLevelBoost;
        }

        private DocSet getDocSet() throws IOException {
            int capacity = this.fromSearcher.getRawReader().maxDoc();
            FixedBitSet resultBits = new FixedBitSet(capacity);
            BitDocSet fromSet = null;
            FixedBitSet rootBits = null;
            Query frontierQuery = GraphQuery.this.q;
            DocSet leafNodes = this.resolveLeafNodes(GraphQuery.this.toField);
            do {
                ++this.currentDepth;
                if (GraphQuery.this.maxDepth != -1 && this.currentDepth >= GraphQuery.this.maxDepth) {
                    fromSet = this.fromSearcher.getDocSetBits(frontierQuery);
                    this.frontierSize = 0;
                } else {
                    GraphTermsCollector graphResultCollector = new GraphTermsCollector(GraphQuery.this.toField, capacity, (Bits)resultBits, leafNodes);
                    this.fromSearcher.search(frontierQuery, graphResultCollector);
                    fromSet = graphResultCollector.getDocSet();
                    BytesRefHash collectorTerms = graphResultCollector.getCollectorTerms();
                    this.frontierSize = collectorTerms.size();
                    FrontierQuery fq = this.buildFrontierQuery(collectorTerms, this.frontierSize);
                    if (fq == null) {
                        this.frontierSize = 0;
                    } else {
                        frontierQuery = fq.getQuery();
                        this.frontierSize = fq.getFrontierSize();
                    }
                }
                if (this.currentDepth == 0 && !GraphQuery.this.returnRoot) {
                    rootBits = fromSet.getBits();
                }
                resultBits.or(fromSet.getBits());
            } while ((GraphQuery.this.maxDepth == -1 || this.currentDepth < GraphQuery.this.maxDepth) && this.frontierSize > 0);
            if (!GraphQuery.this.returnRoot) {
                resultBits.andNot(rootBits);
            }
            BitDocSet resultSet = new BitDocSet(resultBits);
            if (GraphQuery.this.onlyLeafNodes) {
                return resultSet.intersection(leafNodes);
            }
            return resultSet;
        }

        private DocSet resolveLeafNodes(String field) throws IOException {
            BooleanQuery.Builder leafNodeQuery = new BooleanQuery.Builder();
            WildcardQuery edgeQuery = new WildcardQuery(new Term(field, "*"));
            leafNodeQuery.add((Query)edgeQuery, BooleanClause.Occur.MUST_NOT);
            DocSet leafNodes = this.fromSearcher.getDocSet((Query)leafNodeQuery.build());
            return leafNodes;
        }

        private Automaton buildAutomaton(BytesRefHash termBytesHash) {
            TreeSet<BytesRef> terms = new TreeSet<BytesRef>();
            for (int i = 0; i < termBytesHash.size(); ++i) {
                BytesRef ref = new BytesRef();
                termBytesHash.get(i, ref);
                terms.add(ref);
            }
            Automaton a = DaciukMihovAutomatonBuilder.build(terms);
            return a;
        }

        public FrontierQuery buildFrontierQuery(BytesRefHash collectorTerms, Integer frontierSize) {
            if (collectorTerms == null || collectorTerms.size() == 0) {
                return null;
            }
            AutomatonQuery q = null;
            if (GraphQuery.this.useAutn) {
                AutomatonQuery autnQuery;
                Automaton autn = this.buildAutomaton(collectorTerms);
                q = autnQuery = new AutomatonQuery(new Term(GraphQuery.this.fromField), autn);
            } else {
                ArrayList<BytesRef> termList = new ArrayList<BytesRef>(collectorTerms.size());
                for (int i = 0; i < collectorTerms.size(); ++i) {
                    BytesRef ref = new BytesRef();
                    collectorTerms.get(i, ref);
                    termList.add(ref);
                }
                q = new TermInSetQuery(GraphQuery.this.fromField, termList);
            }
            if (GraphQuery.this.traversalFilter != null) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                builder.add((Query)q, BooleanClause.Occur.MUST);
                builder.add(GraphQuery.this.traversalFilter, BooleanClause.Occur.MUST);
                q = builder.build();
            }
            FrontierQuery frontier = new FrontierQuery((Query)q, frontierSize);
            return frontier;
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSet readerSet;
            if (this.filter == null) {
                this.resultSet = this.getDocSet();
                this.filter = this.resultSet.getTopFilter();
            }
            return new GraphScorer(this, (readerSet = this.filter.getDocIdSet(context, context.reader().getLiveDocs())) == null ? DocIdSetIterator.empty() : readerSet.iterator(), 1.0f);
        }

        public void extractTerms(Set<Term> terms) {
        }
    }
}

