/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.caches.AttributionDAO$;
import au.org.ala.biocache.model.Attribution;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u001b\t!\u0012\t\u001e;sS\n,H/[8o!J|7-Z:t_JT!a\u0001\u0003\u0002\u0013A\u0014xnY3tg>\u0014(BA\u0003\u0007\u0003!\u0011\u0017n\\2bG\",'BA\u0004\t\u0003\r\tG.\u0019\u0006\u0003\u0013)\t1a\u001c:h\u0015\u0005Y\u0011AA1v\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\n!J|7-Z:t_JDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005U\u0001\u0001bB\u000f\u0001\u0005\u0004%\tAH\u0001\u0007Y><w-\u001a:\u0016\u0003}\u0001\"\u0001\t\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u000bMdg\r\u000e6\u000b\u0003%I!!J\u0011\u0003\r1{wmZ3s\u0011\u00199\u0003\u0001)A\u0005?\u00059An\\4hKJ\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013a\u00029s_\u000e,7o\u001d\u000b\u0006WQj$\t\u0012\t\u0004\u001f1r\u0013BA\u0017\u0011\u0005\u0015\t%O]1z!\ty#'D\u00011\u0015\t\tD!A\u0003n_\u0012,G.\u0003\u00024a\t\u0001\u0012+^1mSRL\u0018i]:feRLwN\u001c\u0005\u0006k!\u0002\rAN\u0001\u0005OVLG\r\u0005\u00028u9\u0011q\u0002O\u0005\u0003sA\ta\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011\b\u0005\u0005\u0006}!\u0002\raP\u0001\u0004e\u0006<\bCA\u0018A\u0013\t\t\u0005G\u0001\u0006Gk2d'+Z2pe\u0012DQa\u0011\u0015A\u0002}\n\u0011\u0002\u001d:pG\u0016\u001c8/\u001a3\t\u000f\u0015C\u0003\u0013!a\u0001\r\u0006iA.Y:u!J|7-Z:tK\u0012\u00042aD$@\u0013\tA\u0005C\u0001\u0004PaRLwN\u001c\u0005\u0006\u0015\u0002!\taS\u0001\u0005g.L\u0007\u000fF\u0003,\u00196su\nC\u00036\u0013\u0002\u0007a\u0007C\u0003?\u0013\u0002\u0007q\bC\u0003D\u0013\u0002\u0007q\bC\u0004F\u0013B\u0005\t\u0019\u0001$\t\u000bE\u0003A\u0011\u0001*\u0002\u000f\u001d,GOT1nKV\t1\u000b\u0005\u0002U36\tQK\u0003\u0002W/\u0006!A.\u00198h\u0015\u0005A\u0016\u0001\u00026bm\u0006L!aO+\t\u000fm\u0003\u0011\u0013!C!9\u0006\t\u0002O]8dKN\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003uS#A\u00120,\u0003}\u0003\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u0013Ut7\r[3dW\u0016$'B\u00013\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0003M\u0006\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001dA\u0007!%A\u0005Bq\u000bab]6ja\u0012\"WMZ1vYR$C\u0007")
public class AttributionProcessor
implements Processor {
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        Option<Attribution> dataResource;
        ArrayBuffer assertions = new ArrayBuffer();
        if (raw.attribution().dataResourceUid() != null && !(dataResource = AttributionDAO$.MODULE$.getDataResourceByUid(raw.attribution().dataResourceUid())).isEmpty()) {
            BoxedUnit boxedUnit;
            if (((Attribution)dataResource.get()).hasMappedCollections() && (raw.occurrence().collectionCode() != null || processed.occurrence().collectionCode() != null)) {
                String collCode;
                String string = collCode = raw.occurrence().collectionCode() == null ? processed.occurrence().collectionCode() : raw.occurrence().collectionCode();
                String instCode = raw.occurrence().institutionCode() == null ? (processed.occurrence().institutionCode() == null ? collCode : processed.occurrence().institutionCode()) : raw.occurrence().institutionCode();
                Option<Attribution> attribution = AttributionDAO$.MODULE$.getByCodes(instCode, collCode);
                if (attribution.isEmpty()) {
                    assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_COLLECTIONCODE(), "Unrecognised collection code institution code combination")}));
                    boxedUnit = assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_INSTITUTIONCODE(), "Unrecognised collection code institution code combination")}));
                } else {
                    processed.attribution_$eq((Attribution)attribution.get());
                    assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_COLLECTIONCODE(), AssertionStatus$.MODULE$.PASSED())}));
                    boxedUnit = assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_INSTITUTIONCODE(), AssertionStatus$.MODULE$.PASSED())}));
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            processed.attribution().dataResourceName_$eq(((Attribution)dataResource.get()).dataResourceName());
            processed.attribution().dataProviderUid_$eq(((Attribution)dataResource.get()).dataProviderUid());
            processed.attribution().dataProviderName_$eq(((Attribution)dataResource.get()).dataProviderName());
            processed.attribution().dataHubUid_$eq(((Attribution)dataResource.get()).dataHubUid());
            processed.attribution().dataResourceUid_$eq(((Attribution)dataResource.get()).dataResourceUid());
            processed.attribution().provenance_$eq(((Attribution)dataResource.get()).provenance());
            processed.attribution().license_$eq(((Attribution)dataResource.get()).license());
            if (processed.attribution().taxonomicHints() == null) {
                processed.attribution().taxonomicHints_$eq(((Attribution)dataResource.get()).taxonomicHints());
            }
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    @Override
    public QualityAssertion[] skip(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions = new ArrayBuffer();
        if (lastProcessed.isDefined()) {
            assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])((FullRecord)lastProcessed.get()).findAssertions(new int[]{AssertionCodes$.MODULE$.UNRECOGNISED_COLLECTIONCODE().code(), AssertionCodes$.MODULE$.UNRECOGNISED_INSTITUTIONCODE().code()})));
            processed.attribution_$eq(((FullRecord)lastProcessed.get()).attribution());
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> skip$default$4() {
        return None$.MODULE$;
    }

    @Override
    public String getName() {
        return "attr";
    }

    public AttributionProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"AttributionProcessor");
    }
}

