/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol.tapir;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.gbif.crawler.CrawlConfiguration;

@ThreadSafe
public class TapirCrawlConfiguration
extends CrawlConfiguration {
    public static final ImmutableList<String> VALID_SCHEMAS = ImmutableList.of((Object)"http://rs.tdwg.org/dwc/dwcore/", (Object)"http://rs.tdwg.org/dwc/geospatial/", (Object)"http://rs.tdwg.org/dwc/curatorial/", (Object)"http://rs.tdwg.org/dwc/terms/", (Object)"http://digir.net/schema/conceptual/darwin/2003/1.0", (Object)"http://www.tdwg.org/schemas/abcd/1.2", (Object)"http://www.tdwg.org/schemas/abcd/2.05", (Object)"http://www.tdwg.org/schemas/abcd/2.06");
    private final String contentNamespace;

    public TapirCrawlConfiguration(UUID datasetKey, int attempt, URI url, String contentNamespace) {
        super(datasetKey, url, attempt);
        this.contentNamespace = (String)Preconditions.checkNotNull((Object)contentNamespace, (Object)"contentNamespace can't be null");
        Preconditions.checkArgument((boolean)VALID_SCHEMAS.contains((Object)contentNamespace), (Object)("contentNamespace not supported: [" + contentNamespace + "]"));
    }

    public String getContentNamespace() {
        return this.contentNamespace;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TapirCrawlConfiguration)) {
            return false;
        }
        TapirCrawlConfiguration other = (TapirCrawlConfiguration)obj;
        return super.equals(other) && Objects.equal((Object)this.contentNamespace, (Object)other.contentNamespace);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.contentNamespace});
    }

    public String toString() {
        return this.toStringHelper().add("contentNamespace", (Object)this.contentNamespace).toString();
    }
}

