/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.http.HttpResponse;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.gbif.crawler.ResponseHandler;
import org.gbif.crawler.exception.FatalCrawlException;
import org.gbif.crawler.exception.ProtocolException;
import org.gbif.crawler.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractResponseHandler
implements ResponseHandler<HttpResponse, List<Byte>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResponseHandler.class);
    private static final XMLInputFactory2 XIF = (XMLInputFactory2)XMLInputFactory.newInstance();
    private static final XMLOutputFactory2 XOF = (XMLOutputFactory2)XMLOutputFactory.newInstance();
    private Optional<Integer> recordCount = Optional.absent();
    private Optional<Boolean> endOfRecords = Optional.absent();
    private Optional<Long> contentHash;
    private boolean validState = false;

    protected abstract void process(XMLStreamReader2 var1) throws XMLStreamException, FatalCrawlException, ProtocolException;

    protected abstract boolean shouldHash(XMLStreamReader2 var1);

    @Override
    public boolean isValidState() {
        return this.validState;
    }

    private void initializeInternal() {
        this.recordCount = Optional.absent();
        this.endOfRecords = Optional.absent();
        this.contentHash = Optional.absent();
        this.validState = false;
    }

    protected abstract void initialize();

    @Override
    public final List<Byte> handleResponse(HttpResponse response) throws FatalCrawlException, ProtocolException, TransportException {
        byte[] bytes;
        Preconditions.checkNotNull((Object)response);
        this.initializeInternal();
        this.initialize();
        try {
            bytes = ByteStreams.toByteArray((InputStream)response.getEntity().getContent());
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        Hasher hasher = Hashing.md5().newHasher();
        XMLStreamReader2 reader = null;
        XMLStreamWriter2 writer = null;
        boolean didHash = false;
        try {
            reader = (XMLStreamReader2)XIF.createXMLStreamReader((InputStream)new ByteArrayInputStream(bytes));
            writer = (XMLStreamWriter2)XOF.createXMLStreamWriter(Funnels.asOutputStream((PrimitiveSink)hasher));
            writer.writeStartElement("wrapper");
            while (reader.next() != 8) {
                this.process(reader);
                if (!this.shouldHash(reader)) continue;
                didHash = true;
                writer.copyEventFromReader(reader, true);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            try {
                throw new ProtocolException(e);
            }
            catch (Throwable throwable) {
                AbstractResponseHandler.closeQuietly(reader);
                AbstractResponseHandler.closeQuietly(writer);
                throw throwable;
            }
        }
        AbstractResponseHandler.closeQuietly((XMLStreamReader)reader);
        AbstractResponseHandler.closeQuietly((XMLStreamWriter)writer);
        if (didHash) {
            this.contentHash = Optional.of((Object)hasher.hash().asLong());
        }
        this.validState = true;
        return Bytes.asList((byte[])bytes);
    }

    @Override
    public final Optional<Integer> getRecordCount() {
        Preconditions.checkState((boolean)this.validState);
        return this.recordCount;
    }

    protected final void setRecordCount(Optional<Integer> recordCount) {
        this.recordCount = (Optional)Preconditions.checkNotNull(recordCount);
    }

    protected final void setEndOfRecords(Optional<Boolean> endOfRecords) {
        this.endOfRecords = (Optional)Preconditions.checkNotNull(endOfRecords);
    }

    @Override
    public final Optional<Boolean> isEndOfRecords() {
        Preconditions.checkState((boolean)this.validState, (Object)"Last response was not valid");
        return this.endOfRecords;
    }

    @Override
    public final Optional<Long> getContentHash() {
        Preconditions.checkState((boolean)this.validState, (Object)"Last response was not valid");
        return this.contentHash;
    }

    private static void closeQuietly(@Nullable XMLStreamReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (XMLStreamException e) {
            LOG.warn("Error closing XML reader", (Throwable)e);
        }
    }

    private static void closeQuietly(@Nullable XMLStreamWriter writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (XMLStreamException e) {
            LOG.debug("Error closing XML writer", (Throwable)e);
        }
    }

    protected static boolean isElement(XMLStreamReader reader, String name, boolean start) {
        return reader.getEventType() == (start ? 1 : 2) && reader.getLocalName().equals(name);
    }
}

