/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.util;

import au.org.ala.names.model.SynonymType;
import com.opencsv.CSVWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class NameListGenerator
implements Closeable {
    private static Log log = LogFactory.getLog(NameListGenerator.class);
    private static String[][] FIELDS = new String[][]{{"lsid", "taxonID"}, {"name", "scientificName"}, {"author", "scientificNameAuthorship"}, {"rank", "taxonRank"}, {"accepted_lsid", "acceptedNameUsageId"}, {"syn_type", "taxonomicStatus"}};
    private CSVWriter writer;
    private IndexReader cbReader;
    private Set<String> synonymTypes;

    public NameListGenerator(Writer output, File index) throws IOException {
        this.writer = new CSVWriter(output);
        this.cbReader = DirectoryReader.open((Directory)FSDirectory.open((Path)new File(index, "cb").toPath()));
        this.synonymTypes = new HashSet<String>();
    }

    public void generateHeader() {
        String[] headers = new String[FIELDS.length];
        for (int i = 0; i < FIELDS.length; ++i) {
            headers[i] = FIELDS[i][1];
        }
        this.writer.writeNext(headers);
    }

    public void generate() {
        String[] values = new String[FIELDS.length];
        this.generateHeader();
        for (int i = 0; i < this.cbReader.maxDoc(); ++i) {
            try {
                Document doc = this.cbReader.document(i);
                for (int j = 0; j < FIELDS.length; ++j) {
                    String value = doc.get(FIELDS[j][0]);
                    if (value != null && FIELDS[j][0].equals("syn_type")) {
                        this.synonymTypes.add(value);
                        SynonymType type = SynonymType.getTypeFor(value);
                        if (type != null) {
                            value = type.name();
                        }
                    }
                    values[j] = value;
                }
                this.writer.writeNext(values);
                continue;
            }
            catch (IOException ex) {
                log.warn((Object)("Unable to get document " + i + ": " + ex.getMessage()));
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        finally {
            this.cbReader.close();
        }
    }

    public void dumpSynonyms(PrintStream out) {
        ArrayList<String> synonyms = new ArrayList<String>(this.synonymTypes);
        Collections.sort(synonyms);
        out.println("Synonym Types");
        out.println("-------------");
        for (String s : synonyms) {
            out.print(s);
            out.print(" = ");
            out.println((Object)SynonymType.getTypeFor(s));
        }
    }

    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"Output file name - defaults to standard output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option o = OptionBuilder.create((char)'o');
        OptionBuilder.withLongOpt((String)"index");
        OptionBuilder.withDescription((String)"Lucene index directory - defaults to /data/lucene/namematching");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option i = OptionBuilder.create((char)'i');
        options.addOption(o);
        options.addOption(i);
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            String of = cmd.getOptionValue('o', "-");
            OutputStreamWriter output = of == null || of.equals("-") ? new OutputStreamWriter(System.out) : new FileWriter(of);
            File index = new File(cmd.getOptionValue('i', "/data/lucene/namematching"));
            try (NameListGenerator generator = new NameListGenerator(output, index);){
                generator.generate();
                generator.dumpSynonyms(System.out);
            }
        }
        catch (ParseException ex) {
            System.err.println("Unable to parse command line: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

