/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.model.ConservationInstance;
import au.org.ala.sds.model.SensitivityInstance;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.validation.MessageFactory;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GeneralisedLocation {
    private final String originalLatitude;
    private final String originalLongitude;
    private final List<SensitivityZone> zones;
    private final List<SensitivityInstance> instances;
    private final String locationGeneralisation;
    private String generalisedLatitude;
    private String generalisedLongitude;
    private String generalisationInMetres;
    private String generalisationToApplyInMetres;
    private String description;
    private boolean sensitive;

    public GeneralisedLocation(String latitude, String longitude, List<SensitivityInstance> instances, List<SensitivityZone> zones) {
        this.originalLatitude = latitude;
        this.originalLongitude = longitude;
        this.zones = zones;
        this.instances = instances;
        this.locationGeneralisation = this.getLocationGeneralisation();
        this.sensitive = true;
        this.generaliseCoordinates();
    }

    public boolean isGeneralised() {
        if (StringUtils.isBlank((String)this.originalLatitude) || StringUtils.isBlank((String)this.originalLongitude)) {
            return false;
        }
        return !this.originalLatitude.equals(this.generalisedLatitude) || !this.originalLongitude.equals(this.generalisedLongitude);
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public String getOriginalLatitude() {
        return this.originalLatitude;
    }

    public String getOriginalLongitude() {
        return this.originalLongitude;
    }

    public String getGeneralisedLatitude() {
        return this.generalisedLatitude;
    }

    public String getGeneralisedLongitude() {
        return this.generalisedLongitude;
    }

    public String getGeneralisationInMetres() {
        return this.generalisationInMetres;
    }

    public String getGeneralisationToApplyInMetres() {
        return this.generalisationToApplyInMetres;
    }

    public String getDescription() {
        return this.description;
    }

    public List<SensitivityInstance> getSensitivityInstances() {
        return this.instances;
    }

    private void generaliseCoordinates() {
        this.generalisationInMetres = "";
        if (this.locationGeneralisation == null) {
            this.generalisedLatitude = this.originalLatitude;
            this.generalisedLongitude = this.originalLongitude;
            String state = SensitivityZone.getZoneDescriptions(this.zones);
            this.description = MessageFactory.getMessageText("LocNotGen", state.equalsIgnoreCase("Outside Australia") ? state : "in " + state);
            this.sensitive = false;
            return;
        }
        if (StringUtils.isBlank((String)this.originalLatitude) || StringUtils.isBlank((String)this.originalLongitude)) {
            this.generalisedLatitude = this.originalLatitude;
            this.generalisedLongitude = this.originalLongitude;
            this.description = MessageFactory.getMessageText("LatLongMissing");
            this.sensitive = this.locationGeneralisation != null;
            return;
        }
        if (this.locationGeneralisation.equalsIgnoreCase("WITHHOLD")) {
            this.generalisedLatitude = "";
            this.generalisedLongitude = "";
            this.description = MessageFactory.getMessageText("LocWithheld");
        } else if (this.locationGeneralisation.equalsIgnoreCase("100km") || this.locationGeneralisation.equalsIgnoreCase("50km")) {
            this.generaliseCoordinates(1);
            this.generalisationToApplyInMetres = this.locationGeneralisation.equalsIgnoreCase("50km") ? "50000" : "100000";
            if (this.isGeneralised()) {
                this.description = MessageFactory.getMessageText("LocGen", SensitivityZone.getZoneDescriptions(this.zones), "1.0");
                this.generalisationInMetres = this.generalisationToApplyInMetres;
            } else {
                this.description = MessageFactory.getMessageText("LocAlreadyGen", SensitivityZone.getZoneDescriptions(this.zones), "1.0");
            }
        } else if (this.locationGeneralisation.equalsIgnoreCase("10km")) {
            this.generaliseCoordinates(1);
            this.generalisationToApplyInMetres = "10000";
            if (this.isGeneralised()) {
                this.description = MessageFactory.getMessageText("LocGen", SensitivityZone.getZoneDescriptions(this.zones), "0.1");
                this.generalisationInMetres = this.generalisationToApplyInMetres;
            } else {
                this.description = MessageFactory.getMessageText("LocAlreadyGen", SensitivityZone.getZoneDescriptions(this.zones), "0.1");
            }
        } else if (this.locationGeneralisation.equalsIgnoreCase("1km") || this.locationGeneralisation.equalsIgnoreCase("2km")) {
            this.generaliseCoordinates(2);
            this.generalisationToApplyInMetres = this.locationGeneralisation.equalsIgnoreCase("2km") ? "2000" : "1000";
            if (this.isGeneralised()) {
                this.description = MessageFactory.getMessageText("LocGen", SensitivityZone.getZoneDescriptions(this.zones), "0.01");
                this.generalisationInMetres = this.generalisationToApplyInMetres;
            } else {
                this.description = MessageFactory.getMessageText("LocAlreadyGen", SensitivityZone.getZoneDescriptions(this.zones), "0.01");
            }
        } else if (this.locationGeneralisation.equalsIgnoreCase("100m")) {
            this.generaliseCoordinates(3);
            this.generalisationToApplyInMetres = "100";
            if (this.isGeneralised()) {
                this.description = MessageFactory.getMessageText("LocGen", SensitivityZone.getZoneDescriptions(this.zones), "0.001");
                this.generalisationInMetres = this.generalisationToApplyInMetres;
            } else {
                this.description = MessageFactory.getMessageText("LocAlreadyGen", SensitivityZone.getZoneDescriptions(this.zones), "0.001");
            }
        } else {
            this.generalisedLatitude = this.originalLatitude;
            this.generalisedLongitude = this.originalLongitude;
            this.description = "Location not generalised the severity of generalisation is not specified or is unrecognised.";
            this.sensitive = false;
        }
    }

    public boolean coordinatesWithheld() {
        return this.getGeneralisationInMetres().equals("") && this.getGeneralisedLatitude() != null && this.getGeneralisedLatitude().equals("");
    }

    private void generaliseCoordinates(int decimalPlaces) {
        this.generalisedLatitude = this.round(this.originalLatitude, decimalPlaces);
        this.generalisedLongitude = this.round(this.originalLongitude, decimalPlaces);
    }

    private String round(String number, int decimalPlaces) {
        if (number == null || number.equals("")) {
            return "";
        }
        BigDecimal bd = new BigDecimal(number);
        if (bd.scale() > decimalPlaces) {
            return String.format("%." + decimalPlaces + "f", bd);
        }
        return number;
    }

    private String getLocationGeneralisation() {
        String generalisation = null;
        for (SensitivityInstance si : this.instances) {
            if (!(si instanceof ConservationInstance) || !this.zones.contains(si.getZone()) && (!si.getZone().getId().equals("AUS") || !SensitivityZone.isInAustralia(this.zones))) continue;
            generalisation = this.maxGeneralisation(generalisation, ((ConservationInstance)si).getLocationGeneralisation());
        }
        return generalisation;
    }

    private String maxGeneralisation(String generalisation1, String generalisation2) {
        int gen2;
        int gen1 = this.toInt(generalisation1);
        if (gen1 > (gen2 = this.toInt(generalisation2))) {
            return generalisation1;
        }
        return generalisation2;
    }

    private int toInt(String generalisation) {
        if (generalisation == null) {
            return 0;
        }
        if (generalisation.equalsIgnoreCase("WITHHOLD")) {
            return Integer.MAX_VALUE;
        }
        if (generalisation.equalsIgnoreCase("10km")) {
            return 10000;
        }
        if (generalisation.equalsIgnoreCase("1km")) {
            return 1000;
        }
        if (generalisation.equalsIgnoreCase("2km")) {
            return 2000;
        }
        if (generalisation.equalsIgnoreCase("100m")) {
            return 100;
        }
        return 0;
    }
}

