/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.Operand;
import org.scale7.cassandra.pelops.exceptions.PelopsException;
import org.scale7.cassandra.pelops.pool.IThriftPool;

public class RowDeletor
extends Operand {
    private final long timestamp;

    public void deleteRow(String columnFamily, String rowKey, ConsistencyLevel cLevel) throws PelopsException {
        this.deleteRow(columnFamily, Bytes.fromUTF8(rowKey), cLevel);
    }

    public void deleteRow(String columnFamily, final Bytes rowKey, final ConsistencyLevel cLevel) throws PelopsException {
        final ColumnPath path = new ColumnPath(columnFamily);
        Operand.IOperation<Void> operation = new Operand.IOperation<Void>(){

            @Override
            public Void execute(IThriftPool.IPooledConnection conn) throws Exception {
                conn.getAPI().remove(Bytes.nullSafeGet(rowKey), path, RowDeletor.this.timestamp, cLevel);
                return null;
            }
        };
        this.tryOperation(operation);
    }

    public RowDeletor(IThriftPool thrift) {
        this(thrift, System.currentTimeMillis() * 1000L);
    }

    public RowDeletor(IThriftPool thrift, long timestamp) {
        super(thrift);
        this.timestamp = timestamp;
    }
}

