/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.util.HashSet;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.transport.TTransportException;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.exceptions.PelopsException;
import org.scale7.cassandra.pelops.pool.IThriftPool;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class Operand {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(Operand.class);
    protected final IThriftPool thrift;

    protected Operand(IThriftPool thrift) {
        this.thrift = thrift;
    }

    protected <ReturnType> ReturnType tryOperation(IOperation<ReturnType> operation) throws PelopsException {
        return this.tryOperation(operation, this.thrift.getOperandPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ReturnType> ReturnType tryOperation(IOperation<ReturnType> operation, OperandPolicy operandPolicy) throws PelopsException {
        HashSet<String> avoidNodes = null;
        Exception lastException = null;
        int retries = 0;
        do {
            IThriftPool.IPooledConnection conn = null;
            try {
                conn = this.thrift.getConnectionExcept(avoidNodes);
            }
            catch (Exception e) {
                throw operandPolicy.getExceptionTranslator().translate(e);
            }
            try {
                ReturnType e = operation.execute(conn);
                return e;
            }
            catch (Exception e) {
                if (e instanceof TimedOutException || e instanceof TTransportException || e instanceof UnavailableException) {
                    logger.warn("Operation failed as result of network exception. Connection to node {} is being marked as corrupt (and will probably be be destroyed). Cause of failure is {}", (Object)conn.getNode().getAddress(), (Object)e);
                    conn.corrupted();
                    if (avoidNodes == null) {
                        avoidNodes = new HashSet<String>(10);
                    }
                    avoidNodes.add(conn.getNode().getAddress());
                    lastException = e;
                    continue;
                }
                if (e instanceof NotFoundException) {
                    throw operandPolicy.getExceptionTranslator().translate(e);
                }
                conn.corrupted();
                throw operandPolicy.getExceptionTranslator().translate(e);
            }
            finally {
                conn.release();
            }
        } while (++retries < operandPolicy.getMaxOpRetries());
        throw operandPolicy.getExceptionTranslator().translate(lastException);
    }

    protected static interface IOperation<ReturnType> {
        public ReturnType execute(IThriftPool.IPooledConnection var1) throws Exception;
    }
}

