/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.ManagerOperand;

public class ColumnFamilyManager
extends ManagerOperand {
    public static final String CFDEF_TYPE_STANDARD = "Standard";
    public static final String CFDEF_TYPE_SUPER = "Super";
    public static final String CFDEF_COMPARATOR_BYTES = "BytesType";
    public static final String CFDEF_COMPARATOR_ASCII = "AsciiType";
    public static final String CFDEF_COMPARATOR_UTF8 = "UTF8Type";
    public static final String CFDEF_COMPARATOR_LONG = "LongType";
    public static final String CFDEF_COMPARATOR_LEXICAL_UUID = "LexicalUUIDType";
    public static final String CFDEF_COMPARATOR_TIME_UUID = "TimeUUIDType";
    public static final String CFDEF_COMPARATOR_INTEGER = "IntegerType";
    public static final String CFDEF_VALIDATION_CLASS_COUNTER = "CounterColumnType";

    public ColumnFamilyManager(Cluster cluster, String keyspace) {
        super(cluster, keyspace);
    }

    public void truncateColumnFamily(final String columnFamily) throws Exception {
        ManagerOperand.IManagerOperation<Void> operation = new ManagerOperand.IManagerOperation<Void>(){

            @Override
            public Void execute(Cassandra.Client conn) throws Exception {
                conn.truncate(columnFamily);
                return null;
            }
        };
        this.tryOperation(operation);
    }

    public String addColumnFamily(final CfDef columnFamilyDefinition) throws Exception {
        ManagerOperand.IManagerOperation<String> operation = new ManagerOperand.IManagerOperation<String>(){

            @Override
            public String execute(Cassandra.Client conn) throws Exception {
                return conn.system_add_column_family(columnFamilyDefinition);
            }
        };
        return this.tryOperation(operation);
    }

    public String updateColumnFamily(final CfDef columnFamilyDefinition) throws Exception {
        ManagerOperand.IManagerOperation<String> operation = new ManagerOperand.IManagerOperation<String>(){

            @Override
            public String execute(Cassandra.Client conn) throws Exception {
                return conn.system_update_column_family(columnFamilyDefinition);
            }
        };
        return this.tryOperation(operation);
    }

    public String dropColumnFamily(final String columnFamily) throws Exception {
        ManagerOperand.IManagerOperation<String> operation = new ManagerOperand.IManagerOperation<String>(){

            @Override
            public String execute(Cassandra.Client conn) throws Exception {
                return conn.system_drop_column_family(columnFamily);
            }
        };
        return this.tryOperation(operation);
    }
}

