/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockClob
implements Clob,
Cloneable {
    private static final Log log = LogFactory.getLog((Class)(class$com$mockrunner$mock$jdbc$MockClob == null ? (class$com$mockrunner$mock$jdbc$MockClob = MockClob.class$("com.mockrunner.mock.jdbc.MockClob")) : class$com$mockrunner$mock$jdbc$MockClob));
    private StringBuffer clobData;
    static /* synthetic */ Class class$com$mockrunner$mock$jdbc$MockClob;

    public MockClob(String string) {
        this.clobData = new StringBuffer(string);
    }

    public long length() throws SQLException {
        return this.clobData.length();
    }

    public void truncate(long l) throws SQLException {
        this.clobData.setLength((int)l);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ByteArrayInputStream(this.clobData.toString().getBytes());
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        return new ClobOutputStream((int)(l - 1L));
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.clobData.toString());
    }

    public Writer setCharacterStream(long l) throws SQLException {
        return new ClobWriter((int)(l - 1L));
    }

    public String getSubString(long l, int n) throws SQLException {
        return this.clobData.substring((int)(l - 1L), (int)(l - 1L) + n);
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        string = string.substring(n, n + n2);
        this.clobData.replace((int)(l - 1L), (int)(l - 1L) + string.length(), string);
        return n2;
    }

    public long position(String string, long l) throws SQLException {
        int n = this.clobData.toString().indexOf(string, (int)(l - 1L));
        if (-1 != n) {
            ++n;
        }
        return n;
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MockClob mockClob = (MockClob)object;
        return this.clobData.toString().equals(mockClob.clobData.toString());
    }

    public int hashCode() {
        return this.clobData.toString().hashCode();
    }

    public String toString() {
        return "Clob data: " + this.clobData.toString();
    }

    public Object clone() {
        try {
            MockClob mockClob = (MockClob)super.clone();
            mockClob.clobData = new StringBuffer(this.clobData.toString());
            return mockClob;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error((Object)cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ClobOutputStream
    extends OutputStream {
        private int index;

        public ClobOutputStream(int n) {
            this.index = n;
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            try {
                MockClob.this.setString(this.index + 1, new String(byArray));
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            ++this.index;
        }
    }

    private class ClobWriter
    extends Writer {
        private int index;

        public ClobWriter(int n) {
            this.index = n;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            try {
                MockClob.this.setString(this.index + 1, new String(cArray, n, n2));
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            ++this.index;
        }
    }
}

