/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.factory.Hints;
import org.geotools.util.CommonsConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.xml.impl.DatatypeConverterImpl;

public class XmlConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (String.class.equals((Object)target) ? Date.class.isAssignableFrom(source) || Calendar.class.isAssignableFrom(source) : String.class.equals((Object)source) && (Date.class.isAssignableFrom(target) || Calendar.class.isAssignableFrom(target))) {
            return new XmlConverter();
        }
        return null;
    }

    static class XmlConverter
    implements Converter {
        XmlConverter() {
        }

        public Object convert(Object source, Class target) throws Exception {
            if (String.class.equals((Object)target)) {
                return this.convertToString(source);
            }
            return this.convertFromString((String)source, target);
        }

        private Object convertFromString(String source, Class<?> target) {
            Calendar date;
            block15: {
                if (!Calendar.class.equals(target) && !Date.class.isAssignableFrom(target)) {
                    return null;
                }
                try {
                    Converter converter = new CommonsConverterFactory().createConverter(String.class, target, null);
                    if (converter == null) break block15;
                    Object converted = null;
                    try {
                        converted = converter.convert(source, target);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (converted != null) {
                        return converted;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                try {
                    date = DatatypeConverterImpl.getInstance().parseDateTime(source);
                }
                catch (Exception e) {
                    date = DatatypeConverterImpl.getInstance().parseDate(source);
                }
            }
            catch (Exception e) {
                date = DatatypeConverterImpl.getInstance().parseTime(source);
            }
            if (Calendar.class.equals(target)) {
                return date;
            }
            if (Date.class.isAssignableFrom(target)) {
                Date time = date.getTime();
                if (java.sql.Date.class.equals(target)) {
                    return new java.sql.Date(time.getTime());
                }
                if (Time.class.equals(target)) {
                    return new Time(time.getTime());
                }
                if (Timestamp.class.equals(target)) {
                    return new Timestamp(time.getTime());
                }
                return time;
            }
            return null;
        }

        private String convertToString(Object unconvertedValue) {
            String textValue = null;
            if (unconvertedValue instanceof Calendar) {
                Calendar cal = (Calendar)unconvertedValue;
                textValue = DatatypeConverterImpl.getInstance().printDateTime(cal);
            } else if (unconvertedValue instanceof Date) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal.setTimeInMillis(((Date)unconvertedValue).getTime());
                DatatypeConverterImpl converter = DatatypeConverterImpl.getInstance();
                textValue = unconvertedValue instanceof java.sql.Date ? converter.printDate(cal) : (unconvertedValue instanceof Time ? converter.printTime(cal) : converter.printDateTime(cal));
            }
            return textValue;
        }
    }
}

