/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Geometry;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AbstractGeometryTypeBinding
extends AbstractComplexBinding {
    Configuration config;
    SrsSyntax srsSyntax;

    public AbstractGeometryTypeBinding(Configuration config, SrsSyntax srsSyntax) {
        this.config = config;
        this.srsSyntax = srsSyntax;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void setSrsSyntax(SrsSyntax srsSyntax) {
        this.srsSyntax = srsSyntax;
    }

    public QName getTarget() {
        return GML.AbstractGeometryType;
    }

    public Class getType() {
        return Geometry.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs;
        if (value instanceof Geometry && (crs = GML3ParsingUtils.crs(node)) != null) {
            Geometry geometry = (Geometry)value;
            geometry.setUserData(crs);
        }
        return value;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        CoordinateReferenceSystem crs;
        Geometry geometry = (Geometry)object;
        if ("srsName".equals(name.getLocalPart()) && (crs = GML3EncodingUtils.getCRS(geometry)) != null) {
            return GML3EncodingUtils.toURI(crs, this.srsSyntax);
        }
        if ("srsDimension".equals(name.getLocalPart())) {
            if (GMLEncodingUtils.isEmpty((Geometry)geometry)) {
                return null;
            }
            if (this.config.hasProperty(GMLConfiguration.NO_SRS_DIMENSION)) {
                return null;
            }
            return CoordinateSequences.coordinateDimension((Geometry)geometry);
        }
        if ("id".equals(name.getLocalPart())) {
            return GML3EncodingUtils.getID(geometry);
        }
        if ("name".equals(name.getLocalPart())) {
            return GML3EncodingUtils.getName(geometry);
        }
        if ("description".equals(name.getLocalPart())) {
            return GML3EncodingUtils.getDescription(geometry);
        }
        if ("uomLabels".equals(name.getLocalPart())) {
            return GML3EncodingUtils.getUomLabels(geometry);
        }
        if ("axisLabels".equals(name.getLocalPart())) {
            return GML3EncodingUtils.getAxisLabels(geometry);
        }
        return null;
    }
}

