@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup
set REPO=
if exist "%BASEDIR%\bin\environmentSetupFile.sh.bat" call "%BASEDIR%\bin\environmentSetupFile.sh.bat"

if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\biocache-store-2.3.8.jar;"%REPO%"\cassandra-driver-core-3.5.1.jar;"%REPO%"\netty-handler-4.0.56.Final.jar;"%REPO%"\netty-buffer-4.0.56.Final.jar;"%REPO%"\netty-common-4.0.56.Final.jar;"%REPO%"\netty-transport-4.0.56.Final.jar;"%REPO%"\netty-codec-4.0.56.Final.jar;"%REPO%"\metrics-core-3.2.2.jar;"%REPO%"\jnr-ffi-2.1.7.jar;"%REPO%"\jffi-1.2.16.jar;"%REPO%"\jffi-1.2.16-native.jar;"%REPO%"\asm-analysis-5.0.3.jar;"%REPO%"\asm-tree-5.0.3.jar;"%REPO%"\asm-util-5.0.3.jar;"%REPO%"\jnr-x86asm-1.0.2.jar;"%REPO%"\jnr-posix-3.0.44.jar;"%REPO%"\jnr-constants-0.9.9.jar;"%REPO%"\cassandra-driver-mapping-3.5.1.jar;"%REPO%"\cassandra-driver-extras-3.5.1.jar;"%REPO%"\postgresql-9.1-901.jdbc3.jar;"%REPO%"\slick_2.10-1.0.1.jar;"%REPO%"\slick-pg_2.10.1-0.1.3.jar;"%REPO%"\postgresql-9.2-1003-jdbc4.jar;"%REPO%"\layers-store-1.3.jar;"%REPO%"\persistence-api-1.0.jar;"%REPO%"\c3p0-0.9.1.2.jar;"%REPO%"\ands-pid-client-1.0.07.jar;"%REPO%"\json-lib-2.4-jdk15.jar;"%REPO%"\ezmorph-1.0.6.jar;"%REPO%"\opencsv-2.3.jar;"%REPO%"\gt-svg-11.1.jar;"%REPO%"\batik-transcoder-1.7.jar;"%REPO%"\fop-0.94.jar;"%REPO%"\xmlgraphics-commons-1.2.jar;"%REPO%"\avalon-framework-api-4.3.1.jar;"%REPO%"\avalon-framework-impl-4.3.1.jar;"%REPO%"\batik-awt-util-1.7.jar;"%REPO%"\batik-bridge-1.7.jar;"%REPO%"\batik-anim-1.7.jar;"%REPO%"\batik-css-1.7.jar;"%REPO%"\batik-ext-1.7.jar;"%REPO%"\batik-parser-1.7.jar;"%REPO%"\batik-script-1.7.jar;"%REPO%"\batik-js-1.7.jar;"%REPO%"\batik-dom-1.7.jar;"%REPO%"\batik-gvt-1.7.jar;"%REPO%"\batik-svg-dom-1.7.jar;"%REPO%"\batik-svggen-1.7.jar;"%REPO%"\batik-util-1.7.jar;"%REPO%"\batik-xml-1.7.jar;"%REPO%"\xml-apis-ext-1.3.04.jar;"%REPO%"\gt-render-11.1.jar;"%REPO%"\gt-cql-11.1.jar;"%REPO%"\gt-wms-11.1.jar;"%REPO%"\gt-xml-11.1.jar;"%REPO%"\xml-commons-resolver-1.2.jar;"%REPO%"\gt-imageio-ext-gdal-11.1.jar;"%REPO%"\imageio-ext-gdalarcbinarygrid-1.1.9.jar;"%REPO%"\imageio-ext-gdalframework-1.1.9.jar;"%REPO%"\imageio-ext-gdal-bindings-1.9.2.jar;"%REPO%"\imageio-ext-streams-1.1.9.jar;"%REPO%"\imageio-ext-geocore-1.1.9.jar;"%REPO%"\imageio-ext-gdalmrsid-1.1.9.jar;"%REPO%"\imageio-ext-gdalecw-1.1.9.jar;"%REPO%"\imageio-ext-gdaldted-1.1.9.jar;"%REPO%"\imageio-ext-gdalkakadujp2-1.1.9.jar;"%REPO%"\imageio-ext-gdalmrsidjp2-1.1.9.jar;"%REPO%"\imageio-ext-gdalecwjp2-1.1.9.jar;"%REPO%"\imageio-ext-gdalehdr-1.1.9.jar;"%REPO%"\imageio-ext-gdalenvihdr-1.1.9.jar;"%REPO%"\imageio-ext-gdalerdasimg-1.1.9.jar;"%REPO%"\imageio-ext-gdalnitf-1.1.9.jar;"%REPO%"\imageio-ext-gdalrpftoc-1.1.9.jar;"%REPO%"\imageio-ext-gdalidrisi-1.1.9.jar;"%REPO%"\imageio-ext-imagereadmt-1.1.9.jar;"%REPO%"\cglib-2.2.2.jar;"%REPO%"\asm-3.3.1.jar;"%REPO%"\commons-io-2.5.jar;"%REPO%"\mockrunner-0.3.6.jar;"%REPO%"\spring-core-3.2.18.RELEASE.jar;"%REPO%"\commons-logging-1.1.3.jar;"%REPO%"\spring-context-3.2.18.RELEASE.jar;"%REPO%"\spring-aop-3.2.18.RELEASE.jar;"%REPO%"\spring-beans-3.2.18.RELEASE.jar;"%REPO%"\spring-expression-3.2.18.RELEASE.jar;"%REPO%"\spring-context-support-3.2.18.RELEASE.jar;"%REPO%"\spring-jdbc-3.2.18.RELEASE.jar;"%REPO%"\spring-tx-3.2.18.RELEASE.jar;"%REPO%"\spring-orm-3.2.18.RELEASE.jar;"%REPO%"\spring-oxm-3.2.18.RELEASE.jar;"%REPO%"\log4j-1.2.17.jar;"%REPO%"\slf4j-log4j12-1.7.21.jar;"%REPO%"\slf4j-api-1.7.21.jar;"%REPO%"\ant-1.8.2.jar;"%REPO%"\ant-launcher-1.8.2.jar;"%REPO%"\sds-1.4.4.jar;"%REPO%"\commons-dbcp-1.4.jar;"%REPO%"\drools-core-6.5.0.Final.jar;"%REPO%"\mvel2-2.2.8.Final.jar;"%REPO%"\kie-api-6.5.0.Final.jar;"%REPO%"\kie-internal-6.5.0.Final.jar;"%REPO%"\ecj-4.5.1.jar;"%REPO%"\drools-compiler-6.5.0.Final.jar;"%REPO%"\antlr-runtime-3.5.jar;"%REPO%"\xstream-1.4.9.jar;"%REPO%"\xmlpull-1.1.3.1.jar;"%REPO%"\xpp3_min-1.1.4c.jar;"%REPO%"\jdom-2.0.2.jar;"%REPO%"\joda-time-2.9.9.jar;"%REPO%"\poi-3.17.jar;"%REPO%"\commons-collections4-4.1.jar;"%REPO%"\poi-ooxml-3.17.jar;"%REPO%"\curvesapi-1.04.jar;"%REPO%"\poi-ooxml-schemas-3.17.jar;"%REPO%"\xmlbeans-2.6.0.jar;"%REPO%"\dom4j-2.1.0.jar;"%REPO%"\jaxen-1.1.6.jar;"%REPO%"\ala-name-matching-3.3.jar;"%REPO%"\commons-collections-3.2.jar;"%REPO%"\ecat-common-1.6.jar;"%REPO%"\trove-2.1.0.jar;"%REPO%"\commons-lang-2.5.jar;"%REPO%"\opencsv-4.1.jar;"%REPO%"\commons-text-1.1.jar;"%REPO%"\simmetrics-1.6.2.jar;"%REPO%"\commons-cli-1.2.jar;"%REPO%"\lucene-queries-6.6.5.jar;"%REPO%"\lucene-core-6.6.5.jar;"%REPO%"\lucene-codecs-6.6.5.jar;"%REPO%"\lucene-backward-codecs-6.6.5.jar;"%REPO%"\dwca-io-1.31.jar;"%REPO%"\dwc-api-1.17.jar;"%REPO%"\registry-metadata-2.59.jar;"%REPO%"\gbif-parsers-0.28.jar;"%REPO%"\tika-core-1.13.jar;"%REPO%"\name-parser-2.18.jar;"%REPO%"\threetenbp-1.3.2.jar;"%REPO%"\gbif-api-0.46.jar;"%REPO%"\commons-digester3-3.2.jar;"%REPO%"\freemarker-2.3.25-incubating.jar;"%REPO%"\gbif-common-0.35.jar;"%REPO%"\owasp-java-html-sanitizer-20160924.1.jar;"%REPO%"\commons-beanutils-1.9.2.jar;"%REPO%"\guava-24.0-jre.jar;"%REPO%"\jsr305-1.3.9.jar;"%REPO%"\checker-compat-qual-2.0.0.jar;"%REPO%"\error_prone_annotations-2.1.3.jar;"%REPO%"\j2objc-annotations-1.1.jar;"%REPO%"\animal-sniffer-annotations-1.14.jar;"%REPO%"\guice-3.0.jar;"%REPO%"\javax.inject-1.jar;"%REPO%"\aopalliance-1.0.jar;"%REPO%"\jackson-core-2.9.6.jar;"%REPO%"\jackson-databind-2.9.6.jar;"%REPO%"\jackson-annotations-2.9.6.jar;"%REPO%"\jackson-module-scala_2.10-2.9.6.jar;"%REPO%"\jackson-module-paranamer-2.9.6.jar;"%REPO%"\paranamer-2.8.jar;"%REPO%"\scala-library-2.10.4.jar;"%REPO%"\scala-actors-2.10.4.jar;"%REPO%"\scala-reflect-2.10.4.jar;"%REPO%"\scalatest_2.10-1.9.jar;"%REPO%"\zip4j-1.3.2.jar;"%REPO%"\scale7-pelops-1.3-1.0.x.jar;"%REPO%"\cassandra-thrift-1.0.6.jar;"%REPO%"\libthrift-0.6.1.jar;"%REPO%"\uuid-3.2.jar;"%REPO%"\scale7-core-1.3.jar;"%REPO%"\commons-pool-1.5.5.jar;"%REPO%"\jsch-0.1.54.jar;"%REPO%"\SecureChannelFacade-0.2.jar;"%REPO%"\solr-core-6.6.5.jar;"%REPO%"\lucene-analyzers-common-6.6.5.jar;"%REPO%"\lucene-analyzers-kuromoji-6.6.5.jar;"%REPO%"\lucene-analyzers-phonetic-6.6.5.jar;"%REPO%"\lucene-classification-6.6.5.jar;"%REPO%"\lucene-expressions-6.6.5.jar;"%REPO%"\lucene-grouping-6.6.5.jar;"%REPO%"\lucene-highlighter-6.6.5.jar;"%REPO%"\lucene-join-6.6.5.jar;"%REPO%"\lucene-memory-6.6.5.jar;"%REPO%"\lucene-misc-6.6.5.jar;"%REPO%"\lucene-queryparser-6.6.5.jar;"%REPO%"\lucene-sandbox-6.6.5.jar;"%REPO%"\lucene-spatial-extras-6.6.5.jar;"%REPO%"\lucene-suggest-6.6.5.jar;"%REPO%"\hppc-0.7.1.jar;"%REPO%"\jackson-dataformat-smile-2.9.6.jar;"%REPO%"\caffeine-2.4.0.jar;"%REPO%"\protobuf-java-3.1.0.jar;"%REPO%"\t-digest-3.1.jar;"%REPO%"\commons-codec-1.10.jar;"%REPO%"\commons-configuration-1.6.jar;"%REPO%"\commons-fileupload-1.3.2.jar;"%REPO%"\dom4j-1.6.1.jar;"%REPO%"\gmetric4j-1.0.7.jar;"%REPO%"\metrics-ganglia-3.2.2.jar;"%REPO%"\metrics-graphite-3.2.2.jar;"%REPO%"\metrics-jetty9-3.2.2.jar;"%REPO%"\metrics-jvm-3.2.2.jar;"%REPO%"\javax.servlet-api-3.1.0.jar;"%REPO%"\eigenbase-properties-1.1.5.jar;"%REPO%"\antlr4-runtime-4.5.1-1.jar;"%REPO%"\calcite-core-1.11.0.jar;"%REPO%"\calcite-linq4j-1.11.0.jar;"%REPO%"\avatica-core-1.9.0.jar;"%REPO%"\commons-exec-1.3.jar;"%REPO%"\curator-client-2.8.0.jar;"%REPO%"\curator-framework-2.8.0.jar;"%REPO%"\curator-recipes-2.8.0.jar;"%REPO%"\hadoop-auth-2.7.4.jar;"%REPO%"\htrace-core-3.2.0-incubating.jar;"%REPO%"\zookeeper-3.4.10.jar;"%REPO%"\jackson-core-asl-1.9.13.jar;"%REPO%"\jackson-mapper-asl-1.9.13.jar;"%REPO%"\commons-compiler-2.7.6.jar;"%REPO%"\janino-2.7.6.jar;"%REPO%"\stax2-api-3.1.4.jar;"%REPO%"\woodstox-core-asl-4.4.1.jar;"%REPO%"\jetty-continuation-9.3.14.v20161028.jar;"%REPO%"\jetty-deploy-9.3.14.v20161028.jar;"%REPO%"\jetty-http-9.3.14.v20161028.jar;"%REPO%"\jetty-io-9.3.14.v20161028.jar;"%REPO%"\jetty-jmx-9.3.14.v20161028.jar;"%REPO%"\jetty-rewrite-9.3.14.v20161028.jar;"%REPO%"\jetty-security-9.3.14.v20161028.jar;"%REPO%"\jetty-server-9.3.14.v20161028.jar;"%REPO%"\jetty-servlet-9.3.14.v20161028.jar;"%REPO%"\jetty-servlets-9.3.14.v20161028.jar;"%REPO%"\jetty-util-9.3.14.v20161028.jar;"%REPO%"\jetty-webapp-9.3.14.v20161028.jar;"%REPO%"\jetty-xml-9.3.14.v20161028.jar;"%REPO%"\spatial4j-0.6.jar;"%REPO%"\noggit-0.6.jar;"%REPO%"\asm-5.1.jar;"%REPO%"\asm-commons-5.1.jar;"%REPO%"\org.restlet-2.3.0.jar;"%REPO%"\org.restlet.ext.servlet-2.3.0.jar;"%REPO%"\solr-solrj-6.6.5.jar;"%REPO%"\jcl-over-slf4j-1.7.7.jar;"%REPO%"\servlet-api-2.5.jar;"%REPO%"\jts-1.13.jar;"%REPO%"\httpclient-4.5.5.jar;"%REPO%"\httpmime-4.5.5.jar;"%REPO%"\httpclient-cache-4.5.5.jar;"%REPO%"\httpcore-4.4.9.jar;"%REPO%"\commons-httpclient-3.1.jar;"%REPO%"\commons-lang3-3.6.jar;"%REPO%"\json-path-0.9.1.jar;"%REPO%"\json-smart-1.2.jar;"%REPO%"\commons-httpclient-contrib-3.1.jar;"%REPO%"\commons-compress-1.12.jar;"%REPO%"\commons-math3-3.6.1.jar;"%REPO%"\high-scale-lib-1.0.jar;"%REPO%"\concurrentlinkedhashmap-lru-1.4.2.jar;"%REPO%"\metadata-extractor-2.5.0-RC3.jar;"%REPO%"\xmpcore-1.0.jar;"%REPO%"\jai-core-1.1.3.jar;"%REPO%"\jai-codec-1.1.3.jar;"%REPO%"\jai-imageio-1.1.jar;"%REPO%"\gt-api-11.1.jar;"%REPO%"\jai_core-1.1.3.jar;"%REPO%"\gt-main-11.1.jar;"%REPO%"\gt-opengis-11.1.jar;"%REPO%"\jsr-275-1.0-beta-2.jar;"%REPO%"\vecmath-1.3.2.jar;"%REPO%"\gt-coverage-11.1.jar;"%REPO%"\jai_imageio-1.1.jar;"%REPO%"\imageio-ext-tiff-1.1.9.jar;"%REPO%"\imageio-ext-utilities-1.1.9.jar;"%REPO%"\jai_codec-1.1.3.jar;"%REPO%"\jt-zonalstats-1.3.1.jar;"%REPO%"\jt-utils-1.3.1.jar;"%REPO%"\gt-shapefile-11.1.jar;"%REPO%"\gt-graph-11.1.jar;"%REPO%"\gt-data-11.1.jar;"%REPO%"\gt-geojson-11.1.jar;"%REPO%"\json-simple-1.1.jar;"%REPO%"\gt-referencing-11.1.jar;"%REPO%"\jgridshift-1.0.jar;"%REPO%"\gt-metadata-11.1.jar;"%REPO%"\gt-xsd-core-11.1.jar;"%REPO%"\picocontainer-1.2.jar;"%REPO%"\xml-apis-1.0.b2.jar;"%REPO%"\commons-jxpath-1.3.jar;"%REPO%"\common-2.6.0.jar;"%REPO%"\ecore-2.6.1.jar;"%REPO%"\xsd-2.6.0.jar;"%REPO%"\gt-xsd-kml-11.1.jar;"%REPO%"\gt-xsd-gml2-11.1.jar;"%REPO%"\gt-xsd-gml3-11.1.jar;"%REPO%"\gt-epsg-hsql-11.1.jar;"%REPO%"\hsqldb-2.2.8.jar;"%REPO%"\htmlunit-2.5.jar;"%REPO%"\xalan-2.7.1.jar;"%REPO%"\serializer-2.7.1.jar;"%REPO%"\htmlunit-core-js-2.5.jar;"%REPO%"\nekohtml-1.9.12.jar;"%REPO%"\xercesImpl-2.8.1.jar;"%REPO%"\cssparser-0.9.5.jar;"%REPO%"\sac-1.3.jar;"%REPO%"\crawler-0.36.jar;"%REPO%"\gbif-wrangler-0.2.jar;"%REPO%"\validation-api-1.1.0.Final.jar;"%REPO%"\stax-api-1.0-2.jar

set ENDORSED_DIR=
if NOT "%ENDORSED_DIR%" == "" set CLASSPATH="%BASEDIR%"\%ENDORSED_DIR%\*;%CLASSPATH%

if NOT "%CLASSPATH_PREFIX%" == "" set CLASSPATH=%CLASSPATH_PREFIX%;%CLASSPATH%

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% $BIOCACHE_MEMORY_OPTS $BIOCACHE_OPTS -Dhostname=$(hostname) -XX:+UseG1GC -Dfile.encoding=UTF8 -Dlog4j.configuration=log4j.xml -Dactors.corePoolSize=8 -Dactors.maxPoolSize=16 -Dactors.minPoolSize=8 -Djava.util.Arrays.useLegacyMergeSort=true -Dactors.maxPoolSize=8 -classpath %CLASSPATH% -Dapp.name="biocache" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" au.org.ala.biocache.cmd.CMD2 %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
