/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwca.io;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.gbif.dwca.io.Archive;
import org.gbif.registry.metadata.EMLWriter;

public class MetaDescriptorWriter {
    private static final String META_TEMPLATE = "meta.ftl";
    private static final String TEMPLATE_PATH = "/templates";
    private static final Configuration FTL = MetaDescriptorWriter.provideFreemarker();

    private MetaDescriptorWriter() {
    }

    public static void writeMetaFile(Archive archive) throws IOException {
        MetaDescriptorWriter.writeMetaFile(new File(archive.getLocation(), "meta.xml"), archive);
    }

    public static void writeMetaFile(File f, Archive archive) throws IOException {
        FileWriter writer = new FileWriter(f);
        try {
            FTL.getTemplate(META_TEMPLATE).process((Object)archive, (Writer)writer);
        }
        catch (TemplateException e) {
            throw new IOException("Error while processing the meta.xml template", e);
        }
        ((Writer)writer).close();
    }

    private static Configuration provideFreemarker() {
        ClassTemplateLoader tl = new ClassTemplateLoader(EMLWriter.class, TEMPLATE_PATH);
        Configuration fm = new Configuration();
        fm.setDefaultEncoding("utf8");
        fm.setTemplateLoader((TemplateLoader)tl);
        return fm;
    }
}

