/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal;

import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverageio.BaseGridCoverage2DReader;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class BaseGDALGridCoverage2DReader
extends BaseGridCoverage2DReader
implements GridCoverage2DReader {
    protected static final String DEFAULT_WORLDFILE_EXT = ".wld";
    private static final Logger LOGGER = Logging.getLogger((String)BaseGDALGridCoverage2DReader.class.toString());

    protected BaseGDALGridCoverage2DReader(Object input, Hints hints, String worldFileExtension, ImageReaderSpi formatSpecificSpi) throws DataSourceException {
        super(input, hints, worldFileExtension, formatSpecificSpi);
    }

    @Override
    protected void setCoverageProperties(ImageReader reader) throws IOException {
        IIOMetadata metadata = reader.getImageMetadata(0);
        if (!(metadata instanceof GDALCommonIIOImageMetadata)) {
            throw new DataSourceException("Unexpected error! Metadata should be an instance of the expected class: GDALCommonIIOImageMetadata.");
        }
        this.parseCommonMetadata((GDALCommonIIOImageMetadata)metadata);
        if (this.crs == null) {
            LOGGER.info("crs not found, proceeding with default crs");
            this.crs = AbstractGridFormat.getDefaultCRS();
        }
        if (this.originalEnvelope == null) {
            throw new DataSourceException("Unable to compute the envelope for this coverage");
        }
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
    }

    private void parseCommonMetadata(GDALCommonIIOImageMetadata metadata) {
        double[] geoTransform;
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, "Using default coordinate reference system ");
        } else {
            String wkt;
            this.parsePRJFile();
            if (this.crs == null && (wkt = metadata.getProjection()) != null && !wkt.equalsIgnoreCase("")) {
                try {
                    this.crs = CRS.parseWKT((String)wkt);
                    Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)this.crs, (boolean)true);
                    if (epsgCode != null) {
                        this.crs = CRS.decode((String)("EPSG:" + epsgCode));
                    }
                }
                catch (FactoryException fe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Unable to get CRS from WKT contained in metadata. Looking for a PRJ.");
                    }
                    this.crs = null;
                }
            }
        }
        if (this.originalGridRange == null) {
            this.originalGridRange = new GridEnvelope2D(new Rectangle(0, 0, metadata.getWidth(), metadata.getHeight()));
        }
        this.parseWorldFile();
        if (this.originalEnvelope == null && (geoTransform = metadata.getGeoTransformation()) != null && geoTransform.length == 6) {
            AffineTransform tempTransform;
            block14: {
                tempTransform = new AffineTransform(geoTransform[1], geoTransform[4], geoTransform[2], geoTransform[5], geoTransform[0], geoTransform[3]);
                if (this.originalEnvelope == null) {
                    try {
                        this.originalEnvelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)((GridEnvelope2D)this.originalGridRange)));
                    }
                    catch (IllegalStateException e) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                    }
                    catch (TransformException e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block14;
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
            }
            double tr = -PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER);
            tempTransform.translate(tr, tr);
            this.raster2Model = ProjectiveTransform.create((AffineTransform)tempTransform);
        }
    }
}

