/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

public enum Kingdom {
    INCERTAE_SEDIS,
    ANIMALIA,
    ARCHAEA,
    BACTERIA,
    CHROMISTA,
    FUNGI,
    PLANTAE,
    PROTOZOA,
    VIRUSES;

    private static final int INCERTAE_SEDIS_NAME_ID = 9;

    public static Kingdom byNubUsageId(Integer usageID) {
        for (Kingdom term : Kingdom.values()) {
            if (!term.nubUsageID().equals(usageID)) continue;
            return term;
        }
        return null;
    }

    public String scientificName() {
        String lower = this.name().replaceAll("_", " ").toLowerCase();
        return this == INCERTAE_SEDIS ? lower : Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    public Integer nubUsageID() {
        return this.ordinal();
    }

    public Integer clbNameID() {
        return this == INCERTAE_SEDIS ? 9 : this.ordinal();
    }
}

