/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import org.gbif.api.util.VocabularyUtils;

public enum ContactType {
    TECHNICAL_POINT_OF_CONTACT,
    ADMINISTRATIVE_POINT_OF_CONTACT,
    POINT_OF_CONTACT,
    ORIGINATOR,
    METADATA_AUTHOR,
    PRINCIPAL_INVESTIGATOR,
    AUTHOR,
    CONTENT_PROVIDER,
    CUSTODIAN_STEWARD,
    DISTRIBUTOR,
    EDITOR,
    OWNER,
    PROCESSOR,
    PUBLISHER,
    USER,
    PROGRAMMER,
    CURATOR,
    DATA_ADMINISTRATOR,
    SYSTEM_ADMINISTRATOR,
    HEAD_OF_DELEGATION,
    TEMPORARY_HEAD_OF_DELEGATION,
    ADDITIONAL_DELEGATE,
    TEMPORARY_DELEGATE,
    REGIONAL_NODE_REPRESENTATIVE,
    NODE_MANAGER,
    NODE_STAFF;

    private static final ImmutableMap<String, ContactType> TYPE_LOOKUP;

    public static ContactType fromString(String contactType) {
        return VocabularyUtils.lookupEnum(contactType, ContactType.class);
    }

    public static ContactType inferType(@Nullable String type) {
        if (type != null) {
            ContactType contactType = (ContactType)((Object)TYPE_LOOKUP.get((Object)type.toLowerCase()));
            if (contactType != null) {
                return contactType;
            }
            return ContactType.fromString(type);
        }
        return null;
    }

    static {
        TYPE_LOOKUP = ImmutableMap.builder().put((Object)"administrative", (Object)ADMINISTRATIVE_POINT_OF_CONTACT).put((Object)"technical", (Object)TECHNICAL_POINT_OF_CONTACT).put((Object)"pointofcontact", (Object)POINT_OF_CONTACT).put((Object)"originator", (Object)ORIGINATOR).put((Object)"metadataprovider", (Object)METADATA_AUTHOR).put((Object)"principleinvestigator", (Object)PRINCIPAL_INVESTIGATOR).put((Object)"author", (Object)AUTHOR).put((Object)"contentprovider", (Object)CONTENT_PROVIDER).put((Object)"custodiansteward", (Object)CUSTODIAN_STEWARD).put((Object)"distributor", (Object)DISTRIBUTOR).put((Object)"editor", (Object)EDITOR).put((Object)"owner", (Object)OWNER).put((Object)"processor", (Object)PROCESSOR).put((Object)"publisher", (Object)PUBLISHER).put((Object)"user", (Object)USER).put((Object)"programmer", (Object)PROGRAMMER).put((Object)"curator", (Object)CURATOR).put((Object)"data administrator", (Object)DATA_ADMINISTRATOR).put((Object)"system adminsitrator", (Object)SYSTEM_ADMINISTRATOR).put((Object)"system administrator", (Object)SYSTEM_ADMINISTRATOR).build();
    }
}

