/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.gbif.api.model.common.Identifier;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.model.common.MediaObject;
import org.gbif.api.model.occurrence.FactOrMeasurment;
import org.gbif.api.model.occurrence.OccurrenceRelation;
import org.gbif.api.model.occurrence.VerbatimOccurrence;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.BasisOfRecord;
import org.gbif.api.vocabulary.Continent;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.EstablishmentMeans;
import org.gbif.api.vocabulary.License;
import org.gbif.api.vocabulary.LifeStage;
import org.gbif.api.vocabulary.OccurrenceIssue;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.Sex;
import org.gbif.api.vocabulary.TypeStatus;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.UnknownTerm;

public class Occurrence
extends VerbatimOccurrence
implements LinneanClassification,
LinneanClassificationKeys {
    public static final String GEO_DATUM = "WGS84";
    private static final Set<String> PROPERTIES = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{DwcTerm.geodeticDatum.simpleName(), "class", "countryCode"}), (Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)Lists.newArrayList((Object[])Occurrence.class.getDeclaredFields()), (Iterable)Lists.newArrayList((Object[])VerbatimOccurrence.class.getDeclaredFields())), (Function)new Function<Field, String>(){

        @Nullable
        public String apply(@Nullable Field f) {
            return f.getName();
        }
    })));
    private BasisOfRecord basisOfRecord;
    private Integer individualCount;
    private Sex sex;
    private LifeStage lifeStage;
    private EstablishmentMeans establishmentMeans;
    private Integer taxonKey;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;
    private String scientificName;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private String genericName;
    private String specificEpithet;
    private String infraspecificEpithet;
    private Rank taxonRank;
    private Date dateIdentified;
    private Double decimalLongitude;
    private Double decimalLatitude;
    private Double coordinatePrecision;
    private Double coordinateUncertaintyInMeters;
    @Deprecated
    private Double coordinateAccuracy;
    private Double elevation;
    private Double elevationAccuracy;
    private Double depth;
    private Double depthAccuracy;
    private Continent continent;
    @JsonSerialize(using=Country.IsoSerializer.class)
    @JsonDeserialize(using=Country.IsoDeserializer.class)
    private Country country;
    private String stateProvince;
    private String waterBody;
    private Integer year;
    private Integer month;
    private Integer day;
    private Date eventDate;
    private TypeStatus typeStatus;
    private String typifiedName;
    private Set<OccurrenceIssue> issues = EnumSet.noneOf(OccurrenceIssue.class);
    private Date modified;
    private Date lastInterpreted;
    private URI references;
    private License license;
    private List<Identifier> identifiers = Lists.newArrayList();
    private List<MediaObject> media = Lists.newArrayList();
    private List<FactOrMeasurment> facts = Lists.newArrayList();
    private List<OccurrenceRelation> relations = Lists.newArrayList();

    public Occurrence() {
    }

    public Occurrence(@Nullable VerbatimOccurrence verbatim) {
        if (verbatim != null) {
            this.setKey(verbatim.getKey());
            this.setDatasetKey(verbatim.getDatasetKey());
            this.setPublishingOrgKey(verbatim.getPublishingOrgKey());
            this.setPublishingCountry(verbatim.getPublishingCountry());
            this.setProtocol(verbatim.getProtocol());
            if (verbatim.getLastCrawled() != null) {
                this.setLastCrawled(new Date(verbatim.getLastCrawled().getTime()));
            }
            if (verbatim.getVerbatimFields() != null) {
                this.getVerbatimFields().putAll(verbatim.getVerbatimFields());
            }
            if (verbatim.getLastParsed() != null) {
                this.setLastParsed(verbatim.getLastParsed());
            }
            this.setExtensions(verbatim.getExtensions());
        }
    }

    @Nullable
    public BasisOfRecord getBasisOfRecord() {
        return this.basisOfRecord;
    }

    public void setBasisOfRecord(BasisOfRecord basisOfRecord) {
        this.basisOfRecord = basisOfRecord;
    }

    @Nullable
    public Integer getIndividualCount() {
        return this.individualCount;
    }

    public void setIndividualCount(Integer individualCount) {
        this.individualCount = individualCount;
    }

    @Nullable
    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    @Nullable
    public LifeStage getLifeStage() {
        return this.lifeStage;
    }

    public void setLifeStage(LifeStage lifeStage) {
        this.lifeStage = lifeStage;
    }

    @Nullable
    public EstablishmentMeans getEstablishmentMeans() {
        return this.establishmentMeans;
    }

    public void setEstablishmentMeans(EstablishmentMeans establishmentMeans) {
        this.establishmentMeans = establishmentMeans;
    }

    @Nullable
    public Integer getTaxonKey() {
        return this.taxonKey;
    }

    public void setTaxonKey(Integer taxonKey) {
        this.taxonKey = taxonKey;
    }

    @Override
    @Nullable
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public void setKingdomKey(@Nullable Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    @Nullable
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public void setPhylumKey(@Nullable Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    @Nullable
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public void setClassKey(@Nullable Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    @Nullable
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public void setOrderKey(@Nullable Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    @Nullable
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public void setFamilyKey(@Nullable Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    @Nullable
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public void setGenusKey(@Nullable Integer genusKey) {
        this.genusKey = genusKey;
    }

    @Override
    @Nullable
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public void setSubgenusKey(@Nullable Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    @Override
    @Nullable
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @NotNull
    @JsonIgnore
    public LinkedHashMap<Integer, String> getHigherClassificationMap() {
        return this.taxonKey == null ? ClassificationUtils.getHigherClassificationMap(this) : ClassificationUtils.getHigherClassificationMap(this, this.taxonKey, null, null);
    }

    @Override
    @Nullable
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    @Override
    public void setSpeciesKey(@Nullable Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    @Nullable
    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    public void setSpecificEpithet(String specificEpithet) {
        this.specificEpithet = specificEpithet;
    }

    @Nullable
    public String getInfraspecificEpithet() {
        return this.infraspecificEpithet;
    }

    public void setInfraspecificEpithet(String infraspecificEpithet) {
        this.infraspecificEpithet = infraspecificEpithet;
    }

    @Nullable
    public Rank getTaxonRank() {
        return this.taxonRank;
    }

    public void setTaxonRank(Rank taxonRank) {
        this.taxonRank = taxonRank;
    }

    @Nullable
    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(@Nullable String scientificName) {
        this.scientificName = scientificName;
    }

    @Override
    @Nullable
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public void setKingdom(@Nullable String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    @Nullable
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public void setPhylum(@Nullable String phylum) {
        this.phylum = phylum;
    }

    @Override
    @Nullable
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(@Nullable String clazz) {
        this.clazz = clazz;
    }

    @Override
    @Nullable
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(@Nullable String order) {
        this.order = order;
    }

    @Override
    @Nullable
    public String getFamily() {
        return this.family;
    }

    @Override
    public void setFamily(@Nullable String family) {
        this.family = family;
    }

    @Override
    @Nullable
    public String getGenus() {
        return this.genus;
    }

    @Override
    public void setGenus(@Nullable String genus) {
        this.genus = genus;
    }

    @Nullable
    public String getGenericName() {
        return this.genericName;
    }

    public void setGenericName(String genericName) {
        this.genericName = genericName;
    }

    @Override
    @Nullable
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public void setSubgenus(@Nullable String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    @Nullable
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    @Nullable
    public String getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(@Nullable String species) {
        this.species = species;
    }

    @Nullable
    public Date getDateIdentified() {
        return this.dateIdentified == null ? null : new Date(this.dateIdentified.getTime());
    }

    public void setDateIdentified(@Nullable Date dateIdentified) {
        this.dateIdentified = dateIdentified == null ? null : new Date(dateIdentified.getTime());
    }

    @Nullable
    public Double getDecimalLongitude() {
        return this.decimalLongitude;
    }

    public void setDecimalLongitude(@Nullable Double decimalLongitude) {
        this.decimalLongitude = decimalLongitude;
    }

    @Nullable
    public Double getDecimalLatitude() {
        return this.decimalLatitude;
    }

    public void setDecimalLatitude(@Nullable Double decimalLatitude) {
        this.decimalLatitude = decimalLatitude;
    }

    @Nullable
    public Double getCoordinateUncertaintyInMeters() {
        return this.coordinateUncertaintyInMeters;
    }

    public void setCoordinateUncertaintyInMeters(@Nullable Double coordinateUncertaintyInMeters) {
        this.coordinateUncertaintyInMeters = coordinateUncertaintyInMeters;
    }

    @Nullable
    public Double getCoordinatePrecision() {
        return this.coordinatePrecision;
    }

    public void setCoordinatePrecision(Double coordinatePrecision) {
        this.coordinatePrecision = coordinatePrecision;
    }

    @Nullable
    @Deprecated
    public Double getCoordinateAccuracy() {
        return this.coordinateAccuracy;
    }

    public void setCoordinateAccuracy(@Nullable Double coordinateAccuracy) {
        this.coordinateAccuracy = coordinateAccuracy;
    }

    @Nullable
    public String getGeodeticDatum() {
        if (this.decimalLatitude != null) {
            return GEO_DATUM;
        }
        return null;
    }

    private void setGeodeticDatum(String datum) {
    }

    @Nullable
    public Double getElevation() {
        return this.elevation;
    }

    public void setElevation(@Nullable Double elevation) {
        this.elevation = elevation;
    }

    @Nullable
    public Double getElevationAccuracy() {
        return this.elevationAccuracy;
    }

    public void setElevationAccuracy(@Nullable Double elevationAccuracy) {
        this.elevationAccuracy = elevationAccuracy;
    }

    @Nullable
    public Double getDepth() {
        return this.depth;
    }

    public void setDepth(@Nullable Double depth) {
        this.depth = depth;
    }

    @Nullable
    public Double getDepthAccuracy() {
        return this.depthAccuracy;
    }

    public void setDepthAccuracy(@Nullable Double depthAccuracy) {
        this.depthAccuracy = depthAccuracy;
    }

    @Nullable
    public Continent getContinent() {
        return this.continent;
    }

    public void setContinent(@Nullable Continent continent) {
        this.continent = continent;
    }

    @Nullable
    @JsonProperty(value="countryCode")
    public Country getCountry() {
        return this.country;
    }

    public void setCountry(@Nullable Country country) {
        this.country = country;
    }

    @Nullable
    @JsonProperty(value="country")
    private String getCountryTitle() {
        return this.country == null ? null : this.country.getTitle();
    }

    private void setCountryTitle(String country) {
    }

    @Nullable
    public String getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(@Nullable String stateProvince) {
        this.stateProvince = stateProvince;
    }

    @Nullable
    public String getWaterBody() {
        return this.waterBody;
    }

    public void setWaterBody(@Nullable String waterBody) {
        this.waterBody = waterBody;
    }

    @Min(value=1500L)
    @Max(value=2020L)
    @Nullable
    public Integer getYear() {
        return this.year;
    }

    public void setYear(@Nullable Integer year) {
        this.year = year;
    }

    @Min(value=1L)
    @Max(value=12L)
    @Nullable
    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(@Nullable Integer month) {
        this.month = month;
    }

    @Min(value=1L)
    @Max(value=31L)
    @Nullable
    public Integer getDay() {
        return this.day;
    }

    public void setDay(@Nullable Integer day) {
        this.day = day;
    }

    @Nullable
    public Date getEventDate() {
        return this.eventDate == null ? null : new Date(this.eventDate.getTime());
    }

    public void setEventDate(@Nullable Date eventDate) {
        this.eventDate = eventDate == null ? null : new Date(eventDate.getTime());
    }

    @Nullable
    public TypeStatus getTypeStatus() {
        return this.typeStatus;
    }

    public void setTypeStatus(@Nullable TypeStatus typeStatus) {
        this.typeStatus = typeStatus;
    }

    @Nullable
    public String getTypifiedName() {
        return this.typifiedName;
    }

    public void setTypifiedName(@Nullable String typifiedName) {
        this.typifiedName = typifiedName;
    }

    @NotNull
    public Set<OccurrenceIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(Set<OccurrenceIssue> issues) {
        Preconditions.checkNotNull((Object)"Issues cannot be null", issues);
        this.issues = Sets.newEnumSet(issues, OccurrenceIssue.class);
    }

    public void addIssue(OccurrenceIssue issue) {
        Preconditions.checkNotNull((Object)"Issue needs to be specified", (Object)issue);
        this.issues.add(issue);
    }

    @Nullable
    public Date getModified() {
        return this.modified == null ? null : new Date(this.modified.getTime());
    }

    public void setModified(@Nullable Date modified) {
        this.modified = modified == null ? null : new Date(modified.getTime());
    }

    @Nullable
    public Date getLastInterpreted() {
        return this.lastInterpreted == null ? null : new Date(this.lastInterpreted.getTime());
    }

    public void setLastInterpreted(@Nullable Date lastInterpreted) {
        this.lastInterpreted = lastInterpreted == null ? null : new Date(lastInterpreted.getTime());
    }

    @Nullable
    public URI getReferences() {
        return this.references;
    }

    public void setReferences(URI references) {
        this.references = references;
    }

    @NotNull
    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    @NotNull
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @NotNull
    public List<MediaObject> getMedia() {
        return this.media;
    }

    public void setMedia(List<MediaObject> media) {
        this.media = media;
    }

    @NotNull
    public List<FactOrMeasurment> getFacts() {
        return this.facts;
    }

    public void setFacts(List<FactOrMeasurment> facts) {
        this.facts = facts;
    }

    @NotNull
    public List<OccurrenceRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<OccurrenceRelation> relations) {
        this.relations = relations;
    }

    @JsonIgnore
    public boolean hasSpatialIssue() {
        for (OccurrenceIssue rule : OccurrenceIssue.GEOSPATIAL_RULES) {
            if (!this.issues.contains(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.basisOfRecord, this.individualCount, this.sex, this.lifeStage, this.establishmentMeans, this.taxonKey, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey, this.scientificName, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.genericName, this.specificEpithet, this.infraspecificEpithet, this.taxonRank, this.dateIdentified, this.year, this.month, this.day, this.eventDate, this.decimalLongitude, this.decimalLatitude, this.coordinatePrecision, this.coordinateUncertaintyInMeters, this.elevation, this.elevationAccuracy, this.depth, this.depthAccuracy, this.continent, this.country, this.stateProvince, this.waterBody, this.typeStatus, this.typifiedName, this.issues, this.modified, this.lastInterpreted, this.references, this.identifiers, this.media, this.facts, this.relations, this.license});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Occurrence)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Occurrence that = (Occurrence)obj;
        return Objects.equal((Object)((Object)this.basisOfRecord), (Object)((Object)that.basisOfRecord)) && Objects.equal((Object)this.individualCount, (Object)that.individualCount) && Objects.equal((Object)((Object)this.sex), (Object)((Object)that.sex)) && Objects.equal((Object)((Object)this.lifeStage), (Object)((Object)that.lifeStage)) && Objects.equal((Object)((Object)this.establishmentMeans), (Object)((Object)that.establishmentMeans)) && Objects.equal((Object)this.taxonKey, (Object)that.taxonKey) && Objects.equal((Object)this.kingdomKey, (Object)that.kingdomKey) && Objects.equal((Object)this.phylumKey, (Object)that.phylumKey) && Objects.equal((Object)this.classKey, (Object)that.classKey) && Objects.equal((Object)this.orderKey, (Object)that.orderKey) && Objects.equal((Object)this.familyKey, (Object)that.familyKey) && Objects.equal((Object)this.genusKey, (Object)that.genusKey) && Objects.equal((Object)this.subgenusKey, (Object)that.subgenusKey) && Objects.equal((Object)this.speciesKey, (Object)that.speciesKey) && Objects.equal((Object)this.scientificName, (Object)that.scientificName) && Objects.equal((Object)this.kingdom, (Object)that.kingdom) && Objects.equal((Object)this.phylum, (Object)that.phylum) && Objects.equal((Object)this.clazz, (Object)that.clazz) && Objects.equal((Object)this.order, (Object)that.order) && Objects.equal((Object)this.family, (Object)that.family) && Objects.equal((Object)this.genus, (Object)that.genus) && Objects.equal((Object)this.subgenus, (Object)that.subgenus) && Objects.equal((Object)this.species, (Object)that.species) && Objects.equal((Object)this.genericName, (Object)that.genericName) && Objects.equal((Object)this.specificEpithet, (Object)that.specificEpithet) && Objects.equal((Object)this.infraspecificEpithet, (Object)that.infraspecificEpithet) && Objects.equal((Object)((Object)this.taxonRank), (Object)((Object)that.taxonRank)) && Objects.equal((Object)this.dateIdentified, (Object)that.dateIdentified) && Objects.equal((Object)this.year, (Object)that.year) && Objects.equal((Object)this.month, (Object)that.month) && Objects.equal((Object)this.day, (Object)that.day) && Objects.equal((Object)this.eventDate, (Object)that.eventDate) && Objects.equal((Object)this.decimalLongitude, (Object)that.decimalLongitude) && Objects.equal((Object)this.decimalLatitude, (Object)that.decimalLatitude) && Objects.equal((Object)this.coordinatePrecision, (Object)that.coordinatePrecision) && Objects.equal((Object)this.coordinateUncertaintyInMeters, (Object)that.coordinateUncertaintyInMeters) && Objects.equal((Object)this.elevation, (Object)that.elevation) && Objects.equal((Object)this.elevationAccuracy, (Object)that.elevationAccuracy) && Objects.equal((Object)this.depth, (Object)that.depth) && Objects.equal((Object)this.depthAccuracy, (Object)that.depthAccuracy) && Objects.equal((Object)((Object)this.continent), (Object)((Object)that.continent)) && Objects.equal((Object)((Object)this.country), (Object)((Object)that.country)) && Objects.equal((Object)this.stateProvince, (Object)that.stateProvince) && Objects.equal((Object)this.waterBody, (Object)that.waterBody) && Objects.equal((Object)((Object)this.typeStatus), (Object)((Object)that.typeStatus)) && Objects.equal((Object)this.typifiedName, (Object)that.typifiedName) && Objects.equal(this.issues, that.issues) && Objects.equal((Object)this.modified, (Object)that.modified) && Objects.equal((Object)this.lastInterpreted, (Object)that.lastInterpreted) && Objects.equal((Object)this.references, (Object)that.references) && Objects.equal(this.identifiers, that.identifiers) && Objects.equal(this.media, that.media) && Objects.equal(this.facts, that.facts) && Objects.equal(this.relations, that.relations) && Objects.equal((Object)((Object)this.license), (Object)((Object)that.license));
    }

    @Override
    public String toString() {
        return super.toString() + Objects.toStringHelper((Object)this).add("basisOfRecord", (Object)this.basisOfRecord).add("individualCount", (Object)this.individualCount).add("sex", (Object)this.sex).add("lifeStage", (Object)this.lifeStage).add("establishmentMeans", (Object)this.establishmentMeans).add("taxonKey", (Object)this.taxonKey).add("kingdomKey", (Object)this.kingdomKey).add("phylumKey", (Object)this.phylumKey).add("classKey", (Object)this.classKey).add("orderKey", (Object)this.orderKey).add("familyKey", (Object)this.familyKey).add("genusKey", (Object)this.genusKey).add("subgenusKey", (Object)this.subgenusKey).add("speciesKey", (Object)this.speciesKey).add("scientificName", (Object)this.scientificName).add("kingdom", (Object)this.kingdom).add("phylum", (Object)this.phylum).add("clazz", (Object)this.clazz).add("order", (Object)this.order).add("family", (Object)this.family).add("genus", (Object)this.genus).add("subgenus", (Object)this.subgenus).add("species", (Object)this.species).add("genericName", (Object)this.genericName).add("specificEpithet", (Object)this.specificEpithet).add("infraspecificEpithet", (Object)this.infraspecificEpithet).add("taxonRank", (Object)this.taxonRank).add("dateIdentified", (Object)this.dateIdentified).add("decimalLongitude", (Object)this.decimalLongitude).add("decimalLatitude", (Object)this.decimalLatitude).add("coordinatePrecision", (Object)this.coordinatePrecision).add("coordinateUncertaintyInMeters", (Object)this.coordinateUncertaintyInMeters).add("coordinateAccuracy", (Object)this.coordinateAccuracy).add("elevation", (Object)this.elevation).add("elevationAccuracy", (Object)this.elevationAccuracy).add("depth", (Object)this.depth).add("depthAccuracy", (Object)this.depthAccuracy).add("continent", (Object)this.continent).add("country", (Object)this.country).add("stateProvince", (Object)this.stateProvince).add("waterBody", (Object)this.waterBody).add("year", (Object)this.year).add("month", (Object)this.month).add("day", (Object)this.day).add("eventDate", (Object)this.eventDate).add("typeStatus", (Object)this.typeStatus).add("typifiedName", (Object)this.typifiedName).add("issues", this.issues).add("modified", (Object)this.modified).add("lastInterpreted", (Object)this.lastInterpreted).add("references", (Object)this.references).add("license", (Object)this.license).toString();
    }

    @JsonAnyGetter
    private Map<String, String> jsonVerbatimFields() {
        HashMap extendedProps = Maps.newHashMap();
        for (Map.Entry<Term, String> prop : this.getVerbatimFields().entrySet()) {
            Term t = prop.getKey();
            if (t instanceof UnknownTerm || PROPERTIES.contains(t.simpleName())) {
                extendedProps.put(t.qualifiedName(), prop.getValue());
                continue;
            }
            extendedProps.put(t.simpleName(), prop.getValue());
        }
        return extendedProps;
    }
}

