/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.security.Principal;
import org.gbif.api.model.common.User;
import org.gbif.api.vocabulary.UserRole;

public class UserPrincipal
implements Principal {
    private final User user;

    public UserPrincipal(User user) {
        Preconditions.checkNotNull((Object)user);
        this.user = user;
    }

    @Override
    public String getName() {
        return this.user.getUserName();
    }

    public User getUser() {
        return this.user;
    }

    public boolean hasRole(String role) {
        if (!Strings.isNullOrEmpty((String)role)) {
            try {
                UserRole r = UserRole.valueOf(role.toUpperCase());
                return this.user.hasRole(r);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }
}

