/*
 * Decompiled with CFR 0.152.
 */
package info.ganglia.gmetric4j.gmetric;

import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import info.ganglia.gmetric4j.gmetric.Protocol;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public abstract class AbstractProtocol
implements Protocol {
    protected InetAddress udpAddr = null;
    protected int port;
    protected String group;
    private DatagramSocket socket;

    public AbstractProtocol(String group, int port, GMetric.UDPAddressingMode mode, int ttl) throws IOException {
        this.group = group;
        this.port = port;
        this.udpAddr = InetAddress.getByName(group);
        if (mode == GMetric.UDPAddressingMode.MULTICAST) {
            MulticastSocket multicastSocket = new MulticastSocket();
            multicastSocket.setTimeToLive(ttl);
            this.socket = multicastSocket;
        } else {
            this.socket = new DatagramSocket();
        }
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void send(byte[] buf, int len) throws Exception {
        DatagramPacket packet = new DatagramPacket(buf, len, this.udpAddr, this.port);
        this.socket.send(packet);
    }

    public abstract void announce(String var1, String var2, GMetricType var3, String var4, GMetricSlope var5, int var6, int var7, String var8) throws Exception;

    protected void finalize() throws Throwable {
        this.close();
    }
}

