/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.Collection;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.memory.CollectionSource;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.StyleLayer;
import org.geotools.map.event.MapLayerListener;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.operation.TransformException;

public class MapLayer {
    protected Layer internal;

    public MapLayer(Layer layer) {
        this.internal = layer;
    }

    public MapLayer(FeatureSource featureSource, Style style, String title) {
        this.internal = new FeatureLayer(featureSource, style, title);
    }

    public MapLayer(CollectionSource source, Style style, String title) {
        throw new UnsupportedOperationException("Raw Collections not supported; please use FeatureCollection");
    }

    public MapLayer(FeatureSource featureSource, Style style) {
        this.internal = new FeatureLayer(featureSource, style);
    }

    public MapLayer(FeatureCollection collection, Style style, String title) {
        this.internal = new FeatureLayer(collection, style, title);
    }

    public MapLayer(Collection collection, Style style, String title) {
        if (!(collection instanceof FeatureCollection)) {
            throw new UnsupportedOperationException("Raw collections not supported; please use FeatureCollection");
        }
        this.internal = new FeatureLayer((FeatureCollection)((Object)collection), style, title);
    }

    public MapLayer(FeatureCollection collection, Style style) {
        this.internal = new FeatureLayer(collection, style);
    }

    public MapLayer(Collection collection, Style style) {
        if (!(collection instanceof FeatureCollection)) {
            throw new UnsupportedOperationException("Raw collections not supported; please use FeatureCollection");
        }
        this.internal = new FeatureLayer((FeatureCollection)((Object)collection), style);
    }

    public MapLayer(GridCoverage coverage, Style style) throws TransformException, FactoryRegistryException, SchemaException {
        this.internal = new GridCoverageLayer((GridCoverage2D)coverage, style);
    }

    public MapLayer(GridCoverage2DReader reader, Style style, String title, GeneralParameterValue[] params) throws TransformException, FactoryRegistryException, SchemaException {
        this.internal = new GridReaderLayer(reader, style, title, params);
    }

    public MapLayer(GridCoverage2DReader reader, Style style, String title) {
        this.internal = new GridReaderLayer(reader, style, title);
    }

    public MapLayer(GridCoverage2DReader reader, Style style) {
        this.internal = new GridReaderLayer(reader, style);
    }

    public MapLayer(GridCoverage coverage, Style style, String title) throws TransformException, FactoryRegistryException, SchemaException {
        this.internal = new GridCoverageLayer((GridCoverage2D)coverage, style, title);
    }

    public Layer toLayer() {
        return this.internal;
    }

    public FeatureSource getFeatureSource() {
        return this.internal.getFeatureSource();
    }

    public CollectionSource getSource() {
        return null;
    }

    public Style getStyle() {
        return this.internal.getStyle();
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException("Style required");
        }
        if (!(this.internal instanceof StyleLayer)) {
            throw new IllegalStateException("Style not supported by " + this.internal);
        }
        StyleLayer layer = (StyleLayer)this.internal;
        layer.setStyle(style);
    }

    public String getTitle() {
        return this.internal.getTitle();
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("Title required");
        }
        this.internal.setTitle(title);
    }

    public boolean isVisible() {
        return this.internal.isVisible();
    }

    public void setVisible(boolean visible) {
        this.internal.setVisible(visible);
    }

    public boolean isSelected() {
        Boolean selected = (Boolean)this.internal.getUserData().get("selected");
        return selected == null ? false : selected;
    }

    public void setSelected(boolean selected) {
        Boolean current = (Boolean)this.internal.getUserData().get("selected");
        if (current != null && current == selected) {
            return;
        }
        this.internal.getUserData().put("selected", selected);
        if (selected) {
            this.internal.fireMapLayerListenerLayerSelected();
        } else {
            this.internal.fireMapLayerListenerLayerDeselected();
        }
    }

    public Query getQuery() {
        Query query = this.internal.getQuery();
        if (query == null || query == Query.ALL) {
            return Query.ALL;
        }
        return query;
    }

    public void setQuery(Query query) {
        if (query == null) {
            throw new NullPointerException("must provide a Query. Do you mean Query.ALL?");
        }
        if (!(this.internal instanceof FeatureLayer)) {
            throw new IllegalStateException("Query not supported by " + this.internal);
        }
        FeatureLayer layer = (FeatureLayer)this.internal;
        layer.setQuery(new Query(query));
    }

    public ReferencedEnvelope getBounds() {
        return this.internal.getBounds();
    }

    public synchronized void addMapLayerListener(MapLayerListener listener) {
        this.internal.addMapLayerListener(listener);
    }

    public synchronized void removeMapLayerListener(MapLayerListener listener) {
        this.internal.removeMapLayerListener(listener);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internal == null ? 0 : this.internal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapLayer)) {
            return false;
        }
        MapLayer other = (MapLayer)obj;
        return !(this.internal == null ? other.internal != null : !this.internal.equals(other.internal));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("MapLayer:");
        buf.append(this.internal);
        return buf.toString();
    }
}

