/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.kml.FolderStack;
import org.geotools.kml.KML;
import org.geotools.kml.StyleMap;
import org.geotools.kml.v22.SchemaRegistry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureTypeBinding
extends AbstractComplexBinding {
    protected static final SimpleFeatureType FeatureType;
    StyleMap styleMap;
    private final FolderStack folderStack;
    private SchemaRegistry schemaRegistry;

    public FeatureTypeBinding(StyleMap styleMap, FolderStack folderStack, SchemaRegistry schemaRegistry) {
        this.styleMap = styleMap;
        this.folderStack = folderStack;
        this.schemaRegistry = schemaRegistry;
    }

    @Override
    public QName getTarget() {
        return KML.FeatureType;
    }

    @Override
    public Class getType() {
        return SimpleFeature.class;
    }

    private SimpleFeatureType appendAttributes(SimpleFeatureType acc, SimpleFeatureType typeToAppend) {
        if (typeToAppend == null) {
            return acc;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(acc);
        for (AttributeDescriptor ad : typeToAppend.getAttributeDescriptors()) {
            if (acc.getDescriptor(ad.getLocalName()) != null) continue;
            tb.add(ad);
        }
        return tb.buildFeatureType();
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        URI uri2;
        List schemaURI;
        SimpleFeatureType featureType = FeatureType;
        Map extData = (Map)node.getChildValue("ExtendedData");
        if (extData != null && (schemaURI = (List)extData.get("schemas")) != null) {
            for (URI uri2 : schemaURI) {
                String normalizedSchemaName = this.normalizeSchemaName(uri2);
                SimpleFeatureType schemaType = this.schemaRegistry.get(normalizedSchemaName);
                featureType = this.appendAttributes(featureType, schemaType);
            }
        }
        SimpleFeatureType customFeatureType = this.schemaRegistry.get(instance.getName());
        featureType = this.appendAttributes(featureType, customFeatureType);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.set("name", node.getChildValue("name"));
        b.set("visibility", node.getChildValue("visibility", (Object)Boolean.TRUE));
        b.set("open", node.getChildValue("open", (Object)Boolean.TRUE));
        b.set("address", node.getChildValue("address"));
        b.set("phoneNumber", node.getChildValue("phoneNumber"));
        b.set("description", node.getChildValue("description"));
        b.set("LookAt", node.getChildValue("LookAt"));
        uri2 = (URI)node.getChildValue("styleUrl");
        if (uri2 != null) {
            b.set("Style", (Object)this.styleMap.get(uri2));
        }
        b.set("Region", node.getChildValue("Region"));
        if (extData != null) {
            b.featureUserData("UntypedExtendedData", extData.get("untyped"));
            Map typedUserData = (Map)extData.get("typed");
            if (typedUserData != null) {
                for (Map.Entry entry : typedUserData.entrySet()) {
                    String attrName = (String)entry.getKey();
                    if (featureType.getDescriptor(attrName) == null) continue;
                    b.set(attrName, entry.getValue());
                }
            }
        }
        if (customFeatureType != null) {
            for (AttributeDescriptor ad : customFeatureType.getAttributeDescriptors()) {
                String attrName = ad.getLocalName();
                Object childValue = node.getChildValue(attrName);
                if (childValue == null) continue;
                b.set(attrName, childValue);
            }
        }
        b.featureUserData("Folder", this.folderStack.asList());
        return b.buildFeature((String)node.getAttributeValue("id"));
    }

    private String normalizeSchemaName(URI schemaURI) {
        if (schemaURI.getFragment() != null) {
            return schemaURI.getFragment();
        }
        return schemaURI.getPath();
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if (object instanceof FeatureCollection) {
            FeatureCollection features = (FeatureCollection)object;
            if ("id".equals(name.getLocalPart())) {
                return features.getID();
            }
        }
        if (object instanceof SimpleFeature) {
            URI uri;
            SimpleFeature feature = (SimpleFeature)object;
            if ("id".equals(name.getLocalPart())) {
                return feature.getID();
            }
            if ("name".equals(name.getLocalPart())) {
                return feature.getAttribute("name");
            }
            if ("description".equals(name.getLocalPart())) {
                return feature.getAttribute("description");
            }
            if (KML.styleUrl.equals(name) && (uri = (URI)feature.getAttribute("Style")) != null) {
                return this.styleMap.get(uri);
            }
        }
        return super.getProperty(object, name);
    }

    static {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setNamespaceURI("http://earth.google.com/kml/2.1");
        tb.setName("feature");
        tb.add("name", String.class);
        tb.add("visibility", Boolean.class);
        tb.add("open", Boolean.class);
        tb.add("address", String.class);
        tb.add("phoneNumber", String.class);
        tb.add("description", String.class);
        tb.add("LookAt", Point.class);
        tb.add("Style", FeatureTypeStyle.class);
        tb.add("Region", LinearRing.class);
        FeatureType = tb.buildFeatureType();
    }
}

