/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.scale7.cassandra.pelops.pool.CommonsBackedPool;
import org.scale7.cassandra.pelops.pool.PooledNode;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class LeastLoadedNodeSelectionStrategy
implements CommonsBackedPool.INodeSelectionStrategy {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(LeastLoadedNodeSelectionStrategy.class);

    @Override
    public PooledNode select(CommonsBackedPool pool, Set<String> nodeAddresses, Set<String> avoidNodesHint) {
        if (logger.isDebugEnabled()) {
            logger.debug("Determining which node is the least loaded");
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>(nodeAddresses.size());
        for (String nodeAddress : nodeAddresses) {
            PooledNode pooledNode = pool.getPooledNode(nodeAddress);
            if (pooledNode == null || pooledNode.isSuspended()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Excluding node '{}' because it's either been removed from the pool or has been suspended", (Object)nodeAddress);
                continue;
            }
            candidates.add(new Candidate(pooledNode.getAddress(), pooledNode));
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return pool.getPooledNode(((Candidate)candidates.iterator().next()).address);
        }
        Collections.sort(candidates);
        PooledNode node = null;
        for (Candidate candidate : candidates) {
            node = pool.getPooledNode(candidate.address);
            if (avoidNodesHint == null || !avoidNodesHint.contains(candidate.address)) break;
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Attempting to honor the avoidNodesHint '{}', skipping node '{}'", avoidNodesHint, (Object)candidate.address);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Chose node '{}'...", (Object)(node != null ? node.getAddress() : "null"));
        }
        return node;
    }

    public class Candidate
    implements Comparable<Candidate> {
        String address;
        int numActive;
        int numBorrowed;
        int numCorrupted;

        public Candidate(String address, PooledNode node) {
            this.address = address;
            this.numActive = node.getNumActive();
            this.numBorrowed = node.getConnectionsBorrowedTotal();
            this.numCorrupted = node.getConnectionsCorrupted();
            if (logger.isDebugEnabled()) {
                logger.debug("Node '{}' has {} active connections, {} borrowed connections and {} corrupted connections", new Object[]{address, this.numActive, this.numBorrowed, this.numCorrupted});
            }
        }

        @Override
        public int compareTo(Candidate candidate) {
            int value = this.numActive - candidate.numActive;
            if (value == 0) {
                value = this.numBorrowed - candidate.numBorrowed;
            }
            if (value == 0) {
                value = this.numCorrupted - candidate.numCorrupted;
            }
            return value;
        }
    }
}

