/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxMBeanManager {
    private static final Object mbsCreateMonitor = new Object();
    private static JmxMBeanManager thisObj;
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JmxMBeanManager getInstance() {
        Object object = mbsCreateMonitor;
        synchronized (object) {
            if (null == thisObj) {
                thisObj = new JmxMBeanManager();
            }
        }
        return thisObj;
    }

    public boolean isRegistered(String name) {
        try {
            ObjectName objName = new ObjectName(name);
            return this.mbs.isRegistered(objName);
        }
        catch (Exception e) {
            throw new RuntimeException("exception while checking if MBean is registered, " + name, e);
        }
    }

    public void registerMBean(Object theBean, String name) {
        try {
            ObjectName objName = new ObjectName(name);
            this.mbs.registerMBean(theBean, objName);
        }
        catch (Exception e) {
            throw new RuntimeException("exception while registering MBean, " + name, e);
        }
    }

    public void unregisterMBean(String name) {
        try {
            ObjectName objName = new ObjectName(name);
            this.mbs.unregisterMBean(objName);
        }
        catch (Exception e) {
            throw new RuntimeException("exception while unregistering MBean, " + name, e);
        }
    }

    public Object getAttribute(String objName, String attrName) {
        try {
            ObjectName on = new ObjectName(objName);
            return this.mbs.getAttribute(on, attrName);
        }
        catch (Exception e) {
            throw new RuntimeException("exception while getting MBean attribute, " + objName + ", " + attrName, e);
        }
    }

    public Integer getIntAttribute(String objName, String attrName) {
        return (Integer)this.getAttribute(objName, attrName);
    }

    public String getStringAttribute(String objName, String attrName) {
        return (String)this.getAttribute(objName, attrName);
    }
}

