/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.index.IndexLocalNode;
import au.org.ala.biocache.util.OptionParser;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class IndexLocalRecordsV2$
implements Tool {
    public static final IndexLocalRecordsV2$ MODULE$;

    static {
        new IndexLocalRecordsV2$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "index-local-node";
    }

    @Override
    public String desc() {
        return "Index all records on a local node";
    }

    @Override
    public void main(String[] args) {
        IntRef maxRecordsToIndex;
        BooleanRef optimiseOnly;
        BooleanRef optimise;
        ObjectRef zkc;
        IntRef threadsPerWriter = new IntRef(2);
        IntRef threadsPerProcess = new IntRef(4);
        IntRef writerCount = new IntRef(2);
        IntRef ramPerWriter = new IntRef(500);
        IntRef writerSegmentSize = new IntRef(100);
        IntRef writerBufferSize = new IntRef(1000);
        IntRef processorBufferSize = new IntRef(1000);
        IntRef pageSize = new IntRef(1000);
        IntRef mergeSegments = new IntRef(1);
        BooleanRef test = new BooleanRef(false);
        BooleanRef testMap = new BooleanRef(false);
        IntRef threads = new IntRef(2);
        ObjectRef solrHome = new ObjectRef((Object)"/data/solr/");
        String checkpointFile = new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/index-local-records-checkpoints.txt").toString();
        ObjectRef solrConfigXmlPath = new ObjectRef((Object)new StringBuilder().append((Object)((String)solrHome.elem)).append((Object)"/biocache/conf/solrconfig.xml").toString());
        OptionParser parser = new OptionParser(threadsPerWriter, threadsPerProcess, writerCount, ramPerWriter, writerSegmentSize, writerBufferSize, processorBufferSize, pageSize, mergeSegments, test, testMap, threads, solrHome, solrConfigXmlPath, zkc = new ObjectRef((Object)Config$.MODULE$.zookeeperAddress()), optimise = new BooleanRef(true), optimiseOnly = new BooleanRef(false), maxRecordsToIndex = new IntRef(-1)){
            {
                this.opt("zkc", "zk-config", "Zookeeper instance host:port to retrieve SOLR configuration from", (Function1<String, BoxedUnit>)new Serializable(this, zkc$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef zkc$1;

                    public final void apply(String v) {
                        this.zkc$1.elem = v;
                    }
                    {
                        this.zkc$1 = zkc$1;
                    }
                });
                this.opt("sh", "solr-home", "SOLR home directory on the file system or the zookeeper host:port if rewriting directly to SOLR cloud instance", (Function1<String, BoxedUnit>)new Serializable(this, solrHome$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef solrHome$1;

                    public final void apply(String v) {
                        this.solrHome$1.elem = v;
                    }
                    {
                        this.solrHome$1 = solrHome$1;
                    }
                });
                this.opt("sc", "solr-config-path", "SOLR Config XML file path", (Function1<String, BoxedUnit>)new Serializable(this, solrConfigXmlPath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef solrConfigXmlPath$1;

                    public final void apply(String v) {
                        this.solrConfigXmlPath$1.elem = v;
                    }
                    {
                        this.solrConfigXmlPath$1 = solrConfigXmlPath$1;
                    }
                });
                this.intOpt("t", "no-of-threads", "The number of threads to use", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("skip-optimise", "Optimise the new index once writing has completed. Defaults to false (i.e. optimisation happens by default)", (Function0<BoxedUnit>)new Serializable(this, optimise$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef optimise$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.optimise$1.elem = false;
                    }
                    {
                        this.optimise$1 = optimise$1;
                    }
                });
                this.opt("test", new StringBuilder().append((Object)"Test indexing. This skips the production of an index. Defaults to ").append((Object)BoxesRunTime.boxToBoolean((boolean)test$1.elem)).toString(), (Function0<BoxedUnit>)new Serializable(this, test$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef test$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.test$1.elem = true;
                    }
                    {
                        this.test$1 = test$1;
                    }
                });
                this.opt("test-map", new StringBuilder().append((Object)"Use map paging instead of array. Defaults to ").append((Object)BoxesRunTime.boxToBoolean((boolean)testMap$1.elem)).toString(), (Function0<BoxedUnit>)new Serializable(this, testMap$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef testMap$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.testMap$1.elem = true;
                    }
                    {
                        this.testMap$1 = testMap$1;
                    }
                });
                this.opt("optimise-only", "Optimise the index once writing has completed", (Function0<BoxedUnit>)new Serializable(this, optimise$1, optimiseOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef optimise$1;
                    private final BooleanRef optimiseOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.optimise$1.elem = true;
                        this.optimiseOnly$1.elem = true;
                    }
                    {
                        this.optimise$1 = optimise$1;
                        this.optimiseOnly$1 = optimiseOnly$1;
                    }
                });
                this.intOpt("ms", "mergesegments", new StringBuilder().append((Object)"The number of output segments. No merge output is produced when 0. Default is ").append((Object)BoxesRunTime.boxToInteger((int)mergeSegments$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, mergeSegments$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef mergeSegments$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.mergeSegments$1.elem = v;
                    }
                    {
                        this.mergeSegments$1 = mergeSegments$1;
                    }
                });
                this.intOpt("wc", "writercount", new StringBuilder().append((Object)"The number of index writers. Default is ").append((Object)BoxesRunTime.boxToInteger((int)writerCount$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, writerCount$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef writerCount$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.writerCount$1.elem = v;
                    }
                    {
                        this.writerCount$1 = writerCount$1;
                    }
                });
                this.intOpt("wt", "writerthreads", new StringBuilder().append((Object)"The number of threads for each indexing writer. There is 1 writer for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)threadsPerWriter$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, threadsPerWriter$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threadsPerWriter$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threadsPerWriter$1.elem = v;
                    }
                    {
                        this.threadsPerWriter$1 = threadsPerWriter$1;
                    }
                });
                this.intOpt("wb", "writerbuffer", new StringBuilder().append((Object)"Size of indexing write buffer. The default is ").append((Object)BoxesRunTime.boxToInteger((int)writerBufferSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, writerBufferSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef writerBufferSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.writerBufferSize$1.elem = v;
                    }
                    {
                        this.writerBufferSize$1 = writerBufferSize$1;
                    }
                });
                this.intOpt("pt", "processthreads", new StringBuilder().append((Object)"The number of threads for each indexing process. There is 1 process for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)threadsPerProcess$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, threadsPerProcess$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threadsPerProcess$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threadsPerProcess$1.elem = v;
                    }
                    {
                        this.threadsPerProcess$1 = threadsPerProcess$1;
                    }
                });
                this.intOpt("pb", "processbuffer", new StringBuilder().append((Object)"Size of the indexing process buffer. Default is ").append((Object)BoxesRunTime.boxToInteger((int)processorBufferSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, processorBufferSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef processorBufferSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.processorBufferSize$1.elem = v;
                    }
                    {
                        this.processorBufferSize$1 = processorBufferSize$1;
                    }
                });
                this.intOpt("r", "writerram", new StringBuilder().append((Object)"Ram allocation for each writer (MB). There is 1 writer for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)ramPerWriter$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, ramPerWriter$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef ramPerWriter$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.ramPerWriter$1.elem = v;
                    }
                    {
                        this.ramPerWriter$1 = ramPerWriter$1;
                    }
                });
                this.intOpt("ws", "writersegmentsize", new StringBuilder().append((Object)"Maximum number of occurrences in a writer segment. There is 1 writer for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)writerSegmentSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, writerSegmentSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef writerSegmentSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.writerSegmentSize$1.elem = v;
                    }
                    {
                        this.writerSegmentSize$1 = writerSegmentSize$1;
                    }
                });
                this.intOpt("ps", "pagesize", new StringBuilder().append((Object)"The page size for the records. Default is ").append((Object)BoxesRunTime.boxToInteger((int)pageSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, pageSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef pageSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.pageSize$1.elem = v;
                    }
                    {
                        this.pageSize$1 = pageSize$1;
                    }
                });
                this.intOpt("max", "maxrecords", "Maximum number of records to index. This is mainly for testing new indexing. Default is index all records", (Function1<Object, BoxedUnit>)new Serializable(this, maxRecordsToIndex$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef maxRecordsToIndex$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.maxRecordsToIndex$1.elem = v;
                    }
                    {
                        this.maxRecordsToIndex$1 = maxRecordsToIndex$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            IndexLocalNode ilr = new IndexLocalNode();
            ilr.indexRecords(threads.elem, (String)solrHome.elem, (String)solrConfigXmlPath.elem, optimise.elem, optimiseOnly.elem, checkpointFile, threadsPerWriter.elem, threadsPerProcess.elem, ramPerWriter.elem, writerSegmentSize.elem, processorBufferSize.elem, writerBufferSize.elem, pageSize.elem, mergeSegments.elem, test.elem, writerCount.elem, testMap.elem, maxRecordsToIndex.elem);
        }
    }

    private IndexLocalRecordsV2$() {
        MODULE$ = this;
        Tool$class.$init$(this);
    }
}

