/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.OccurrenceConsumer;
import au.org.ala.biocache.OccurrenceVersionConsumer;
import au.org.ala.biocache.RecordWriter;
import au.org.ala.biocache.Store$$anonfun$getAllSystemAssertions$2$;
import au.org.ala.biocache.dao.DeletedRecordDAO;
import au.org.ala.biocache.dao.DuplicateDAO;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.dao.OutlierStatsDAO;
import au.org.ala.biocache.dao.ValidationRuleDAO;
import au.org.ala.biocache.index.IndexFields$;
import au.org.ala.biocache.index.IndexRecords$;
import au.org.ala.biocache.load.DataResourceConfig;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.load.IngestTool$;
import au.org.ala.biocache.load.Loader;
import au.org.ala.biocache.load.MapDataLoader;
import au.org.ala.biocache.load.SimpleLoader;
import au.org.ala.biocache.model.DuplicateRecordDetails;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.model.Multimedia$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.Raw$;
import au.org.ala.biocache.model.ValidationRule;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.outliers.JackKnifeStats;
import au.org.ala.biocache.outliers.RecordJackKnifeStats;
import au.org.ala.biocache.outliers.SampledRecord;
import au.org.ala.biocache.parser.ProcessedValue;
import au.org.ala.biocache.poso.POSO;
import au.org.ala.biocache.processor.RecordProcessor;
import au.org.ala.biocache.qa.ValidationRuleRunner;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.tool.QueryDelete;
import au.org.ala.biocache.tool.Sampling$;
import au.org.ala.biocache.util.BiocacheConversions$;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.ListDelete;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.ErrorCode;
import au.org.ala.biocache.vocab.ErrorCodeCategory$;
import au.org.ala.biocache.vocab.Layers$;
import au.org.ala.biocache.vocab.SpeciesGroup;
import au.org.ala.biocache.vocab.SpeciesGroups$;
import au.org.ala.layers.dao.IntersectCallback;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

public final class Store$ {
    public static final Store$ MODULE$;
    private final Logger logger;
    private final OccurrenceDAO au$org$ala$biocache$Store$$occurrenceDAO;
    private final OutlierStatsDAO outlierStatsDAO;
    private final DeletedRecordDAO deletedRecordDAO;
    private final DuplicateDAO duplicateDAO;
    private final ValidationRuleDAO validationRuleDAO;
    private boolean readOnly;

    static {
        new Store$();
    }

    public Logger logger() {
        return this.logger;
    }

    public OccurrenceDAO au$org$ala$biocache$Store$$occurrenceDAO() {
        return this.au$org$ala$biocache$Store$$occurrenceDAO;
    }

    private OutlierStatsDAO outlierStatsDAO() {
        return this.outlierStatsDAO;
    }

    private DeletedRecordDAO deletedRecordDAO() {
        return this.deletedRecordDAO;
    }

    private DuplicateDAO duplicateDAO() {
        return this.duplicateDAO;
    }

    private ValidationRuleDAO validationRuleDAO() {
        return this.validationRuleDAO;
    }

    private boolean readOnly() {
        return this.readOnly;
    }

    private void readOnly_$eq(boolean x$1) {
        this.readOnly = x$1;
    }

    public FullRecord getByUuid(String uuid, Version version) {
        return (FullRecord)this.au$org$ala$biocache$Store$$occurrenceDAO().getByRowKey(uuid, version, this.au$org$ala$biocache$Store$$occurrenceDAO().getByRowKey$default$3()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public FullRecord getSensitiveByUuid(String uuid, Version version) {
        return (FullRecord)this.au$org$ala$biocache$Store$$occurrenceDAO().getByRowKey(uuid, version, true).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public FullRecord getByUuid(String uuid) {
        return (FullRecord)this.au$org$ala$biocache$Store$$occurrenceDAO().getByRowKey(uuid, Raw$.MODULE$, this.au$org$ala$biocache$Store$$occurrenceDAO().getByRowKey$default$3()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public FullRecord[] getAllVersionsByUuid(String uuid, Boolean includeSensitive) {
        return (FullRecord[])this.au$org$ala$biocache$Store$$occurrenceDAO().getAllVersionsByRowKey(uuid, Predef$.MODULE$.Boolean2boolean(includeSensitive)).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public java.util.Map<String, java.util.List<ProcessedValue>> getComparisonByUuid(String uuid) {
        return this.getComparison((FullRecord[])this.au$org$ala$biocache$Store$$occurrenceDAO().getAllVersionsByRowKey(uuid, this.au$org$ala$biocache$Store$$occurrenceDAO().getAllVersionsByRowKey$default$2()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private java.util.Map<String, java.util.List<ProcessedValue>> getComparison(FullRecord[] recordVersions) {
        HashMap<String, java.util.List<ProcessedValue>> hashMap;
        if (recordVersions != null && recordVersions.length > 1) {
            void var2_2;
            HashMap map = new HashMap();
            FullRecord raw = recordVersions[0];
            FullRecord processed = recordVersions[1];
            Tuple2[] rawAndProcessed = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])raw.objectArray()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])processed.objectArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Predef$.MODULE$.refArrayOps((Object[])rawAndProcessed).foreach((Function1)new Serializable(map){
                public static final long serialVersionUID = 0L;
                private final HashMap map$1;

                public final java.util.List<ProcessedValue> apply(Tuple2<POSO, POSO> rawAndProcessed) {
                    Tuple2<POSO, POSO> tuple2 = rawAndProcessed;
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        POSO rawPoso = (POSO)tuple2._1();
                        POSO procPoso = (POSO)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)rawPoso, (Object)procPoso);
                        POSO rawPoso2 = (POSO)tuple23._1();
                        POSO procPoso2 = (POSO)tuple23._2();
                        LinkedList<E> listBuff = new LinkedList<E>();
                        rawPoso2.getPropertyNames().foreach((Function1)new Serializable(this, rawPoso2, procPoso2, listBuff){
                            public static final long serialVersionUID = 0L;
                            private final POSO rawPoso$1;
                            private final POSO procPoso$1;
                            private final LinkedList listBuff$1;

                            public final Object apply(String name) {
                                Object object;
                                if (Config$.MODULE$.sensitiveFields().contains((Object)name)) {
                                    object = BoxedUnit.UNIT;
                                } else {
                                    Option<String> rawValue = this.rawPoso$1.getProperty(name);
                                    Option<String> procValue = this.procPoso$1.getProperty(name);
                                    if (rawValue.isEmpty() && procValue.isEmpty()) {
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        ProcessedValue term = new ProcessedValue(name, (String)rawValue.getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "";
                                            }
                                        }), (String)procValue.getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "";
                                            }
                                        }));
                                        object = BoxesRunTime.boxToBoolean((boolean)this.listBuff$1.add(term));
                                    }
                                }
                                return object;
                            }
                            {
                                this.rawPoso$1 = rawPoso$1;
                                this.procPoso$1 = procPoso$1;
                                this.listBuff$1 = listBuff$1;
                            }
                        });
                        String name = rawPoso2.getClass().getName().substring(rawPoso2.getClass().getName().lastIndexOf(".") + 1);
                        return this.map$1.put(name, listBuff);
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.map$1 = map$1;
                }
            });
            hashMap = var2_2;
        } else {
            hashMap = new HashMap<String, java.util.List<ProcessedValue>>();
        }
        return hashMap;
    }

    public void pageOverAll(Version version, OccurrenceConsumer consumer, String dataResourceUid, int pageSize) {
        this.au$org$ala$biocache$Store$$occurrenceDAO().pageOverAll(version, (Function1<Option<FullRecord>, Object>)new Serializable(consumer){
            public static final long serialVersionUID = 0L;
            private final OccurrenceConsumer consumer$1;

            public final boolean apply(Option<FullRecord> fullRecord) {
                return this.consumer$1.consume((FullRecord)fullRecord.get());
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, dataResourceUid, pageSize);
    }

    public void pageOverAllVersions(OccurrenceVersionConsumer consumer, String dataResourceUid, int pageSize) {
        this.au$org$ala$biocache$Store$$occurrenceDAO().pageOverAllVersions((Function1<Option<FullRecord[]>, Object>)new Serializable(consumer){
            public static final long serialVersionUID = 0L;
            private final OccurrenceVersionConsumer consumer$2;

            public final boolean apply(Option<FullRecord[]> fullRecordVersion) {
                return fullRecordVersion.isEmpty() ? true : this.consumer$2.consume((FullRecord[])fullRecordVersion.get());
            }
            {
                this.consumer$2 = consumer$2;
            }
        }, dataResourceUid, pageSize);
    }

    public File rowKeyFile(String dataResourceIdentifer) {
        return new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/row_key_").append((Object)dataResourceIdentifer).append((Object)".csv").toString());
    }

    public void loadRecordOnly(String dataResourceUid, FullRecord fr, java.util.List<String> identifyingTerms) {
        fr.lastModifiedTime_$eq(BiocacheConversions$.MODULE$.dateToString(new Date()));
        new SimpleLoader().load(dataResourceUid, fr, (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(identifyingTerms).toList(), true, true, false);
    }

    public String loadRecord(String dataResourceIdentifer, java.util.Map<String, String> properties, boolean shouldIndex2) {
        return new RecordProcessor().addRecord(dataResourceIdentifer, (scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(properties).toMap(Predef$.MODULE$.conforms()));
    }

    public String loadRecord(String dataResourceUid, FullRecord fr, java.util.List<String> identifyingTerms, boolean shouldIndex2) {
        fr.lastModifiedTime_$eq(BiocacheConversions$.MODULE$.dateToString(new Date()));
        new SimpleLoader().load(dataResourceUid, fr, (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(identifyingTerms).toList(), true, true, false);
        RecordProcessor processor = new RecordProcessor();
        processor.processRecordAndUpdate(fr);
        if (shouldIndex2) {
            this.au$org$ala$biocache$Store$$occurrenceDAO().reIndex(fr.rowKey());
        }
        return fr.rowKey();
    }

    public boolean loadRecord$default$4() {
        return true;
    }

    public Seq<String> loadRecords(String dataResourceUid, java.util.List<java.util.Map<String, String>> recordsProperties, java.util.List<String> identifyFields, boolean shouldIndex2) {
        MapDataLoader loader = new MapDataLoader();
        List<String> rowKeys = loader.load(dataResourceUid, (List<java.util.Map<String, String>>)JavaConversions$.MODULE$.asScalaBuffer(recordsProperties).toList(), (List<String>)JavaConversions$.MODULE$.asScalaBuffer(identifyFields).toList());
        if (!rowKeys.isEmpty()) {
            ProcessRecords$.MODULE$.processRowKeys(rowKeys);
            if (shouldIndex2) {
                IndexRecords$.MODULE$.indexList(rowKeys);
            }
        }
        return rowKeys;
    }

    public boolean loadRecords$default$4() {
        return true;
    }

    public FullRecord upsertRecord(String dataResourceUid, java.util.Map<String, String> properties, java.util.List<java.util.Map<String, String>> multimediaProperties, boolean shouldIndex2) {
        SimpleLoader loader = new SimpleLoader();
        Option<DataResourceConfig> option = loader.retrieveConnectionParameters(dataResourceUid);
        None$ none$ = None$.MODULE$;
        Option<DataResourceConfig> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new Exception(new StringBuilder().append((Object)"Unable to retrieve connection information for data resource UID: ").append((Object)dataResourceUid).toString());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            DataResourceConfig dataResourceConfig = (DataResourceConfig)some.x();
            FullRecord record = FullRecordMapper$.MODULE$.createFullRecord("", (Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(properties), (Version)Versions$.MODULE$.RAW());
            Buffer multimedia = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(multimediaProperties).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Multimedia apply(java.util.Map<String, String> props) {
                    return Multimedia$.MODULE$.create(new URL((String)JavaConversions$.MODULE$.mapAsScalaMap(props).getOrElse((Object)"identifier", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    })), "", (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.conforms()));
                }
            }, Buffer$.MODULE$.canBuildFrom());
            new SimpleLoader().load(dataResourceUid, record, dataResourceConfig.uniqueTerms(), (Seq<Multimedia>)multimedia);
            RecordProcessor processor = new RecordProcessor();
            processor.processRecordAndUpdate(record);
            if (shouldIndex2) {
                this.au$org$ala$biocache$Store$$occurrenceDAO().reIndex(record.rowKey());
            }
            FullRecord fullRecord = record;
            return fullRecord;
        }
        throw new MatchError(option);
    }

    public Object deleteRecordBy(String uuid) {
        return uuid == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.au$org$ala$biocache$Store$$occurrenceDAO().delete(uuid, this.au$org$ala$biocache$Store$$occurrenceDAO().delete$default$2(), this.au$org$ala$biocache$Store$$occurrenceDAO().delete$default$3()));
    }

    public void deleteRecords(java.util.List<String> rowKeys) {
        ListDelete deletor = new ListDelete((List<String>)JavaConversions$.MODULE$.asScalaBuffer(rowKeys).toList());
        deletor.deleteFromPersistent();
        deletor.deleteFromIndex();
    }

    public void deleteRecords(String dataResource, String query, boolean fromPersistent, boolean fromIndex) {
        Object object;
        QueryDelete deletor = dataResource == null ? new QueryDelete(query) : new QueryDelete(new StringBuilder().append((Object)"data_resource_uid:").append((Object)dataResource).toString());
        this.logger().debug(new StringBuilder().append((Object)"Delete from storage using the query: ").append((Object)query).toString());
        if (fromPersistent) {
            deletor.deleteFromPersistent();
        }
        this.logger().debug("Delete from index");
        if (fromIndex) {
            deletor.deleteFromIndex();
        }
        if (fromPersistent && fromIndex) {
            this.logger().debug("Delete row_key file");
            object = BoxesRunTime.boxToBoolean((boolean)FileUtils.deleteQuietly((File)this.rowKeyFile(dataResource)));
        } else {
            object = BoxedUnit.UNIT;
        }
        this.logger().debug("Delete complete.");
    }

    public java.util.List<QualityAssertion> getSystemAssertions(String uuid) {
        String rowKey = (String)this.au$org$ala$biocache$Store$$occurrenceDAO().getRowKeyFromUuid(uuid).getOrElse((Function0)new Serializable(uuid){
            public static final long serialVersionUID = 0L;
            private final String uuid$1;

            public final String apply() {
                return this.uuid$1;
            }
            {
                this.uuid$1 = uuid$1;
            }
        });
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.au$org$ala$biocache$Store$$occurrenceDAO().getSystemAssertions(rowKey).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(QualityAssertion x$2) {
                return x$2.qaStatus() == 0;
            }
        })).asJava();
    }

    public java.util.Map<String, java.util.List<QualityAssertion>> getAllSystemAssertions(String uuid) {
        String rowKey = (String)this.au$org$ala$biocache$Store$$occurrenceDAO().getRowKeyFromUuid(uuid).getOrElse((Function0)new Serializable(uuid){
            public static final long serialVersionUID = 0L;
            private final String uuid$2;

            public final String apply() {
                return this.uuid$2;
            }
            {
                this.uuid$2 = uuid$2;
            }
        });
        List<QualityAssertion> list = this.au$org$ala$biocache$Store$$occurrenceDAO().getSystemAssertions(rowKey);
        Set<ErrorCode> unchecked = AssertionCodes$.MODULE$.getMissingCodes((Set<ErrorCode>)((TraversableOnce)list.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ErrorCode apply(QualityAssertion it) {
                return (ErrorCode)AssertionCodes$.MODULE$.getByCode(it.code()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
        }, List$.MODULE$.canBuildFrom())).toSet());
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableLike)list.$plus$plus((GenTraversableOnce)unchecked.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final QualityAssertion apply(ErrorCode it) {
                return QualityAssertion$.MODULE$.apply(it, AssertionStatus$.MODULE$.UNCHECKED());
            }
        }, Set$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final String apply(QualityAssertion x0$1) {
                QualityAssertion qualityAssertion = x0$1;
                if (qualityAssertion.qaStatus() == 0) {
                    String string = ((ErrorCode)AssertionCodes$.MODULE$.getByCode(qualityAssertion.code()).getOrElse((Function0)new anonfun$getAllSystemAssertions$2$$anonfun$7(this))).category();
                    String string2 = ErrorCodeCategory$.MODULE$.Error();
                    String string3 = string;
                    if (string2 == null) {
                        if (string3 == null) return "failed";
                    } else if (string2.equals(string3)) {
                        return "failed";
                    }
                    if (string == null) throw new MatchError((Object)string);
                    String string4 = string;
                    String string5 = string4.toString().toLowerCase();
                    return string5;
                }
                if (qualityAssertion.qaStatus() != AssertionStatus$.MODULE$.PASSED()) return "unchecked";
                return "passed";
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.List<QualityAssertion> apply(List<QualityAssertion> x$3) {
                return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$3).asJava();
            }
        })).asJava();
    }

    public QualityAssertion getUserAssertion(String uuid, String assertionUuid) {
        String rowKey = (String)this.au$org$ala$biocache$Store$$occurrenceDAO().getRowKeyFromUuid(uuid).getOrElse((Function0)new Serializable(uuid){
            public static final long serialVersionUID = 0L;
            private final String uuid$3;

            public final String apply() {
                return this.uuid$3;
            }
            {
                this.uuid$3 = uuid$3;
            }
        });
        return (QualityAssertion)this.au$org$ala$biocache$Store$$occurrenceDAO().getUserAssertions(rowKey).find((Function1)new Serializable(assertionUuid){
            public static final long serialVersionUID = 0L;
            private final String assertionUuid$1;

            public final boolean apply(QualityAssertion ass) {
                String string = ass.uuid();
                String string2 = this.assertionUuid$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.assertionUuid$1 = assertionUuid$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public java.util.List<QualityAssertion> getUserAssertions(String uuid) {
        String rowKey = (String)this.au$org$ala$biocache$Store$$occurrenceDAO().getRowKeyFromUuid(uuid).getOrElse((Function0)new Serializable(uuid){
            public static final long serialVersionUID = 0L;
            private final String uuid$4;

            public final String apply() {
                return this.uuid$4;
            }
            {
                this.uuid$4 = uuid$4;
            }
        });
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.au$org$ala$biocache$Store$$occurrenceDAO().getUserAssertions(rowKey)).asJava();
    }

    public void addUserAssertion(String uuid, QualityAssertion qualityAssertion) {
        if (this.readOnly()) {
            throw new Exception("In read only model. Please try again later");
        }
        String rowKey = (String)this.au$org$ala$biocache$Store$$occurrenceDAO().getRowKeyFromUuid(uuid).getOrElse((Function0)new Serializable(uuid){
            public static final long serialVersionUID = 0L;
            private final String uuid$5;

            public final String apply() {
                return this.uuid$5;
            }
            {
                this.uuid$5 = uuid$5;
            }
        });
        this.au$org$ala$biocache$Store$$occurrenceDAO().addUserAssertion(rowKey, qualityAssertion);
        this.au$org$ala$biocache$Store$$occurrenceDAO().reIndex(rowKey);
    }

    public void addUserAssertions(java.util.Map<String, QualityAssertion> assertionMap) {
        if (this.readOnly()) {
            throw new Exception("In read only model. Please try again later");
        }
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        IntRef count = new IntRef(0);
        JavaConversions$.MODULE$.mapAsScalaMap(assertionMap).foreach((Function1)new Serializable(arrayBuffer, count){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer arrayBuffer$1;
            private final IntRef count$1;

            public final ArrayBuffer<String> apply(Tuple2<String, QualityAssertion> x0$2) {
                Tuple2<String, QualityAssertion> tuple2 = x0$2;
                if (tuple2 != null) {
                    String uuid = (String)tuple2._1();
                    QualityAssertion qa = (QualityAssertion)tuple2._2();
                    ++this.count$1.elem;
                    String rowKey = (String)Store$.MODULE$.au$org$ala$biocache$Store$$occurrenceDAO().getRowKeyFromUuid(uuid).getOrElse((Function0)new Serializable(this, uuid){
                        public static final long serialVersionUID = 0L;
                        private final String uuid$6;

                        public final String apply() {
                            return this.uuid$6;
                        }
                        {
                            this.uuid$6 = uuid$6;
                        }
                    });
                    Store$.MODULE$.au$org$ala$biocache$Store$$occurrenceDAO().addUserAssertion(rowKey, qa);
                    ArrayBuffer arrayBuffer = this.arrayBuffer$1.$plus$eq((Object)rowKey);
                    return arrayBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.arrayBuffer$1 = arrayBuffer$1;
                this.count$1 = count$1;
            }
        });
        IndexRecords$.MODULE$.indexList((List<String>)arrayBuffer.toList());
        this.logger().debug(new StringBuilder().append((Object)"Added ").append((Object)BoxesRunTime.boxToInteger((int)count.elem)).append((Object)" user assertions in bulk").toString());
    }

    public void addValidationRule(ValidationRule validationRule) {
        this.validationRuleDAO().upsert(validationRule);
    }

    public ValidationRule getValidationRule(String uuid) {
        return (ValidationRule)this.validationRuleDAO().get(uuid).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public ValidationRule[] getValidationRules(String[] ids) {
        return (ValidationRule[])this.validationRuleDAO().get((List<String>)Predef$.MODULE$.refArrayOps((Object[])ids).toList()).toArray(ClassTag$.MODULE$.apply(ValidationRule.class));
    }

    public ValidationRule[] getValidationRules() {
        return (ValidationRule[])this.validationRuleDAO().list().toArray(ClassTag$.MODULE$.apply(ValidationRule.class));
    }

    public void applyValidationRule(String uuid) {
        ValidationRuleRunner qual$1 = new ValidationRuleRunner();
        String x$4 = uuid;
        boolean x$5 = qual$1.applySingle$default$2();
        boolean x$6 = qual$1.applySingle$default$3();
        String x$7 = qual$1.applySingle$default$4();
        boolean x$8 = qual$1.applySingle$default$5();
        boolean x$9 = qual$1.applySingle$default$6();
        qual$1.applySingle(x$4, x$5, x$6, x$7, x$8, x$9);
    }

    public void deleteValidationRule(String id, Date date) {
        this.validationRuleDAO().delete(id, date, this.validationRuleDAO().delete$default$3());
    }

    public void deleteUserAssertion(String uuid, String assertionUuid) {
        if (this.readOnly()) {
            throw new Exception("In read only model. Please try again later");
        }
        String rowKey = (String)this.au$org$ala$biocache$Store$$occurrenceDAO().getRowKeyFromUuid(uuid).getOrElse((Function0)new Serializable(uuid){
            public static final long serialVersionUID = 0L;
            private final String uuid$7;

            public final String apply() {
                return this.uuid$7;
            }
            {
                this.uuid$7 = uuid$7;
            }
        });
        this.au$org$ala$biocache$Store$$occurrenceDAO().deleteUserAssertion(rowKey, assertionUuid);
        this.au$org$ala$biocache$Store$$occurrenceDAO().reIndex(rowKey);
    }

    public void setReadOnly(boolean ro) {
        this.readOnly_$eq(ro);
    }

    public boolean isReadOnly() {
        return this.readOnly();
    }

    public String optimiseIndex() {
        String string;
        long start = System.currentTimeMillis();
        this.readOnly_$eq(true);
        try {
            String indexString = Config$.MODULE$.indexDAO().optimise();
            long finished = System.currentTimeMillis();
            this.readOnly_$eq(false);
            string = new StringBuilder().append((Object)"Optimised in ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finished - start) / 60000.0f))).append((Object)" minutes.\n").append((Object)indexString).toString();
        }
        catch (Exception exception) {
            this.readOnly_$eq(false);
            string = exception.getMessage();
        }
        return string;
    }

    public void reopenIndex() {
        Config$.MODULE$.indexDAO().reload();
    }

    public void reindex(String dataResource, String startDate) {
        throw new RuntimeException("Not supported");
    }

    public Nothing$ index(String dataResource) {
        throw new RuntimeException("Not supported");
    }

    public void index(String dataResource, String[] customIndexFields, String[] userProvidedTypeCustomIndexFields, ObserverCallback callback) {
        this.logger().info(new StringBuilder().append((Object)"Indexing data resource ").append((Object)dataResource).toString());
        Some x$10 = new Some((Object)dataResource);
        Seq x$11 = Predef$.MODULE$.refArrayOps((Object[])customIndexFields).toSeq();
        Seq x$12 = Predef$.MODULE$.refArrayOps((Object[])userProvidedTypeCustomIndexFields).toSeq();
        ObserverCallback x$13 = callback;
        boolean x$14 = IndexRecords$.MODULE$.index$default$2();
        boolean x$15 = IndexRecords$.MODULE$.index$default$3();
        Option<String> x$16 = IndexRecords$.MODULE$.index$default$4();
        boolean x$17 = IndexRecords$.MODULE$.index$default$5();
        int x$18 = IndexRecords$.MODULE$.index$default$6();
        boolean x$19 = IndexRecords$.MODULE$.index$default$10();
        int x$20 = IndexRecords$.MODULE$.index$default$11();
        IndexRecords$.MODULE$.index((Option<String>)x$10, x$14, x$15, x$16, x$17, x$18, (Seq<String>)x$11, (Seq<String>)x$12, x$13, x$19, x$20);
        this.logger().info(new StringBuilder().append((Object)"Finished indexing data resource ").append((Object)dataResource).toString());
        this.logger().info("Storing custom index fields to the database....");
        this.storeCustomIndexFields(dataResource, customIndexFields);
        this.logger().info("Storing custom index fields to the database....done");
    }

    public ObserverCallback index$default$4() {
        return null;
    }

    public void sample(String dataResourceUid) {
        Sampling$.MODULE$.sampleDataResource(dataResourceUid, Sampling$.MODULE$.sampleDataResource$default$2(), Sampling$.MODULE$.sampleDataResource$default$3());
    }

    public void sample(String dataResourceUid, IntersectCallback callback) {
        Sampling$.MODULE$.sampleDataResource(dataResourceUid, callback, Sampling$.MODULE$.sampleDataResource$default$3());
    }

    public void process(String dataResourceUid, int threads, ObserverCallback callback) {
        File keyFile = this.rowKeyFile(dataResourceUid);
        File file = keyFile.exists() ? keyFile : null;
        ProcessRecords$.MODULE$.processRecords(dataResourceUid, threads);
    }

    public int process$default$2() {
        return 1;
    }

    public ObserverCallback process$default$3() {
        return null;
    }

    public void writeToStream(OutputStream outputStream, String fieldDelimiter, String recordDelimiter, String[] keys, String[] fields, String[] qaFields, boolean includeSensitive) {
        this.au$org$ala$biocache$Store$$occurrenceDAO().writeToStream(outputStream, fieldDelimiter, recordDelimiter, keys, fields, qaFields, includeSensitive);
    }

    public void writeToStream(OutputStream outputStream, String fieldDelimiter, String recordDelimiter, String[] keys, String[] fields, String[] qaFields) {
        this.writeToStream(outputStream, fieldDelimiter, recordDelimiter, keys, fields, qaFields, false);
    }

    public void writeToWriter(RecordWriter writer, String[] keys, String[] fields, String[] qaFields, boolean includeSensitive) {
        this.au$org$ala$biocache$Store$$occurrenceDAO().writeToRecordWriter(writer, keys, fields, qaFields, includeSensitive, false, null, this.au$org$ala$biocache$Store$$occurrenceDAO().writeToRecordWriter$default$8());
    }

    public void writeToWriter(RecordWriter writer, String[] keys, String[] fields, String[] qaFields) {
        this.writeToWriter(writer, keys, fields, qaFields, false, false, null);
    }

    public String[] writeToWriter(RecordWriter writer, String[] keys, String[] fields, String[] qaFields, boolean includeSensitive, boolean includeMisc, String[] miscFields) {
        return this.au$org$ala$biocache$Store$$occurrenceDAO().writeToRecordWriter(writer, keys, fields, qaFields, includeSensitive, includeMisc, miscFields, this.au$org$ala$biocache$Store$$occurrenceDAO().writeToRecordWriter$default$8());
    }

    public String[] writeToWriter(RecordWriter writer, String[] keys, String[] fields, String[] qaFields, boolean includeSensitive, boolean includeMisc, String[] miscFields, java.util.Map<String, String[]> dataToInsert) {
        return this.au$org$ala$biocache$Store$$occurrenceDAO().writeToRecordWriter(writer, keys, fields, qaFields, includeSensitive, includeMisc, miscFields, dataToInsert);
    }

    public ErrorCode[] retrieveAssertionCodes() {
        return (ErrorCode[])AssertionCodes$.MODULE$.all().toArray(ClassTag$.MODULE$.apply(ErrorCode.class));
    }

    public ErrorCode[] retrieveGeospatialCodes() {
        return (ErrorCode[])AssertionCodes$.MODULE$.geospatialCodes().toArray(ClassTag$.MODULE$.apply(ErrorCode.class));
    }

    public ErrorCode[] retrieveTaxonomicCodes() {
        return (ErrorCode[])AssertionCodes$.MODULE$.taxonomicCodes().toArray(ClassTag$.MODULE$.apply(ErrorCode.class));
    }

    public ErrorCode[] retrieveTemporalCodes() {
        return (ErrorCode[])AssertionCodes$.MODULE$.temporalCodes().toArray(ClassTag$.MODULE$.apply(ErrorCode.class));
    }

    public ErrorCode[] retrieveMiscellaneousCodes() {
        return (ErrorCode[])AssertionCodes$.MODULE$.miscellaneousCodes().toArray(ClassTag$.MODULE$.apply(ErrorCode.class));
    }

    public ErrorCode[] retrieveUserAssertionCodes() {
        return (ErrorCode[])Predef$.MODULE$.refArrayOps((Object[])AssertionCodes$.MODULE$.userAssertionCodes()).toArray(ClassTag$.MODULE$.apply(ErrorCode.class));
    }

    public ErrorCode getByCode(String codeAsString) {
        int code = new StringOps(Predef$.MODULE$.augmentString(codeAsString)).toInt();
        return (ErrorCode)AssertionCodes$.MODULE$.all().find((Function1)new Serializable(code){
            public static final long serialVersionUID = 0L;
            private final int code$1;

            public final boolean apply(ErrorCode errorCode) {
                return errorCode.code() == this.code$1;
            }
            {
                this.code$1 = code$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public String retrieveSubgroupsConfig() {
        return SpeciesGroups$.MODULE$.getSubgroupsConfig();
    }

    public java.util.List<SpeciesGroup> retrieveSpeciesGroups() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(SpeciesGroups$.MODULE$.groups()).asJava();
    }

    public java.util.List<SpeciesGroup> retrieveSpeciesSubgroups() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(SpeciesGroups$.MODULE$.subgroups()).asJava();
    }

    public java.util.Map<String, String> getIndexFieldMap() {
        return JavaConversions$.MODULE$.mapAsJavaMap(IndexFields$.MODULE$.indexFieldMap());
    }

    public java.util.Map<String, String> getStorageFieldMap() {
        return JavaConversions$.MODULE$.mapAsJavaMap(IndexFields$.MODULE$.storeFieldMap());
    }

    public String getLayerId(String name) {
        return name == null ? null : (String)Layers$.MODULE$.nameToIdMap().getOrElse((Object)name.toLowerCase(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public void ingest(String[] dataResources, int numThreads) {
        Loader l = new Loader();
        if (dataResources != null) {
            Predef$.MODULE$.refArrayOps((Object[])dataResources).foreach((Function1)new Serializable(numThreads){
                public static final long serialVersionUID = 0L;
                private final int numThreads$1;

                public final void apply(String dr) {
                    IngestTool$.MODULE$.ingestResource(dr, this.numThreads$1, IngestTool$.MODULE$.ingestResource$default$3(), IngestTool$.MODULE$.ingestResource$default$4(), IngestTool$.MODULE$.ingestResource$default$5(), IngestTool$.MODULE$.ingestResource$default$6());
                }
                {
                    this.numThreads$1 = numThreads$1;
                }
            });
        } else {
            l.resourceList().foreach((Function1)new Serializable(numThreads){
                public static final long serialVersionUID = 0L;
                private final int numThreads$1;

                public final void apply(scala.collection.immutable.Map<String, String> resource) {
                    String uid = (String)resource.getOrElse((Object)"uid", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    String name = (String)resource.getOrElse((Object)"name", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    Store$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingesting resource ", ", uid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, uid})));
                    IngestTool$.MODULE$.ingestResource(uid, this.numThreads$1, IngestTool$.MODULE$.ingestResource$default$3(), IngestTool$.MODULE$.ingestResource$default$4(), IngestTool$.MODULE$.ingestResource$default$5(), IngestTool$.MODULE$.ingestResource$default$6());
                }
                {
                    this.numThreads$1 = numThreads$1;
                }
            });
        }
    }

    public int ingest$default$2() {
        return 4;
    }

    public String getLayerName(String id) {
        return id == null ? null : (String)Layers$.MODULE$.idToNameMap().getOrElse((Object)id, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public java.util.Map<String, String> getSoundFormats(String filePath) {
        return Config$.MODULE$.mediaStore().getSoundFormats(filePath);
    }

    public java.util.Map<String, JackKnifeStats> getJackKnifeStatsFor(String guid) {
        return this.outlierStatsDAO().getJackKnifeStatsFor(guid);
    }

    public java.util.List<Tuple2<String, java.util.List<SampledRecord>>> getJackKnifeOutliersFor(String guid) {
        return this.outlierStatsDAO().getJackKnifeOutliersFor(guid);
    }

    public java.util.List<RecordJackKnifeStats> getJackKnifeRecordDetailsFor(String uuid) {
        return this.outlierStatsDAO().getJackKnifeRecordDetailsFor(uuid);
    }

    public DuplicateRecordDetails getDuplicateDetails(String uuid) {
        return (DuplicateRecordDetails)this.duplicateDAO().getDuplicateInfo(uuid).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DuplicateRecordDetails apply() {
                return new DuplicateRecordDetails();
            }
        });
    }

    public String[] getDeletedRecords(Date date) {
        return this.deletedRecordDAO().getUuidsForDeletedRecords(DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd"));
    }

    public void storeCustomIndexFields(String tempUid, String[] customIndexFields) {
        Config$.MODULE$.persistenceManager().put(tempUid, "upload", "customIndexFields", Json$.MODULE$.toJSON(Predef$.MODULE$.refArrayOps((Object[])customIndexFields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String v) {
                return v.endsWith("_i") || v.endsWith("_d") ? v : new StringBuilder().append((Object)v).append((Object)"_s").toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), true, false);
    }

    public String[] retrieveCustomIndexFields(String tempUid) {
        String[] stringArray;
        try {
            Option<String> s = Config$.MODULE$.persistenceManager().get(tempUid, "upload", "customIndexFields");
            stringArray = Json$.MODULE$.toStringArray((String)s.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "[]";
                }
            }));
        }
        catch (Exception exception) {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public void storeCustomChartOptions(String tempUid, String customChartOptions) {
        Config$.MODULE$.persistenceManager().put(tempUid, "upload", "customChartOptions", customChartOptions, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public String retrieveCustomChartOptions(String tempUid) {
        String string;
        try {
            void var3_3;
            Option<String> s = Config$.MODULE$.persistenceManager().get(tempUid, "upload", "customChartOptions");
            String json = (String)s.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "[]";
                }
            });
            string = var3_3;
        }
        catch (Exception exception) {
            string = "[]";
        }
        return string;
    }

    public String storeLayerOptions(String tempUid, String customChartOptions) {
        return Config$.MODULE$.persistenceManager().put(tempUid, "upload", "layerOptions", customChartOptions, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public String retrieveLayerOptions(String tempUid) {
        String string;
        try {
            void var3_3;
            Option<String> s = Config$.MODULE$.persistenceManager().get(tempUid, "upload", "layerOptions");
            String json = (String)s.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "[]";
                }
            });
            string = var3_3;
        }
        catch (Exception exception) {
            string = "[]";
        }
        return string;
    }

    private Store$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"Store");
        this.au$org$ala$biocache$Store$$occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        this.outlierStatsDAO = (OutlierStatsDAO)Config$.MODULE$.getInstance(OutlierStatsDAO.class);
        this.deletedRecordDAO = Config$.MODULE$.deletedRecordDAO();
        this.duplicateDAO = Config$.MODULE$.duplicateDAO();
        this.validationRuleDAO = Config$.MODULE$.validationRuleDAO();
        this.readOnly = false;
    }
}

