/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import javax.xml.namespace.QName;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class ArcTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;
    CoordinateSequenceFactory csFactory;
    ArcParameters arcParameters;

    public ArcTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory, ArcParameters arcParameters) {
        this.gFactory = gFactory;
        this.csFactory = csFactory;
        this.arcParameters = arcParameters;
    }

    public QName getTarget() {
        return GML.ArcType;
    }

    public Class getType() {
        return LineString.class;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LineString arcLineString = GML3ParsingUtils.lineString(node, this.gFactory, this.csFactory);
        if (arcLineString.getCoordinates().length != 3) {
            throw new RuntimeException("Number of coordinates in an arc must be exactly 3, " + arcLineString.getCoordinates().length + " were specified: " + arcLineString);
        }
        return value;
    }
}

