/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.Circle;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class ArcStringTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;
    CoordinateSequenceFactory csFactory;
    ArcParameters arcParameters;

    public ArcStringTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory, ArcParameters arcParameters) {
        this.gFactory = gFactory;
        this.csFactory = csFactory;
        this.arcParameters = arcParameters;
    }

    public QName getTarget() {
        return GML.ArcStringType;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Class getType() {
        return LineString.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LineString arcLineString = GML3ParsingUtils.lineString(node, this.gFactory, this.csFactory);
        Coordinate[] arcCoordinates = arcLineString.getCoordinates();
        if (arcCoordinates.length < 3) {
            throw new RuntimeException("Number of coordinates in an arc string must be at least 3, " + arcCoordinates.length + " were specified: " + arcLineString);
        }
        Coordinate c1 = arcCoordinates[0];
        Coordinate c2 = arcCoordinates[arcCoordinates.length / 2];
        Coordinate c3 = arcCoordinates[arcCoordinates.length - 1];
        boolean mustReverse = this.laidOutClockwise(c1, c2, c3);
        if (mustReverse) {
            Coordinate cTemp = c1;
            c1 = c3;
            c3 = cTemp;
        }
        Circle circle = new Circle(c1, c2, c3);
        double tolerance = this.arcParameters.getLinearizationTolerance().getTolerance(circle);
        Coordinate[] resultCoordinates = circle.linearizeArc(c1, c2, c3, tolerance);
        if (mustReverse) {
            List<Coordinate> reversingCoordinates = Arrays.asList(resultCoordinates);
            Collections.reverse(reversingCoordinates);
            resultCoordinates = reversingCoordinates.toArray(new Coordinate[reversingCoordinates.size()]);
        }
        LineString resultLineString = this.gFactory.createLineString(resultCoordinates);
        return resultLineString;
    }

    protected boolean laidOutClockwise(Coordinate c1, Coordinate c2, Coordinate c3) {
        return CGAlgorithms.computeOrientation(c1, c2, c3) == -1;
    }
}

