/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.kie.api.Service;
import org.kie.internal.assembler.KieAssemblerService;
import org.kie.internal.assembler.KieAssemblers;
import org.kie.internal.runtime.KieRuntimeService;
import org.kie.internal.runtime.KieRuntimes;
import org.kie.internal.runtime.beliefs.KieBeliefService;
import org.kie.internal.runtime.beliefs.KieBeliefs;
import org.kie.internal.utils.KieService;
import org.kie.internal.utils.ServiceDiscovery;
import org.kie.internal.utils.ServiceRegistry;
import org.kie.internal.utils.ServiceRegistryImpl;
import org.kie.internal.weaver.KieWeaverService;
import org.kie.internal.weaver.KieWeavers;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryImpl
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscovery.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverFactories(Enumeration<URL> confResources, ServiceRegistry serviceRegistry) {
        while (confResources.hasMoreElements()) {
            URL url = confResources.nextElement();
            InputStream is = null;
            try {
                is = url.openStream();
                log.info("Discovered kie.conf url={} ", (Object)url);
                ServiceDiscoveryImpl.processKieConf(is, serviceRegistry);
            }
            catch (Exception exc) {
                log.error("Unable to build kie service url={} reason={}\n", (Object)url.toExternalForm(), (Object)exc.getMessage());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                        continue;
                    }
                    log.error("Unable to build kie service url={}\n", (Object)url.toExternalForm());
                }
                catch (IOException e1) {
                    log.warn("Unable to close Stream for url={} reason={}", (Object)url, (Object)e1.getMessage());
                }
            }
        }
    }

    public static void processKieConf(InputStream is, ServiceRegistry serviceRegistry) throws IOException {
        String conf = ServiceDiscoveryImpl.readFileAsString(new InputStreamReader(is));
        ServiceDiscoveryImpl.processKieConf(conf, serviceRegistry);
    }

    public static void processKieConf(String conf, ServiceRegistry serviceRegistry) {
        Map map = (Map)MVEL.eval((String)conf);
        ServiceDiscoveryImpl.processKieConf(map, serviceRegistry);
    }

    public static void processKieConf(Map<String, List> map, ServiceRegistry serviceRegistry) {
        ServiceDiscoveryImpl.processKieServices(map, serviceRegistry);
        ServiceDiscoveryImpl.processKieAssemblers(map, serviceRegistry);
        ServiceDiscoveryImpl.processKieWeavers(map, serviceRegistry);
        ServiceDiscoveryImpl.processKieBeliefs(map, serviceRegistry);
        ServiceDiscoveryImpl.processRuntimes(map, serviceRegistry);
    }

    private static void processRuntimes(Map<String, List> map, ServiceRegistry serviceRegistry) {
        List runtimeList = map.get("runtimes");
        if (runtimeList != null && runtimeList.size() > 0) {
            KieRuntimes runtimes = (KieRuntimes)serviceRegistry.get(KieRuntimes.class);
            for (KieRuntimeService runtime : runtimeList) {
                log.info("Adding Runtime {} ", (Object)runtime.getServiceInterface().getName());
                runtimes.getRuntimes().put(runtime.getServiceInterface().getName(), runtime);
            }
        }
    }

    private static void processKieAssemblers(Map<String, List> map, ServiceRegistry serviceRegistry) {
        List assemblerList = map.get("assemblers");
        if (assemblerList != null && assemblerList.size() > 0) {
            KieAssemblers assemblers = (KieAssemblers)serviceRegistry.get(KieAssemblers.class);
            for (KieAssemblerService assemblerFactory : assemblerList) {
                log.info("Adding Assembler {} ", (Object)assemblerFactory.getClass().getName());
                assemblers.getAssemblers().put(assemblerFactory.getResourceType(), assemblerFactory);
            }
        }
    }

    private static void processKieWeavers(Map<String, List> map, ServiceRegistry serviceRegistry) {
        List weaverList = map.get("weavers");
        if (weaverList != null && weaverList.size() > 0) {
            KieWeavers weavers = (KieWeavers)serviceRegistry.get(KieWeavers.class);
            for (KieWeaverService weaver : weaverList) {
                log.info("Adding Weaver {} ", (Object)weavers.getClass().getName());
                weavers.getWeavers().put(weaver.getResourceType(), weaver);
            }
        }
    }

    private static void processKieBeliefs(Map<String, List> map, ServiceRegistry serviceRegistry) {
        List beliefsList = map.get("beliefs");
        if (beliefsList != null && beliefsList.size() > 0) {
            KieBeliefs beliefs = (KieBeliefs)serviceRegistry.get(KieBeliefs.class);
            for (KieBeliefService belief : beliefsList) {
                log.info("Adding Belief {} ", (Object)beliefs.getClass().getName());
                beliefs.getBeliefs().put(belief.getBeliefType(), belief);
            }
        }
    }

    private static void processKieServices(Map<String, List> map, ServiceRegistry serviceRegistry) {
        List servicesList = map.get("services");
        if (servicesList != null && servicesList.size() > 0) {
            for (KieService service : servicesList) {
                log.info("Adding Service {} ", (Object)service.getClass().getName());
                serviceRegistry.registerLocator(service.getServiceInterface(), (Callable)new ServiceRegistryImpl.ReturnInstance((Service)service));
            }
        }
    }

    public static String readFileAsString(Reader reader) {
        try {
            int numRead;
            StringBuilder fileData = new StringBuilder(1000);
            char[] buf = new char[1024];
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            return fileData.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

