/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.nameparser;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.Rank;
import org.gbif.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalisedNameParser {
    private static Logger LOG = LoggerFactory.getLogger(NormalisedNameParser.class);
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    private final long timeout;
    protected static final String NAME_LETTERS = "A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152";
    protected static final String name_letters = "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153";
    protected static final String AUTHOR_LETTERS = "A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}";
    protected static final String author_letters = "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-";
    protected static final String AUTHOR_PREFIXES = "(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|Des|De|de|di|Di|da|N)[`' _]|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')";
    protected static final String AUTHOR = "(?:(?:(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]{1,3}\\.?[ -]?){0,3}|[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]{3,} )?(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|Des|De|de|di|Di|da|N)[`' _]|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')?(?:v\\. )?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?(?:(?:[- ](?:de|da|du)?[- ]?)[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?)?(?: ?(?:f|fil|j|jr|jun|junior|sr|sen|senior|ms)\\.?)?(?: *: *(?:Pers|Fr)\\.?)?)";
    protected static final String AUTHOR_TEAM = "(?:(?:(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]{1,3}\\.?[ -]?){0,3}|[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]{3,} )?(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|Des|De|de|di|Di|da|N)[`' _]|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')?(?:v\\. )?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?(?:(?:[- ](?:de|da|du)?[- ]?)[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?)?(?: ?(?:f|fil|j|jr|jun|junior|sr|sen|senior|ms)\\.?)?(?: *: *(?:Pers|Fr)\\.?)?)?(?:(?: ?ex\\.? | & | et | in |, ?|; ?|\\.)(?:(?:(?:(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]{1,3}\\.?[ -]?){0,3}|[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]{3,} )?(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|Des|De|de|di|Di|da|N)[`' _]|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')?(?:v\\. )?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?(?:(?:[- ](?:de|da|du)?[- ]?)[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?)?(?: ?(?:f|fil|j|jr|jun|junior|sr|sen|senior|ms)\\.?)?(?: *: *(?:Pers|Fr)\\.?)?)|al\\.?))*";
    protected static final Pattern AUTHOR_TEAM_PATTERN = Pattern.compile("^(?:(?:(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]{1,3}\\.?[ -]?){0,3}|[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]{3,} )?(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|Des|De|de|di|Di|da|N)[`' _]|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')?(?:v\\. )?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?(?:(?:[- ](?:de|da|du)?[- ]?)[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?)?(?: ?(?:f|fil|j|jr|jun|junior|sr|sen|senior|ms)\\.?)?(?: *: *(?:Pers|Fr)\\.?)?)?(?:(?: ?ex\\.? | & | et | in |, ?|; ?|\\.)(?:(?:(?:(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]{1,3}\\.?[ -]?){0,3}|[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]{3,} )?(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|Des|De|de|di|Di|da|N)[`' _]|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')?(?:v\\. )?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?(?:(?:[- ](?:de|da|du)?[- ]?)[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?)?(?: ?(?:f|fil|j|jr|jun|junior|sr|sen|senior|ms)\\.?)?(?: *: *(?:Pers|Fr)\\.?)?)|al\\.?))*$");
    protected static final String YEAR = "[12][0-9][0-9][0-9?][abcdh?]?(?:[/-][0-9]{1,4})?";
    protected static final String RANK_MARKER_SPECIES = "(?:notho)?(?:" + StringUtils.join(Rank.RANK_MARKER_MAP_INFRASPECIFIC.keySet(), (String)"|") + "|agg)\\.?";
    private static final Function<Rank, String> REMOVE_RANK_MARKER = new Function<Rank, String>(){

        public String apply(Rank rank) {
            return rank.getMarker().replaceAll("\\.", "\\\\.");
        }
    };
    protected static final String RANK_MARKER_MICROBIAL = "(?:bv\\.|ct\\.|f\\. ?sp\\.|" + StringUtils.join((Iterable)Lists.transform((List)Lists.newArrayList((Iterable)Rank.INFRASUBSPECIFIC_MICROBIAL_RANKS), REMOVE_RANK_MARKER), (String)"|") + ")";
    protected static final String EPHITHET_PREFIXES = "van|novae";
    protected static final String GENETIC_EPHITHETS = "bacilliform|coliform|coryneform|cytoform|chemoform|biovar|serovar|genomovar|agamovar|cultivar|genotype|serotype|subtype|ribotype|isolate";
    protected static final String EPHITHET = "(?:[0-9]+-|[doml]')?(?:(?:van|novae) [a-z])?[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153+-]{1,}(?<! d)[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153](?<!(?:\\bex|bacilliform|coliform|coryneform|cytoform|chemoform|biovar|serovar|genomovar|agamovar|cultivar|genotype|serotype|subtype|ribotype|isolate))(?=\\b)";
    protected static final String MONOMIAL = "[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152](?:\\.|[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)(?:-[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]?[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)?";
    private static final Pattern LATIN_ENDINGS;
    protected static final String INFRAGENERIC;
    protected static final String RANK_MARKER_ALL;
    private static final Pattern RANK_MARKER_ONLY;
    public static final Pattern CANON_NAME_IGNORE_AUTHORS;
    public static final Pattern NAME_PATTERN;

    public NormalisedNameParser(long timeout) {
        this.timeout = timeout;
    }

    public boolean parseNormalisedName(ParsedName cn, String scientificName, @Nullable Rank rank) {
        LOG.debug("Parse normed name string: {}", (Object)scientificName);
        FutureTask<Matcher> task = new FutureTask<Matcher>(new MatcherCallable(scientificName));
        THREAD_POOL.execute(task);
        try {
            Matcher matcher = task.get(this.timeout, TimeUnit.MILLISECONDS);
            if (matcher.group(0).equals(scientificName)) {
                String yearAsString;
                if (LOG.isDebugEnabled()) {
                    this.logMatcher(matcher);
                }
                cn.setGenusOrAbove(StringUtils.trimToNull((String)matcher.group(1)));
                boolean bracketSubrankFound = false;
                if (matcher.group(2) != null) {
                    bracketSubrankFound = true;
                    cn.setInfraGeneric(StringUtils.trimToNull((String)matcher.group(2)));
                } else if (matcher.group(4) != null) {
                    String rankMarker = StringUtils.trimToNull((String)matcher.group(3));
                    if (!rankMarker.endsWith(".")) {
                        rankMarker = rankMarker + ".";
                    }
                    cn.setRankMarker(rankMarker);
                    cn.setInfraGeneric(StringUtils.trimToNull((String)matcher.group(4)));
                }
                cn.setSpecificEpithet(StringUtils.trimToNull((String)matcher.group(5)));
                if (matcher.group(6) != null && matcher.group(6).length() > 1 && !matcher.group(6).contains("null")) {
                    cn.setRank(Rank.INFRASUBSPECIFIC_NAME);
                }
                if (matcher.group(7) != null && matcher.group(7).length() > 1) {
                    cn.setRankMarker(StringUtils.trimToNull((String)matcher.group(7)));
                }
                cn.setInfraSpecificEpithet(StringUtils.trimToNull((String)matcher.group(8)));
                if (matcher.group(9) != null) {
                    cn.setRankMarker(matcher.group(9));
                    cn.setInfraSpecificEpithet(matcher.group(10));
                }
                cn.setBracketAuthorship(StringUtils.trimToNull((String)matcher.group(12)));
                if (bracketSubrankFound && NormalisedNameParser.infragenericIsAuthor(cn, rank)) {
                    cn.setBracketAuthorship(cn.getInfraGeneric());
                    cn.setInfraGeneric(null);
                    LOG.debug("swapped subrank with bracket author: {}", (Object)cn.getBracketAuthorship());
                }
                if (matcher.group(13) != null && matcher.group(13).length() > 2) {
                    yearAsString = matcher.group(13).trim();
                    cn.setBracketYear(yearAsString);
                }
                cn.setAuthorship(StringUtils.trimToNull((String)matcher.group(14)));
                if (matcher.group(15) != null && matcher.group(15).length() > 2) {
                    yearAsString = matcher.group(15).trim();
                    cn.setYear(yearAsString);
                }
                this.lookForIrregularRankMarker(cn);
                this.checkEpithetVsAuthorPrefx(cn);
                if (cn.getRankMarker() == null && rank != null) {
                    cn.setRank(rank);
                }
                return true;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException for name: {}", (Object)scientificName, (Object)e);
        }
        catch (ExecutionException e) {
            LOG.warn("ExecutionException for name: {}", (Object)scientificName, (Object)e);
        }
        catch (IllegalStateException e) {
        }
        catch (TimeoutException e) {
            LOG.info("Parsing timeout for name: {}", (Object)scientificName);
        }
        return false;
    }

    private static boolean infragenericIsAuthor(ParsedName pn, Rank rank) {
        return pn.getBracketAuthorship() == null && pn.getSpecificEpithet() == null && (rank != null && (!rank.isInfrageneric() || rank.isSpeciesOrBelow()) || rank == null && !LATIN_ENDINGS.matcher(pn.getInfraGeneric()).find());
    }

    public boolean parseNormalisedNameIgnoreAuthors(ParsedName cn, String scientificName, @Nullable Rank rank) {
        LOG.debug("Parse normed name string ignoring authors: {}", (Object)scientificName);
        Matcher matcher = CANON_NAME_IGNORE_AUTHORS.matcher(scientificName);
        boolean matchFound = matcher.find();
        if (matchFound) {
            if (LOG.isDebugEnabled()) {
                this.logMatcher(matcher);
            }
            cn.setGenusOrAbove(StringUtils.trimToNull((String)matcher.group(1)));
            if (matcher.group(2) != null) {
                cn.setInfraGeneric(StringUtils.trimToNull((String)matcher.group(2)));
                if (NormalisedNameParser.infragenericIsAuthor(cn, rank)) {
                    cn.setInfraGeneric(null);
                }
            } else if (matcher.group(4) != null) {
                String rankMarker = StringUtils.trimToNull((String)matcher.group(3));
                cn.setRankMarker(rankMarker);
                cn.setInfraGeneric(StringUtils.trimToNull((String)matcher.group(4)));
            }
            cn.setSpecificEpithet(StringUtils.trimToNull((String)matcher.group(5)));
            if (matcher.group(6) != null && matcher.group(6).length() > 1 && !matcher.group(6).contains("null")) {
                cn.setRank(Rank.INFRASUBSPECIFIC_NAME);
            }
            if (matcher.group(7) != null && matcher.group(7).length() > 1) {
                cn.setRankMarker(matcher.group(7));
            }
            if (matcher.group(8) != null && matcher.group(8).length() >= 2) {
                NormalisedNameParser.setCanonicalInfraSpecies(cn, matcher.group(8));
            }
            if (matcher.group(9) != null) {
                cn.setRankMarker(matcher.group(9));
                cn.setInfraSpecificEpithet(matcher.group(10));
            }
            this.lookForIrregularRankMarker(cn);
            return true;
        }
        return false;
    }

    private static void setCanonicalInfraSpecies(ParsedName pn, String epi) {
        if (epi == null || epi.equalsIgnoreCase("sec") || epi.equalsIgnoreCase("sensu")) {
            return;
        }
        pn.setInfraSpecificEpithet(StringUtils.trimToNull((String)epi));
    }

    private void lookForIrregularRankMarker(ParsedName cn) {
        if (cn.getRankMarker() == null) {
            Matcher m;
            if (cn.getInfraSpecificEpithet() != null) {
                Matcher m2 = RANK_MARKER_ONLY.matcher(cn.getInfraSpecificEpithet());
                if (m2.find()) {
                    cn.setRankMarker(cn.getInfraSpecificEpithet());
                    cn.setInfraSpecificEpithet(null);
                }
            } else if (cn.getSpecificEpithet() != null && (m = RANK_MARKER_ONLY.matcher(cn.getSpecificEpithet())).find()) {
                cn.setRankMarker(cn.getSpecificEpithet());
                cn.setSpecificEpithet(null);
            }
        }
    }

    private void checkEpithetVsAuthorPrefx(ParsedName cn) {
        if (cn.getRankMarker() == null) {
            if (cn.getInfraSpecificEpithet() != null) {
                String extendedAuthor = cn.getInfraSpecificEpithet() + " " + cn.getAuthorship();
                Matcher m = AUTHOR_TEAM_PATTERN.matcher(extendedAuthor);
                if (m.find()) {
                    LOG.debug("use infraspecific epithet as author prefix");
                    cn.setInfraSpecificEpithet(null);
                    cn.setAuthorship(extendedAuthor);
                }
            } else {
                String extendedAuthor = cn.getSpecificEpithet() + " " + cn.getAuthorship();
                Matcher m = AUTHOR_TEAM_PATTERN.matcher(extendedAuthor);
                if (m.find()) {
                    LOG.debug("use specific epithet as author prefix");
                    cn.setSpecificEpithet(null);
                    cn.setAuthorship(extendedAuthor);
                }
            }
        }
    }

    private void logMatcher(Matcher matcher) {
        int i = -1;
        while (i < matcher.groupCount()) {
            LOG.debug("  {}: >{}<", (Object)(++i), (Object)matcher.group(i));
        }
    }

    static {
        try {
            LinkedList endings = FileUtils.streamToList((InputStream)FileUtils.classpathStream((String)"latin-endings.txt"));
            LATIN_ENDINGS = Pattern.compile("(" + Joiner.on((char)'|').skipNulls().join((Iterable)endings) + ")$");
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read latin-endings.txt from classpath resources", e);
        }
        INFRAGENERIC = "(?:\\( ?([A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153-]+) ?\\)|(" + StringUtils.join(Rank.RANK_MARKER_MAP_INFRAGENERIC.keySet(), (String)"|") + ")\\.? ?([" + NAME_LETTERS + "][" + name_letters + "-]+)" + ")";
        RANK_MARKER_ALL = "(notho)? *(" + StringUtils.join(Rank.RANK_MARKER_MAP.keySet(), (String)"|") + ")\\.?";
        RANK_MARKER_ONLY = Pattern.compile("^" + RANK_MARKER_ALL + "$");
        CANON_NAME_IGNORE_AUTHORS = Pattern.compile("^(\u00d7?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152](?:\\.|[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)(?:-[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]?[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)?)(?:(?<!ceae) " + INFRAGENERIC + ")?" + "(?: " + AUTHOR_PREFIXES + ")?" + "(?: (\u00d7?" + EPHITHET + "))?" + "(?: " + AUTHOR_PREFIXES + ")?" + "(?:" + "( " + EPHITHET + ")?" + "(?:" + "(?: .+)?" + "( " + RANK_MARKER_SPECIES + "[ .])" + ")?" + " (\u00d7?" + EPHITHET + ")" + ")?" + "(?: " + "(" + RANK_MARKER_MICROBIAL + ")[ .]" + "(\\S+)" + ")?");
        NAME_PATTERN = Pattern.compile("^(\u00d7?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152](?:\\.|[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)(?:-[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]?[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)?)(?:(?<!ceae) " + INFRAGENERIC + ")?" + "(?: (\u00d7?" + EPHITHET + "))?" + "(?:" + "( " + EPHITHET + ")??" + "(?:" + "(?: .+)??" + "( " + RANK_MARKER_SPECIES + ")" + ")?" + "(?: (\u00d7?\"?" + EPHITHET + "\"?))" + ")?" + "(?: " + "(" + RANK_MARKER_MICROBIAL + ")[ .]" + "(\\S+)" + ")?" + "(,?" + "(?: ?\\(" + "(" + AUTHOR_TEAM + ")?" + ",?( ?" + YEAR + ")?" + "\\))?" + "( " + AUTHOR_TEAM + ")?" + "(?: ?\\(?,? ?(" + YEAR + ")\\)?)?" + ")" + "$");
    }

    private class MatcherCallable
    implements Callable<Matcher> {
        private final String scientificName;

        MatcherCallable(String scientificName) {
            this.scientificName = scientificName;
        }

        @Override
        public Matcher call() throws Exception {
            Matcher matcher = NAME_PATTERN.matcher(this.scientificName);
            matcher.find();
            return matcher;
        }
    }
}

