/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.WMSCoverageReader;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WMSLayer
extends GridReaderLayer {
    static Style STYLE;

    public WMSLayer(WebMapServer wms, Layer layer) {
        super((GridCoverage2DReader)new WMSCoverageReader(wms, layer), STYLE);
    }

    public WMSCoverageReader getReader() {
        return (WMSCoverageReader)this.reader;
    }

    public synchronized ReferencedEnvelope getBounds() {
        WMSCoverageReader wmsReader = this.getReader();
        if (wmsReader != null) {
            return wmsReader.bounds;
        }
        return super.getBounds();
    }

    public String getFeatureInfoAsText(DirectPosition2D pos, int featureCount) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            GetMapRequest mapRequest = this.getReader().mapRequest;
            InputStream is = this.getReader().getFeatureInfo(pos, "text/plain", featureCount, mapRequest);
            br = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Failed to grab feature info").initCause(t);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public InputStream getFeatureInfo(DirectPosition2D pos, String infoFormat, int featureCount) throws IOException {
        GetMapRequest mapRequest = this.getReader().mapRequest;
        return this.getReader().getFeatureInfo(pos, infoFormat, featureCount, mapRequest);
    }

    public InputStream getFeatureInfo(ReferencedEnvelope bbox, int width, int height, int x, int y, String infoFormat, int featureCount) throws IOException {
        try {
            this.getReader().initMapRequest(bbox, width, height, null);
            AffineTransform at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)bbox, (Rectangle)new Rectangle(width, height));
            Point2D.Double screenPos = new Point2D.Double(x, y);
            Point2D.Double worldPos = new Point2D.Double(x, y);
            at.inverseTransform(screenPos, worldPos);
            DirectPosition2D fromPos = new DirectPosition2D(((Point2D)worldPos).getX(), ((Point2D)worldPos).getY());
            DirectPosition2D toPos = new DirectPosition2D();
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.getReader().requestCRS, (boolean)true);
            mt.transform((DirectPosition)fromPos, (DirectPosition)toPos);
            GetMapRequest mapRequest = this.getReader().mapRequest;
            return this.getReader().getFeatureInfo(toPos, infoFormat, featureCount, mapRequest);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Unexpected issue during GetFeatureInfo execution").initCause(t);
        }
    }

    public WebMapServer getWebMapServer() {
        return this.getReader().wms;
    }

    public List<Layer> getWMSLayers() {
        return this.getReader().layers;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.reader.getCoordinateReferenceSystem();
    }

    public GetMapRequest getLastGetMap() {
        return this.getReader().mapRequest;
    }

    public void addLayer(Layer layer) {
        this.getReader().addLayer(layer);
    }

    public boolean isNativelySupported(CoordinateReferenceSystem crs) {
        try {
            String code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            return code != null && this.getReader().validSRS.contains(code);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        RasterSymbolizer symbolizer = factory.createRasterSymbolizer();
        Rule rule = factory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle type = factory.createFeatureTypeStyle();
        type.rules().add(rule);
        STYLE = factory.createStyle();
        STYLE.featureTypeStyles().add(type);
    }
}

