/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.xml;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.Service;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.ows.WMSRequest;
import org.geotools.data.wms.WMS1_0_0;
import org.geotools.data.wms.xml.Dimension;
import org.geotools.data.wms.xml.Extent;
import org.geotools.data.wms.xml.MetadataURL;
import org.geotools.data.wms.xml.WMSSchema;
import org.geotools.metadata.iso.citation.AddressImpl;
import org.geotools.metadata.iso.citation.ContactImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.metadata.iso.citation.TelephoneImpl;
import org.geotools.ows.ServiceException;
import org.geotools.util.SimpleInternationalString;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.xLink.XLinkSchema;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.InternationalString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WMSComplexTypes {

    static class LatitudeType
    extends WMSSchema.WMSSimpleType {
        private static SimpleType instance = new LatitudeType();
        private static Facet[] facets = new Facet[]{new FacetGT(8, "-90"), new FacetGT(5, "90")};

        LatitudeType() {
        }

        public static SimpleType getInstance() {
            return instance;
        }

        public int getChildType() {
            return 2;
        }

        public SimpleType[] getParents() {
            return null;
        }

        public Facet[] getFacets() {
            return facets;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return new Double((String)value[0].getValue());
        }

        public String getName() {
            return "latitudeType";
        }

        public Class getInstanceType() {
            return Double.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class LongitudeType
    extends WMSSchema.WMSSimpleType {
        private static SimpleType instance = new LongitudeType();
        private static Facet[] facets = new Facet[]{new FacetGT(8, "-180"), new FacetGT(5, "180")};

        LongitudeType() {
        }

        public static SimpleType getInstance() {
            return instance;
        }

        public int getChildType() {
            return 2;
        }

        public SimpleType[] getParents() {
            return null;
        }

        public Facet[] getFacets() {
            return facets;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return new Double((String)value[0].getValue());
        }

        public String getName() {
            return "longitudeType";
        }

        public Class getInstanceType() {
            return Double.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _CW_WKBType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _CW_WKBType();

        protected _CW_WKBType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("CW_WKB");
        }

        public String getName() {
            return "CW_WKB";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _BLANKType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _BLANKType();

        protected _BLANKType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("BLANK");
        }

        public String getName() {
            return "BLANK";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _INIMAGEType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _INIMAGEType();

        protected _INIMAGEType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("INIMAGE");
        }

        public String getName() {
            return "INIMAGE";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _MIMEType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _MIMEType();

        protected _MIMEType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("MIME");
        }

        public String getName() {
            return "MIME";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _BMPType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _BMPType();

        protected _BMPType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("BMP");
        }

        public String getName() {
            return "BMP";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _WBMPType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _WBMPType();

        protected _WBMPType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("WBMP");
        }

        public String getName() {
            return "WBMP";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _GML_3Type
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _GML_3Type();

        protected _GML_3Type() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("GML.3");
        }

        public String getName() {
            return "GML.3";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _GML_2Type
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _GML_2Type();

        protected _GML_2Type() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("GML.2");
        }

        public String getName() {
            return "GML.2";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _GML_1Type
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _GML_1Type();

        protected _GML_1Type() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("GML.1");
        }

        public String getName() {
            return "GML.1";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _WMS_XMLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _WMS_XMLType();

        protected _WMS_XMLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("WMS_XML");
        }

        public String getName() {
            return "WMS_XML";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _SVGType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _SVGType();

        protected _SVGType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("SVG");
        }

        public String getName() {
            return "SVG";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _WebCGMType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _WebCGMType();

        protected _WebCGMType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("WebCGM");
        }

        public String getName() {
            return "WebCGM";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _GeoTIFFType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _GeoTIFFType();

        protected _GeoTIFFType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("GeoTIFF");
        }

        public String getName() {
            return "GeoTIFF";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _TIFFType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _TIFFType();

        protected _TIFFType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("TIFF");
        }

        public String getName() {
            return "TIFF";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _PPMType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _PPMType();

        protected _PPMType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("PPM");
        }

        public String getName() {
            return "PPM";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _PNGType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _PNGType();

        protected _PNGType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("PNG");
        }

        public String getName() {
            return "PNG";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _JPEGType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _JPEGType();

        protected _JPEGType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("JPEG");
        }

        public String getName() {
            return "JPEG";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _GIFType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _GIFType();

        protected _GIFType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return WMS1_0_0.toFormatMIME("GIF");
        }

        public String getName() {
            return "GIF";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _ServiceException
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ServiceException();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute("code", XSISimpleTypes.String.getInstance()), new WMSSchema.WMSAttribute("location", XSISimpleTypes.String.getInstance())};

        protected _ServiceException() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            String body = (String)value[value.length - 1].getValue();
            String code = attrs.getValue("code");
            String location = attrs.getValue("location");
            return new ServiceException(body, code, location);
        }

        public String getName() {
            return "ServiceException";
        }

        @Override
        public boolean isMixed() {
            return true;
        }

        public Class getInstanceType() {
            return ServiceException.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
        }
    }

    protected static class _ServiceExceptionReport
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ServiceExceptionReport();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("ServiceException", (Type)_ServiceException.getInstance(), 0, Integer.MAX_VALUE)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute("version", XSISimpleTypes.String.getInstance())};

        protected _ServiceExceptionReport() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            ServiceException exception;
            int i;
            ArrayList<ServiceException> codes = new ArrayList<ServiceException>();
            ArrayList<ServiceException> noCodes = new ArrayList<ServiceException>();
            for (int i2 = 0; i2 < value.length; ++i2) {
                ServiceException exception2 = (ServiceException)value[i2].getValue();
                if (exception2.getCode() != null && exception2.getCode().length() != 0) {
                    codes.add(exception2);
                    continue;
                }
                noCodes.add(exception2);
            }
            ServiceException firstException = null;
            ServiceException recentException = null;
            for (i = 0; i < codes.size(); ++i) {
                exception = (ServiceException)codes.get(i);
                if (firstException == null) {
                    firstException = exception;
                    recentException = exception;
                    continue;
                }
                recentException.setNext(exception);
                recentException = exception;
            }
            codes = null;
            for (i = 0; i < noCodes.size(); ++i) {
                exception = (ServiceException)noCodes.get(i);
                if (firstException == null) {
                    firstException = exception;
                    recentException = exception;
                    continue;
                }
                recentException.setNext(exception);
                recentException = exception;
            }
            noCodes = null;
            return firstException;
        }

        public String getName() {
            return "ServiceExceptionReport";
        }

        public Class getInstanceType() {
            return ServiceException.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
        }
    }

    protected static class _WMTException
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _WMTException();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute("version", XSISimpleTypes.String.getInstance())};

        protected _WMTException() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return new ServiceException((String)value[value.length - 1].getValue(), null);
        }

        public String getName() {
            return "WMTException";
        }

        @Override
        public boolean isMixed() {
            return true;
        }

        public Class getInstanceType() {
            return ServiceException.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
        }
    }

    protected static class _OnlineResourceType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _OnlineResourceType();

        protected _OnlineResourceType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return XLinkSchema.SimpleLink.getInstance().getAttributes();
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            String href;
            if (value != null && value.length >= 1) {
                try {
                    return new URL((String)value[value.length - 1].getValue());
                }
                catch (MalformedURLException e1) {
                    // empty catch block
                }
            }
            href = (href = attrs.getValue("", "href")) != null ? href : attrs.getValue(XLinkSchema.NAMESPACE.toString(), "href");
            try {
                return new URL(href);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getName() {
            return "OnlineResource";
        }

        public Class getInstanceType() {
            return URL.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _ScaleHintType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ScaleHintType();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute("min", XSISimpleTypes.String.getInstance()), new WMSSchema.WMSAttribute(null, "max", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false)};

        protected _ScaleHintType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            double[] scaleHint = new double[]{Double.parseDouble(attrs.getValue("min")), Double.parseDouble(attrs.getValue("max"))};
            return scaleHint;
        }

        public String getName() {
            return "ScaleHint";
        }

        public Class getInstanceType() {
            return double[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _StyleURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _StyleURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance()), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _StyleURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "StyleURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _StyleSheetURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _StyleSheetURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance()), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _StyleSheetURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "StyleSheetURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _LegendURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _LegendURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance()), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute("width", XSISimpleTypes.PositiveInteger.getInstance()), new WMSSchema.WMSAttribute("height", XSISimpleTypes.PositiveInteger.getInstance())};

        protected _LegendURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            String legendURL = value[1].getValue().toString();
            return legendURL;
        }

        public String getName() {
            return "LegendURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _StyleType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _StyleType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Name", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("Title", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("Abstract", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("LegendURL", (Type)_LegendURLType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("StyleSheetURL", (Type)_StyleSheetURLType.getInstance(), 0, 1), new WMSSchema.WMSElement("StyleURL", (Type)_StyleURLType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _StyleType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            StyleImpl style = new StyleImpl();
            ArrayList<String> legendURLS = new ArrayList<String>();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    String name = (String)value[i].getValue();
                    style.setName(name);
                }
                if (this.sameName(elems[1], value[i])) {
                    String title = (String)value[i].getValue();
                    style.setTitle((InternationalString)new SimpleInternationalString(title));
                }
                if (this.sameName(elems[2], value[i])) {
                    String _abstract = (String)value[i].getValue();
                    style.setAbstract((InternationalString)new SimpleInternationalString(_abstract));
                }
                if (this.sameName(elems[3], value[i])) {
                    legendURLS.add((String)value[i].getValue());
                }
                if (this.sameName(elems[4], value[i])) {
                    // empty if block
                }
                if (!this.sameName(elems[5], value[i])) continue;
            }
            style.setLegendURLs(legendURLS);
            return style;
        }

        public String getName() {
            return "Style";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _FeatureListURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _FeatureListURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance()), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _FeatureListURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "FeatureListURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _DataURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _DataURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance()), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _DataURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "DataURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _IdentifierType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _IdentifierType();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "authority", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false)};

        protected _IdentifierType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "Identifier";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _AuthorityURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _AuthorityURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "name", WMSSchema.NAMESPACE, XSISimpleTypes.NMTOKEN.getInstance(), 2, null, null, false)};

        protected _AuthorityURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "AuthorityURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _MetadataURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _MetadataURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance()), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "type", WMSSchema.NAMESPACE, XSISimpleTypes.NMTOKEN.getInstance(), 2, null, null, false)};

        protected _MetadataURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public boolean isMixed() {
            return true;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            String type = attrs.getValue("type").toString();
            URL url = (URL)value[1].getValue();
            String format = (String)((Object[])value[0].getValue())[0];
            MetadataURL metadataURL = new MetadataURL(url, type, format);
            return metadataURL;
        }

        public String getName() {
            return "MetadataURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _LogoURLType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _LogoURLType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance()), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute("width", XSISimpleTypes.PositiveInteger.getInstance()), new WMSSchema.WMSAttribute("height", XSISimpleTypes.PositiveInteger.getInstance())};

        protected _LogoURLType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "LogoURL";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _AttributionType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _AttributionType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Title", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance(), 0, 1), new WMSSchema.WMSElement("LogoURL", (Type)_LogoURLType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _AttributionType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "Attribution";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _ExtentType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ExtentType();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "name", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false), new WMSSchema.WMSAttribute(null, "default", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false), new WMSSchema.WMSAttribute(null, "nearestValue", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false)};

        protected _ExtentType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            String name = attrs.getValue("name");
            if (name == null || name.length() == 0) {
                throw new SAXException("Dimension element contains no 'name' attribute");
            }
            String defaultValue = attrs.getValue("default");
            boolean multipleValues = "1".equals(attrs.getValue("multipleValues"));
            boolean nearestValue = "1".equals(attrs.getValue("nearestValue"));
            String extractedValue = "";
            for (ElementValue elementValue : value) {
                extractedValue = extractedValue + elementValue.getValue();
            }
            return new Extent(name, defaultValue, multipleValues, nearestValue, extractedValue);
        }

        public String getName() {
            return "Extent";
        }

        public Class getInstanceType() {
            return Extent.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _DimensionType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _DimensionType();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "name", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute(null, "units", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute("unitSymbol", XSISimpleTypes.String.getInstance()), new WMSSchema.WMSAttribute("default", XSISimpleTypes.String.getInstance()), new WMSSchema.WMSAttribute("current", XSISimpleTypes.Boolean.getInstance()), new WMSSchema.WMSAttribute(null, "multipleValues", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false), new WMSSchema.WMSAttribute(null, "nearestValue", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false)};

        protected _DimensionType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public boolean isMixed() {
            return true;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Extent ext;
            String unitSymbol;
            String name = attrs.getValue("name");
            if (name == null || name.length() == 0) {
                throw new SAXException("Dimension element contains no 'name' attribute");
            }
            String units = attrs.getValue("units");
            if (units == null || units.length() == 0) {
                throw new SAXException("Dimension element contains no 'units' attribute");
            }
            Dimension dim = new Dimension(name, units);
            Boolean current = Boolean.parseBoolean(attrs.getValue("current"));
            if (current != null) {
                dim.setCurrent(current);
            }
            if ((unitSymbol = attrs.getValue("unitSymbol")) != null && unitSymbol.length() > 0) {
                dim.setUnitSymbol(unitSymbol);
            }
            if (!(ext = (Extent)_ExtentType.instance.getValue(element, value, attrs, hints)).isEmpty()) {
                dim.setExtent(ext);
            }
            return dim;
        }

        public String getName() {
            return "Dimension";
        }

        public Class getInstanceType() {
            return Dimension.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _BoundingBoxType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _BoundingBoxType();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "CRS", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false), new WMSSchema.WMSAttribute(null, "SRS", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false), new WMSSchema.WMSAttribute(null, "minx", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute(null, "miny", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute(null, "maxx", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute(null, "maxy", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute("resx", XSISimpleTypes.Double.getInstance()), new WMSSchema.WMSAttribute("resy", XSISimpleTypes.Double.getInstance())};

        protected _BoundingBoxType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            CRSEnvelope bbox = new CRSEnvelope();
            String crs = attrs.getValue("CRS");
            if (!(crs != null && crs.length() != 0 || (crs = attrs.getValue("SRS")) != null && crs.length() != 0)) {
                throw new SAXException("Bounding Box element contains no CRS/SRS attribute");
            }
            bbox.setEPSGCode(crs.toUpperCase());
            bbox.setMinX(Double.parseDouble(attrs.getValue("minx")));
            bbox.setMaxX(Double.parseDouble(attrs.getValue("maxx")));
            bbox.setMinY(Double.parseDouble(attrs.getValue("miny")));
            bbox.setMaxY(Double.parseDouble(attrs.getValue("maxy")));
            return bbox;
        }

        public String getName() {
            return "BoundingBox";
        }

        public Class getInstanceType() {
            return CRSEnvelope.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _LatLonBoundingBoxType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _LatLonBoundingBoxType();
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "minx", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute(null, "miny", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute(null, "maxx", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute(null, "maxy", WMSSchema.NAMESPACE, XSISimpleTypes.Double.getInstance(), 2, null, null, false)};

        protected _LatLonBoundingBoxType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            CRSEnvelope bbox = new CRSEnvelope();
            bbox.setMinX(Double.parseDouble(attrs.getValue("minx")));
            bbox.setMaxX(Double.parseDouble(attrs.getValue("maxx")));
            bbox.setMinY(Double.parseDouble(attrs.getValue("miny")));
            bbox.setMaxY(Double.parseDouble(attrs.getValue("maxy")));
            return bbox;
        }

        public String getName() {
            return "LatLonBoundingBox";
        }

        public Class getInstanceType() {
            return CRSEnvelope.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _EX_GeographicBoundingBoxType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _EX_GeographicBoundingBoxType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("westBoundLongitude", (Type)LongitudeType.getInstance()), new WMSSchema.WMSElement("eastBoundLongitude", (Type)LongitudeType.getInstance()), new WMSSchema.WMSElement("southBoundLatitude", (Type)LatitudeType.getInstance()), new WMSSchema.WMSElement("northBoundLatitude", (Type)LatitudeType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _EX_GeographicBoundingBoxType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            CRSEnvelope bbox = new CRSEnvelope();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    bbox.setMinX((Double)value[i].getValue());
                }
                if (this.sameName(elems[1], value[i])) {
                    bbox.setMaxX((Double)value[i].getValue());
                }
                if (this.sameName(elems[2], value[i])) {
                    bbox.setMinY((Double)value[i].getValue());
                }
                if (!this.sameName(elems[3], value[i])) continue;
                bbox.setMaxY((Double)value[i].getValue());
            }
            return bbox;
        }

        public String getName() {
            return "EX_GeographicBoundingBox";
        }

        public Class getInstanceType() {
            return CRSEnvelope.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _LayerType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _LayerType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Name", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("Title", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("Abstract", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("KeywordList", (Type)_KeywordListType.getInstance(), 0, 1), new WMSSchema.WMSElement("CRS", (Type)XSISimpleTypes.String.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("EX_GeographicBoundingBox", (Type)_EX_GeographicBoundingBoxType.getInstance(), 0, 1), new WMSSchema.WMSElement("BoundingBox", (Type)_BoundingBoxType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("Dimension", (Type)_DimensionType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("Extent", (Type)_ExtentType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("Attribution", (Type)_AttributionType.getInstance(), 0, 1), new WMSSchema.WMSElement("AuthorityURL", (Type)_AuthorityURLType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("Identifier", (Type)_IdentifierType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("MetadataURL", (Type)_MetadataURLType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("DataURL", (Type)_DataURLType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("FeatureListURL", (Type)_FeatureListURLType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("Style", (Type)_StyleType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("MinScaleDenominator", (Type)XSISimpleTypes.Double.getInstance(), 0, 1), new WMSSchema.WMSElement("MaxScaleDenominator", (Type)XSISimpleTypes.Double.getInstance(), 0, 1), new WMSSchema.WMSElement("Layer", (Type)_LayerType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("SRS", (Type)XSISimpleTypes.String.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("LatLonBoundingBox", (Type)_LatLonBoundingBoxType.getInstance(), 0, 1), new WMSSchema.WMSElement("ScaleHint", (Type)_ScaleHintType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT(new ElementGrouping[]{elems[0], elems[1], elems[2], elems[3], new ChoiceGT(null, 0, Integer.MAX_VALUE, (ElementGrouping[])new Element[]{elems[4], elems[19]}), new ChoiceGT(null, 0, 1, (ElementGrouping[])new Element[]{elems[5], elems[20]}), elems[6], elems[7], elems[8], elems[9], elems[10], elems[11], elems[12], elems[13], elems[14], elems[15], elems[16], elems[17], elems[18], elems[21]});
        private static Attribute[] attributes = new Attribute[]{new WMSSchema.WMSAttribute(null, "queryable", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 2, "0", null, false), new WMSSchema.WMSAttribute("cascaded", XSISimpleTypes.NonNegativeInteger.getInstance()), new WMSSchema.WMSAttribute(null, "opaque", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 2, "0", null, false), new WMSSchema.WMSAttribute(null, "noSubSets", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 2, "0", null, false), new WMSSchema.WMSAttribute("fixedWidth", XSISimpleTypes.NonNegativeInteger.getInstance()), new WMSSchema.WMSAttribute("fixedHeight", XSISimpleTypes.NonNegativeInteger.getInstance())};

        protected _LayerType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            ArrayList<Layer> childLayers = new ArrayList<Layer>();
            Layer layer = new Layer();
            TreeSet<String> crs = new TreeSet<String>();
            HashMap<String, CRSEnvelope> boundingBoxes = new HashMap<String, CRSEnvelope>();
            HashMap<String, Dimension> dimensions = new HashMap<String, Dimension>();
            HashMap<String, Extent> extents = new HashMap<String, Extent>();
            ArrayList<StyleImpl> styles = new ArrayList<StyleImpl>();
            ArrayList<MetadataURL> metadataURLS = new ArrayList<MetadataURL>();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    layer.setName((String)value[i].getValue());
                }
                if (this.sameName(elems[1], value[i])) {
                    layer.setTitle((String)value[i].getValue());
                }
                if (this.sameName(elems[2], value[i])) {
                    layer.set_abstract((String)value[i].getValue());
                }
                if (this.sameName(elems[3], value[i])) {
                    layer.setKeywords((String[])value[i].getValue());
                }
                if (this.sameName(elems[4], value[i]) || this.sameName(elems[19], value[i])) {
                    String[] crss = ((String)value[i].getValue()).split(" ");
                    for (int j = 0; j < crss.length; ++j) {
                        crs.add(crss[j].toUpperCase());
                    }
                }
                if (this.sameName(elems[5], value[i]) || this.sameName(elems[20], value[i])) {
                    layer.setLatLonBoundingBox((CRSEnvelope)value[i].getValue());
                }
                if (this.sameName(elems[6], value[i])) {
                    CRSEnvelope bbox = (CRSEnvelope)value[i].getValue();
                    boundingBoxes.put(bbox.getEPSGCode(), bbox);
                }
                if (this.sameName(elems[7], value[i])) {
                    Dimension dim = (Dimension)value[i].getValue();
                    dimensions.put(dim.getName(), dim);
                }
                if (this.sameName(elems[8], value[i])) {
                    Extent ext = (Extent)value[i].getValue();
                    extents.put(ext.getName(), ext);
                }
                if (this.sameName(elems[12], value[i])) {
                    MetadataURL metadataUrl = (MetadataURL)value[i].getValue();
                    metadataURLS.add(metadataUrl);
                }
                if (this.sameName(elems[15], value[i])) {
                    styles.add((StyleImpl)value[i].getValue());
                }
                if (this.sameName(elems[16], value[i])) {
                    Double min = (Double)value[i].getValue();
                    layer.setScaleDenominatorMin(min);
                }
                if (this.sameName(elems[17], value[i])) {
                    Double max = (Double)value[i].getValue();
                    layer.setScaleDenominatorMax(max);
                }
                if (this.sameName(elems[18], value[i])) {
                    Layer childLayer = (Layer)value[i].getValue();
                    childLayer.setParent(layer);
                    childLayers.add(childLayer);
                }
                if (!this.sameName(elems[21], value[i])) continue;
                double[] scaleHint = (double[])value[i].getValue();
                layer.setScaleHintMin(scaleHint[0]);
                layer.setScaleHintMax(scaleHint[1]);
            }
            layer.setSrs(crs);
            layer.setBoundingBoxes(boundingBoxes);
            layer.setDimensions(dimensions);
            layer.setExtents(extents);
            layer.setStyles(styles);
            layer.setMetadataURL(metadataURLS);
            layer.setChildren(childLayers.toArray(new Layer[childLayers.size()]));
            String queryable = attrs.getValue("queryable");
            if (queryable != null) {
                if ("1".equals(queryable) || "true".equalsIgnoreCase(queryable)) {
                    layer.setQueryable(true);
                } else if ("0".equals(queryable) || "false".equalsIgnoreCase(queryable)) {
                    layer.setQueryable(false);
                }
            }
            String cascaded = attrs.getValue("cascaded");
            int cascadedValue = 0;
            if (cascaded != null) {
                try {
                    cascadedValue = Integer.parseInt(cascaded);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            layer.setCascaded(cascadedValue);
            return layer;
        }

        public String getName() {
            return "Layer";
        }

        public Class getInstanceType() {
            return Layer.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _ExceptionType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ExceptionType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance(), 1, Integer.MAX_VALUE)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _ExceptionType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            String[] formatStrings = new String[value.length];
            for (int i = 0; i < value.length; ++i) {
                Object[] stringValues = (Object[])value[i].getValue();
                for (int ii = 0; ii < stringValues.length; ++ii) {
                    formatStrings[i] = (String)stringValues[ii];
                }
            }
            return formatStrings;
        }

        public String getName() {
            return "Exception";
        }

        public Class getInstanceType() {
            return String[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _PostType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _PostType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance())};
        private static Attribute[] attributes = new Attribute[]{new WMSSchema.WMSAttribute(null, "onlineResource", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _PostType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            try {
                return new URL(attrs.getValue("onlineResource"));
            }
            catch (MalformedURLException e) {
                return (URL)value[0].getValue();
            }
        }

        public String getName() {
            return "Post";
        }

        public Class getInstanceType() {
            return URL.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _GetType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _GetType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attributes = new Attribute[]{new WMSSchema.WMSAttribute(null, "onlineResource", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 0, null, null, false)};

        protected _GetType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            try {
                return new URL(attrs.getValue("onlineResource"));
            }
            catch (MalformedURLException e) {
                return (URL)value[0].getValue();
            }
        }

        public String getName() {
            return "Get";
        }

        public Class getInstanceType() {
            return URL.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _HTTPType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _HTTPType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Get", (Type)_GetType.getInstance(), 0, 1), new WMSSchema.WMSElement("Post", (Type)_PostType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _HTTPType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            org.geotools.data.ows.OperationType operationType = new org.geotools.data.ows.OperationType();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    operationType.setGet((URL)value[i].getValue());
                }
                if (!this.sameName(elems[1], value[i])) continue;
                operationType.setPost((URL)value[i].getValue());
            }
            return operationType;
        }

        public String getName() {
            return "HTTP";
        }

        public Class getInstanceType() {
            return org.geotools.data.ows.OperationType.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _DCPTypeType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _DCPTypeType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("HTTP", (Type)_HTTPType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _DCPTypeType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return value[0].getValue();
        }

        public String getName() {
            return "HTTP";
        }

        public Class getInstanceType() {
            return org.geotools.data.ows.OperationType.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _RequestType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _RequestType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("GetCapabilities", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("GetMap", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("GetFeatureInfo", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("DescribeLayer", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("GetLegendGraphic", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("GetStyles", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("PutStyles", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("_ExtendedOperation", (Type)OperationType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("Capabilities", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("Map", (Type)OperationType.getInstance(), 0, 1), new WMSSchema.WMSElement("FeatureInfo", (Type)OperationType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT(new ElementGrouping[]{new ChoiceGT(new ElementGrouping[]{new SequenceGT(new ElementGrouping[]{elems[9], elems[8]}), new SequenceGT(new ElementGrouping[]{elems[0], elems[1]})}), new ChoiceGT(null, 0, 1, (ElementGrouping[])new Element[]{elems[2], elems[10]}), elems[3], elems[4], elems[5], elems[6], elems[7]});

        protected _RequestType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            WMSRequest request = new WMSRequest();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i]) || this.sameName(elems[8], value[i])) {
                    request.setGetCapabilities((org.geotools.data.ows.OperationType)value[i].getValue());
                }
                if (this.sameName(elems[1], value[i]) || this.sameName(elems[9], value[i])) {
                    request.setGetMap((org.geotools.data.ows.OperationType)value[i].getValue());
                }
                if (this.sameName(elems[2], value[i]) || this.sameName(elems[10], value[i])) {
                    request.setGetFeatureInfo((org.geotools.data.ows.OperationType)value[i].getValue());
                }
                if (this.sameName(elems[3], value[i])) {
                    request.setDescribeLayer((org.geotools.data.ows.OperationType)value[i].getValue());
                }
                if (this.sameName(elems[4], value[i])) {
                    request.setGetLegendGraphic((org.geotools.data.ows.OperationType)value[i].getValue());
                }
                if (this.sameName(elems[5], value[i])) {
                    request.setGetStyles((org.geotools.data.ows.OperationType)value[i].getValue());
                }
                if (!this.sameName(elems[6], value[i])) continue;
                request.setPutStyles((org.geotools.data.ows.OperationType)value[i].getValue());
            }
            return request;
        }

        public String getName() {
            return "Request";
        }

        public Class getInstanceType() {
            return WMSRequest.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class __ExtendedCapabilitiesType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new __ExtendedCapabilitiesType();

        protected __ExtendedCapabilitiesType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return null;
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _UserDefinedSymbolizationType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new __ExtendedCapabilitiesType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("SupportedSLDVersion", (Type)XSISimpleTypes.String.getInstance(), 0, Integer.MAX_VALUE)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "SupportSLD", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false), new WMSSchema.WMSAttribute(null, "UserLayer", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false), new WMSSchema.WMSAttribute(null, "UserStyle", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false), new WMSSchema.WMSAttribute(null, "RemoteWFS", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false), new WMSSchema.WMSAttribute(null, "RemoteWCS", WMSSchema.NAMESPACE, XSISimpleTypes.Boolean.getInstance(), 0, "0", null, false)};

        protected _UserDefinedSymbolizationType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "UserDefinedSymbolization";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _VendorSpecificCapabilitiesType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new __ExtendedCapabilitiesType();

        protected _VendorSpecificCapabilitiesType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return null;
        }

        public String getName() {
            return "VendorSpecificCapabilities";
        }

        public Class getInstanceType() {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _CapabilityType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _CapabilityType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Request", (Type)_RequestType.getInstance()), new WMSSchema.WMSElement("Exception", (Type)_ExceptionType.getInstance()), new WMSSchema.WMSElement("VendorSpecificCapabilities", (Type)_VendorSpecificCapabilitiesType.getInstance(), 0, 1), new WMSSchema.WMSElement("UserDefinedSymbolization", (Type)_UserDefinedSymbolizationType.getInstance(), 0, 1), new WMSSchema.WMSElement("_ExtendedCapabilities", (Type)__ExtendedCapabilitiesType.getInstance(), 0, Integer.MAX_VALUE), new WMSSchema.WMSElement("Layer", (Type)_LayerType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _CapabilityType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            WMSCapabilities capabilities = new WMSCapabilities();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    capabilities.setRequest((WMSRequest)value[i].getValue());
                }
                if (this.sameName(elems[1], value[i])) {
                    capabilities.setExceptions((String[])value[i].getValue());
                }
                if (!this.sameName(elems[5], value[i])) continue;
                Layer layer = (Layer)value[i].getValue();
                capabilities.setLayer(layer);
            }
            return capabilities;
        }

        public String getName() {
            return "Capability";
        }

        public Class getInstanceType() {
            return WMSCapabilities.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _ContactAddressType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ContactAddressType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("AddressType", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("Address", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("City", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("StateOrProvince", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("PostCode", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("Country", (Type)XSISimpleTypes.String.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _ContactAddressType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            AddressImpl address = new AddressImpl();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[1], value[i])) {
                    String address1 = (String)value[i].getValue();
                    address.setDeliveryPoints(Collections.singleton(address1));
                }
                if (this.sameName(elems[2], value[i])) {
                    String city = (String)value[i].getValue();
                    address.setCity((InternationalString)new SimpleInternationalString(city));
                }
                if (this.sameName(elems[3], value[i])) {
                    String state = (String)value[i].getValue();
                    address.setAdministrativeArea((InternationalString)new SimpleInternationalString(state));
                }
                if (this.sameName(elems[4], value[i])) {
                    String postalCode = (String)value[i].getValue();
                    address.setPostalCode(postalCode);
                }
                if (!this.sameName(elems[5], value[i])) continue;
                String country = (String)value[i].getValue();
                address.setCountry((InternationalString)new SimpleInternationalString(country));
            }
            return address;
        }

        public String getName() {
            return "ContactAddress";
        }

        public Class getInstanceType() {
            return AddressImpl.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _ContactPersonPrimaryType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ContactPersonPrimaryType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("ContactPerson", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("ContactOrganization", (Type)XSISimpleTypes.String.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _ContactPersonPrimaryType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            ResponsiblePartyImpl responsibleParty = new ResponsiblePartyImpl();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    String name = (String)value[i].getValue();
                    responsibleParty.setIndividualName(name);
                }
                if (!this.sameName(elems[1], value[i])) continue;
                String organization = (String)value[i].getValue();
                responsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString(organization));
            }
            return responsibleParty;
        }

        public String getName() {
            return "ContactPersonPrimary";
        }

        public Class getInstanceType() {
            return ResponsiblePartyImpl.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _ContactInformationType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ContactInformationType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("ContactPersonPrimary", (Type)_ContactPersonPrimaryType.getInstance(), 0, 1), new WMSSchema.WMSElement("ContactPosition", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("ContactAddress", (Type)_ContactAddressType.getInstance(), 0, 1), new WMSSchema.WMSElement("ContactVoiceTelephone", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("ContactFacsimileTelephone", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("ContactElectronicMailAddress", (Type)XSISimpleTypes.String.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _ContactInformationType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            int i;
            ResponsiblePartyImpl contactPerson = null;
            for (int i2 = 0; i2 < value.length; ++i2) {
                if (!this.sameName(elems[0], value[i2])) continue;
                contactPerson = (ResponsiblePartyImpl)value[i2].getValue();
            }
            if (contactPerson == null) {
                contactPerson = new ResponsiblePartyImpl();
            }
            TelephoneImpl telephone = null;
            AddressImpl address = null;
            ContactImpl contact = new ContactImpl();
            for (i = 0; i < value.length; ++i) {
                contactPerson.setContactInfo((Contact)contact);
                if (this.sameName(elems[1], value[i])) {
                    String positionName = (String)value[i].getValue();
                    contactPerson.setPositionName((InternationalString)new SimpleInternationalString(positionName));
                }
                if (this.sameName(elems[2], value[i])) {
                    address = (AddressImpl)value[i].getValue();
                }
                if (this.sameName(elems[3], value[i])) {
                    Set<Object> voices = Collections.singleton(value[i].getValue());
                    if (telephone == null) {
                        telephone = new TelephoneImpl();
                    }
                    telephone.setVoices(voices);
                }
                if (this.sameName(elems[4], value[i])) {
                    Set<Object> fax = Collections.singleton(value[i].getValue());
                    if (telephone == null) {
                        telephone = new TelephoneImpl();
                    }
                    telephone.setFacsimiles(fax);
                }
                contact.setPhone((Telephone)telephone);
            }
            for (i = 0; i < value.length; ++i) {
                if (!this.sameName(elems[5], value[i])) continue;
                String email = (String)value[i].getValue();
                if (address == null) {
                    address = new AddressImpl();
                }
                address.setElectronicMailAddresses(Collections.singleton(email));
            }
            contact.setAddress(address);
            return contactPerson;
        }

        public String getName() {
            return "ContactInformation";
        }

        public Class getInstanceType() {
            return ResponsiblePartyImpl.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _KeywordsType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _KeywordsType();

        protected _KeywordsType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Object keywords = value[value.length - 1].getValue();
            if (keywords == null) {
                return null;
            }
            return ((String)keywords).split(" ");
        }

        public String getName() {
            return "Keywords";
        }

        public Class getInstanceType() {
            return String[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _KeywordType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _KeywordType();
        private static Attribute[] attributes = new Attribute[]{new WMSSchema.WMSAttribute("vocabulary", XSISimpleTypes.String.getInstance())};

        protected _KeywordType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attributes;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            return value[value.length - 1].getValue();
        }

        public String getName() {
            return "Keyword";
        }

        public Class getInstanceType() {
            return String.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _KeywordListType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _KeywordListType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Keyword", (Type)_KeywordType.getInstance(), 0, Integer.MAX_VALUE)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        protected _KeywordListType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            String[] keywords = new String[value.length];
            for (int i = 0; i < value.length; ++i) {
                keywords[i] = (String)value[i].getValue();
            }
            return keywords;
        }

        public String getName() {
            return "KeywordList";
        }

        public Class getInstanceType() {
            return String[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _ServiceType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _ServiceType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Name", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("Title", (Type)XSISimpleTypes.String.getInstance()), new WMSSchema.WMSElement("Abstract", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("KeywordList", (Type)_KeywordListType.getInstance(), 0, 1), new WMSSchema.WMSElement("OnlineResource", (Type)_OnlineResourceType.getInstance()), new WMSSchema.WMSElement("ContactInformation", (Type)_ContactInformationType.getInstance(), 0, 1), new WMSSchema.WMSElement("Fees", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("AccessConstraints", (Type)XSISimpleTypes.String.getInstance(), 0, 1), new WMSSchema.WMSElement("LayerLimit", (Type)XSISimpleTypes.PositiveInteger.getInstance(), 0, 1), new WMSSchema.WMSElement("MaxWidth", (Type)XSISimpleTypes.PositiveInteger.getInstance(), 0, 1), new WMSSchema.WMSElement("MaxHeight", (Type)XSISimpleTypes.PositiveInteger.getInstance(), 0, 1), new WMSSchema.WMSElement("Keywords", (Type)_KeywordsType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT(new ElementGrouping[]{elems[0], elems[1], elems[2], new ChoiceGT(null, 0, 1, (ElementGrouping[])new Element[]{elems[3], elems[11]}), elems[4], elems[5], elems[6], elems[7], elems[8], elems[9], elems[10]});

        protected _ServiceType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            Service service = new Service();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    service.setName((String)value[i].getValue());
                }
                if (this.sameName(elems[1], value[i])) {
                    service.setTitle((String)value[i].getValue());
                }
                if (this.sameName(elems[2], value[i])) {
                    service.set_abstract((String)value[i].getValue());
                }
                if (this.sameName(elems[3], value[i]) || this.sameName(elems[11], value[i])) {
                    service.setKeywordList((String[])value[i].getValue());
                }
                if (this.sameName(elems[4], value[i])) {
                    service.setOnlineResource((URL)value[i].getValue());
                }
                if (this.sameName(elems[5], value[i])) {
                    ResponsiblePartyImpl contactInfo = (ResponsiblePartyImpl)value[i].getValue();
                    service.setContactInformation((ResponsibleParty)contactInfo);
                }
                if (this.sameName(elems[8], value[i])) {
                    service.setLayerLimit((Integer)value[i].getValue());
                }
                if (this.sameName(elems[9], value[i])) {
                    service.setMaxWidth((Integer)value[i].getValue());
                }
                if (!this.sameName(elems[10], value[i])) continue;
                service.setMaxHeight((Integer)value[i].getValue());
            }
            return service;
        }

        public String getName() {
            return "Service";
        }

        public Class getInstanceType() {
            return Service.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _FormatType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _FormatType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("GIF", (Type)_GIFType.getInstance(), 0, 1), new WMSSchema.WMSElement("JPEG", (Type)_JPEGType.getInstance(), 0, 1), new WMSSchema.WMSElement("PNG", (Type)_PNGType.getInstance(), 0, 1), new WMSSchema.WMSElement("PPM", (Type)_PPMType.getInstance(), 0, 1), new WMSSchema.WMSElement("TIFF", (Type)_TIFFType.getInstance(), 0, 1), new WMSSchema.WMSElement("GeoTIFF", (Type)_GeoTIFFType.getInstance(), 0, 1), new WMSSchema.WMSElement("WebCGM", (Type)_WebCGMType.getInstance(), 0, 1), new WMSSchema.WMSElement("SVG", (Type)_SVGType.getInstance(), 0, 1), new WMSSchema.WMSElement("WMS_XML", (Type)_WMS_XMLType.getInstance(), 0, 1), new WMSSchema.WMSElement("GML.1", (Type)_GML_1Type.getInstance(), 0, 1), new WMSSchema.WMSElement("GML.2", (Type)_GML_2Type.getInstance(), 0, 1), new WMSSchema.WMSElement("GML.3", (Type)_GML_3Type.getInstance(), 0, 1), new WMSSchema.WMSElement("BMP", (Type)_BMPType.getInstance(), 0, 1), new WMSSchema.WMSElement("WBMP", (Type)_WBMPType.getInstance(), 0, 1), new WMSSchema.WMSElement("MIME", (Type)_MIMEType.getInstance(), 0, 1), new WMSSchema.WMSElement("INIMAGE", (Type)_INIMAGEType.getInstance(), 0, 1), new WMSSchema.WMSElement("BLANK", (Type)_BLANKType.getInstance(), 0, 1)};
        private static Sequence seq = new SequenceGT(new ElementGrouping[]{new ChoiceGT(null, 0, Integer.MAX_VALUE, (ElementGrouping[])elems)});

        protected _FormatType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            ArrayList<Object> strings = new ArrayList<Object>();
            for (int i = 0; i < value.length; ++i) {
                if (value[i].getValue() == null || ((String)value[i].getValue()).length() == 0) continue;
                strings.add(value[i].getValue());
            }
            return strings.toArray();
        }

        public String getName() {
            return "Format";
        }

        public Class getInstanceType() {
            return String[].class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }

        @Override
        public boolean isMixed() {
            return true;
        }
    }

    protected static class _WMS_CapabilitiesType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _WMS_CapabilitiesType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Service", (Type)_ServiceType.getInstance()), new WMSSchema.WMSElement("Capability", (Type)_CapabilityType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "version", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute("updateSequence", XSISimpleTypes.String.getInstance())};

        protected _WMS_CapabilitiesType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            WMSCapabilities capabilities = null;
            Service service = null;
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    service = (Service)value[i].getValue();
                }
                if (!this.sameName(elems[1], value[i])) continue;
                capabilities = (WMSCapabilities)value[i].getValue();
            }
            capabilities.setVersion(attrs.getValue("", "version"));
            capabilities.setUpdateSequence(attrs.getValue("", "updateSequence"));
            capabilities.setService(service);
            return capabilities;
        }

        public String getName() {
            return "WMS_Capabilities";
        }

        public Class getInstanceType() {
            return WMSCapabilities.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    protected static class _WMT_MS_CapabilitiesType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new _WMT_MS_CapabilitiesType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Service", (Type)_ServiceType.getInstance()), new WMSSchema.WMSElement("Capability", (Type)_CapabilityType.getInstance())};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);
        private static Attribute[] attrs = new Attribute[]{new WMSSchema.WMSAttribute(null, "version", WMSSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false), new WMSSchema.WMSAttribute("updateSequence", XSISimpleTypes.String.getInstance())};

        protected _WMT_MS_CapabilitiesType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            WMSCapabilities capabilities = null;
            Service service = null;
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    service = (Service)value[i].getValue();
                }
                if (!this.sameName(elems[1], value[i])) continue;
                capabilities = (WMSCapabilities)value[i].getValue();
            }
            capabilities.setVersion(attrs.getValue("", "version"));
            capabilities.setUpdateSequence(attrs.getValue("", "updateSequence"));
            capabilities.setService(service);
            return capabilities;
        }

        public String getName() {
            return "WMT_MS_Capabilities";
        }

        public Class getInstanceType() {
            return WMSCapabilities.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class OperationType
    extends WMSSchema.WMSComplexType {
        private static final WMSSchema.WMSComplexType instance = new OperationType();
        private static Element[] elems = new Element[]{new WMSSchema.WMSElement("Format", (Type)_FormatType.getInstance(), 1, Integer.MAX_VALUE), new WMSSchema.WMSElement("DCPType", (Type)_DCPTypeType.getInstance(), 1, Integer.MAX_VALUE)};
        private static Sequence seq = new SequenceGT((ElementGrouping[])elems);

        OperationType() {
        }

        public static WMSSchema.WMSComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            org.geotools.data.ows.OperationType operationType = null;
            ArrayList<String> formatStrings = new ArrayList<String>();
            for (int i = 0; i < value.length; ++i) {
                if (this.sameName(elems[0], value[i])) {
                    Object[] stringValues = (Object[])value[i].getValue();
                    for (int ii = 0; ii < stringValues.length; ++ii) {
                        formatStrings.add((String)stringValues[ii]);
                    }
                }
                if (!this.sameName(elems[1], value[i])) continue;
                operationType = (org.geotools.data.ows.OperationType)value[i].getValue();
            }
            if (operationType != null) {
                operationType.setFormats(new ArrayList<String>(formatStrings));
            }
            return operationType;
        }

        public String getName() {
            return "OperationType";
        }

        public Class getInstanceType() {
            return org.geotools.data.ows.OperationType.class;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }
}

