/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRadioButtonInput
extends HtmlInput {
    private static final long serialVersionUID = 425993174633373218L;
    private boolean defaultCheckedState_;

    HtmlRadioButtonInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getAttribute("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttribute("value", "on");
        }
        this.defaultCheckedState_ = this.hasAttribute("checked");
    }

    @Override
    public void reset() {
        if (this.defaultCheckedState_) {
            this.setAttribute("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
    }

    @Override
    public Page setChecked(boolean isChecked) {
        ScriptResult scriptResult;
        boolean changed;
        HtmlForm form = this.getEnclosingForm();
        boolean bl = changed = this.isChecked() != isChecked;
        if (isChecked) {
            if (form != null) {
                form.setCheckedRadioButton(this);
            } else {
                ((HtmlPage)this.getPage()).setCheckedRadioButton(this);
            }
        } else {
            this.removeAttribute("checked");
        }
        Page page = this.getPage();
        if (changed && (scriptResult = this.fireEvent("change")) != null) {
            page = scriptResult.getNewPage();
        }
        return page;
    }

    @Override
    public String asText() {
        if (this.isChecked()) {
            return "checked";
        }
        return "unchecked";
    }

    @Override
    protected String asTextInternal() {
        return this.asText();
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        this.setChecked(true);
        return defaultPage;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().isFirefox()) {
            this.setChecked(defaultChecked);
        }
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }
}

