/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.gbif.registry.metadata.EMLProfileVersion;
import org.gbif.registry.metadata.InvalidEmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@NotThreadSafe
public class EmlValidator {
    private static final Logger LOG = LoggerFactory.getLogger(EmlValidator.class);
    private static final String SCHEMA_LANG = "http://www.w3.org/2001/XMLSchema";
    private final Validator validator;

    public static EmlValidator newValidator(EMLProfileVersion version) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance(SCHEMA_LANG);
        Schema schema = factory.newSchema(new StreamSource(version.getSchemaLocation()));
        return new EmlValidator(schema.newValidator());
    }

    private EmlValidator(Validator validator) {
        this.validator = validator;
    }

    public void validate(String emlAsString) throws InvalidEmlException {
        StreamSource streamSource = this.toSourceStream(emlAsString);
        if (streamSource == null) {
            throw new InvalidEmlException("Can't create StreamSource");
        }
        this.validate(streamSource);
    }

    public void validate(InputStream inputStream) throws InvalidEmlException {
        this.validate(new StreamSource(inputStream));
    }

    public void validate(StreamSource streamSource) throws InvalidEmlException {
        try {
            this.validator.validate(streamSource);
        }
        catch (Exception e) {
            throw new InvalidEmlException(e);
        }
    }

    private StreamSource toSourceStream(String xmlAsString) {
        try {
            return new StreamSource(new ByteArrayInputStream(xmlAsString.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Can't get UTF-8 bytes from String", (Throwable)e);
            return null;
        }
    }
}

