/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDoubleMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SumSlotAcc;

public class SumAgg
extends SimpleAggValueSource {
    public SumAgg(ValueSource vs) {
        super("sum", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        return new SumSlotAcc(this.getArg(), fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    public static class Merger
    extends FacetDoubleMerger {
        double val;

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            this.val += ((Number)facetResult).doubleValue();
        }

        @Override
        protected double getDouble() {
            return this.val;
        }
    }
}

