/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.persist.RandomAccessInterface;

final class ScaledRAFileInJar
implements RandomAccessInterface {
    DataInputStream file;
    final String fileName;
    long fileLength;
    boolean bufferDirty = true;
    byte[] buffer = new byte[4096];
    HsqlByteArrayInputStream ba = new HsqlByteArrayInputStream(this.buffer);
    long bufferOffset;
    long seekPosition;
    long realPosition;

    ScaledRAFileInJar(String string) throws FileNotFoundException, IOException {
        this.fileName = string;
        this.fileLength = this.getLength();
        this.resetStream();
    }

    @Override
    public long length() throws IOException {
        return this.fileLength;
    }

    @Override
    public void seek(long l) throws IOException {
        this.seekPosition = l;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l = this.seekPosition;
        this.bufferDirty = false;
        long l2 = l % (long)this.buffer.length;
        long l3 = this.fileLength - (l - l2);
        if (l3 <= 0L) {
            throw new IOException("read beyond end of file");
        }
        if (l3 > (long)this.buffer.length) {
            l3 = this.buffer.length;
        }
        this.fileSeek(l - l2);
        this.file.readFully(this.buffer, 0, (int)l3);
        this.bufferOffset = l - l2;
        this.realPosition = this.bufferOffset + l3;
    }

    @Override
    public int read() throws IOException {
        if (this.seekPosition >= this.fileLength) {
            return -1;
        }
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n = this.ba.read();
        ++this.seekPosition;
        return n;
    }

    @Override
    public long readLong() throws IOException {
        long l = this.readInt();
        long l2 = this.readInt();
        return (l << 32) + (l2 & 0xFFFFFFFFL);
    }

    @Override
    public int readInt() throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n = this.ba.readInt();
        this.seekPosition += 4L;
        return n;
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n3 = this.ba.read(byArray, n, n2);
        this.seekPosition += (long)n3;
        if (n3 < n2) {
            if (this.seekPosition != this.realPosition) {
                this.fileSeek(this.seekPosition);
            }
            this.file.readFully(byArray, n + n3, n2 - n3);
            this.seekPosition += (long)(n2 - n3);
            this.realPosition = this.seekPosition;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
    }

    @Override
    public void writeInt(int n) throws IOException {
    }

    @Override
    public void writeLong(long l) throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean wasNio() {
        return false;
    }

    private long getLength() throws IOException {
        int n = 0;
        this.resetStream();
        while (this.file.read() >= 0) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStream() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        InputStream inputStream = null;
        try {
            ClassLoader classLoader;
            inputStream = this.getClass().getResourceAsStream(this.fileName);
            if (inputStream == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                inputStream = classLoader.getResourceAsStream(this.fileName);
            }
        }
        catch (Throwable throwable) {
            if (inputStream == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        finally {
            if (inputStream == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.file = new DataInputStream(inputStream);
    }

    private void fileSeek(long l) throws IOException {
        long l2 = this.realPosition;
        if (l < l2) {
            this.resetStream();
            l2 = 0L;
        }
        while (l > l2) {
            l2 += this.file.skip(l - l2);
        }
    }

    @Override
    public boolean ensureLength(long l) {
        return true;
    }

    @Override
    public boolean setLength(long l) {
        return false;
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
    }
}

