/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.utils;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.Rank;
import org.gbif.common.parsers.utils.BlacklistedNames;
import org.gbif.nameparser.NameParser;
import org.gbif.nameparser.UnparsableException;

public final class ClassificationUtils {
    private static final Pattern CLEAN_REG_EX = Pattern.compile("[{}\u00a7';_|$%!?]+");
    public static final Set<String> NULL_STRINGS = new HashSet<String>(Arrays.asList("/N", "\\", "\\\\", "\\N", "\\\\N", "null", "NULL", "Null"));
    private static final NameParser PARSER = new NameParser();

    private ClassificationUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static String canonicalName(String scientificName, Rank rank) {
        ParsedName pn = null;
        try {
            pn = PARSER.parse(scientificName, rank);
        }
        catch (UnparsableException unparsableException) {
            // empty catch block
        }
        return pn.canonicalNameWithMarker();
    }

    public static String canonicalName(String scientificName) {
        return ClassificationUtils.canonicalName(scientificName, null);
    }

    public static String clean(String taxon) {
        if (Strings.isNullOrEmpty((String)taxon) || NULL_STRINGS.contains(taxon)) {
            return null;
        }
        String cleanedTaxon = taxon;
        if (!cleanedTaxon.contains(" ") && cleanedTaxon.equals(cleanedTaxon.toUpperCase())) {
            cleanedTaxon = cleanedTaxon.substring(0, 1) + cleanedTaxon.substring(1).toLowerCase();
        }
        while (cleanedTaxon.length() > 0 && cleanedTaxon.charAt(0) == '\"' && cleanedTaxon.charAt(cleanedTaxon.length() - 1) == '\"') {
            if (cleanedTaxon.length() == 1) {
                return null;
            }
            cleanedTaxon = cleanedTaxon.substring(1, cleanedTaxon.length() - 1);
        }
        while (cleanedTaxon.length() > 0 && cleanedTaxon.charAt(0) == '\"') {
            if (cleanedTaxon.length() == 1) {
                return null;
            }
            cleanedTaxon = cleanedTaxon.substring(1, cleanedTaxon.length());
        }
        while (cleanedTaxon.length() > 0 && cleanedTaxon.charAt(cleanedTaxon.length() - 1) == '\"') {
            if (cleanedTaxon.length() == 1) {
                return null;
            }
            cleanedTaxon = cleanedTaxon.substring(0, cleanedTaxon.length() - 1);
        }
        cleanedTaxon = CLEAN_REG_EX.matcher(cleanedTaxon).replaceAll("");
        if (BlacklistedNames.contains((cleanedTaxon = cleanedTaxon.trim()).toUpperCase()) || cleanedTaxon != taxon && BlacklistedNames.contains(taxon.toUpperCase())) {
            return null;
        }
        return Strings.emptyToNull((String)cleanedTaxon);
    }

    public static String cleanAuthor(String author) {
        if (Strings.isNullOrEmpty((String)author) || NULL_STRINGS.contains(author)) {
            return null;
        }
        String cleanedAuthor = author;
        while (cleanedAuthor.length() > 0 && cleanedAuthor.charAt(0) == '\"' && cleanedAuthor.charAt(cleanedAuthor.length() - 1) == '\"') {
            if (cleanedAuthor.length() == 1) {
                return null;
            }
            cleanedAuthor = cleanedAuthor.substring(1, cleanedAuthor.length() - 1);
        }
        cleanedAuthor = CLEAN_REG_EX.matcher(cleanedAuthor).replaceAll("");
        cleanedAuthor = cleanedAuthor.trim();
        return Strings.emptyToNull((String)cleanedAuthor);
    }

    public static String parseName(String scientificName) {
        return ClassificationUtils.parseName(scientificName, null);
    }

    public static String parseName(String scientificName, Rank rank) {
        try {
            ParsedName pn = PARSER.parse(scientificName, rank);
            if (pn.getRankMarker() != null && pn.getSpecificEpithet() == null && pn.getInfraSpecificEpithet() == null) {
                pn.setRankMarker(null);
            } else if (pn.getRankMarker() != null && pn.getSpecificEpithet() != null && pn.getInfraSpecificEpithet() == null) {
                pn.setRankMarker(null);
            }
            return pn.fullName();
        }
        catch (UnparsableException pn) {
            String canon = PARSER.parseToCanonical(scientificName, rank);
            if (canon != null) {
                return canon;
            }
            return scientificName;
        }
    }
}

