/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TextualMonthDateTokenizer {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[^A-Za-z0-9.]+");
    private static final Pattern DAY_SUFFIXES_PATTERN = Pattern.compile("(?<=[0-9]{1,2})(st|nd|rd|th|\\.)", 2);
    private static final Map<TokenType, Pattern> PATTERNS_BY_TYPE = ImmutableMap.of((Object)((Object)TokenType.INT_2), (Object)Pattern.compile("[0-9]{1,2}"), (Object)((Object)TokenType.INT_4), (Object)Pattern.compile("[0-9]{4}"), (Object)((Object)TokenType.TEXT), (Object)Pattern.compile("[A-Za-z.]{1,10}"));

    private TextualMonthDateTokenizer() {
    }

    public static TextualMonthDateTokenizer newInstance() {
        return new TextualMonthDateTokenizer();
    }

    public DateTokens tokenize(String str) {
        String[] parts;
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        str = DAY_SUFFIXES_PATTERN.matcher(str).replaceAll("");
        DateTokens tokens = new DateTokens();
        block0: for (String part : parts = SEPARATOR_PATTERN.split(str)) {
            for (TokenType tokenType : PATTERNS_BY_TYPE.keySet()) {
                if (!PATTERNS_BY_TYPE.get((Object)tokenType).matcher(part).matches()) continue;
                tokens.addToken(new DateToken(part, tokenType));
                continue block0;
            }
        }
        return tokens;
    }

    public static class DateToken {
        private final String token;
        private final TokenType type;

        DateToken(String token, TokenType tokenType) {
            this.token = token;
            this.type = tokenType;
        }

        public String getToken() {
            return this.token;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.token, this.type});
        }

        public boolean equals(Object object) {
            if (object instanceof DateToken) {
                DateToken that = (DateToken)object;
                return Objects.equal((Object)this.token, (Object)that.token) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).add("type", (Object)this.type).toString();
        }
    }

    public static class DateTokens {
        private final Map<TokenType, DateToken> tokens = Maps.newHashMapWithExpectedSize((int)3);
        private List<DateToken> discardedTokens = null;

        private void addToken(DateToken dateToken) {
            DateToken prev = this.tokens.put(dateToken.type, dateToken);
            if (prev != null) {
                this.addDiscardedToken(prev);
            }
        }

        private void addDiscardedToken(DateToken dateToken) {
            if (this.discardedTokens == null) {
                this.discardedTokens = Lists.newArrayList();
            }
            this.discardedTokens.add(dateToken);
        }

        public boolean containsDiscardedTokens() {
            return this.discardedTokens != null;
        }

        public int size() {
            return this.tokens.size();
        }

        public DateToken getToken(TokenType tokenType) {
            return this.tokens.get((Object)tokenType);
        }

        public List<DateToken> getDiscardedTokens() {
            return ImmutableList.copyOf(this.discardedTokens);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tokens", this.tokens).add("discardedTokens", this.discardedTokens).toString();
        }
    }

    public static enum TokenType {
        INT_2,
        INT_4,
        TEXT;

    }
}

