/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.gbif.common.parsers.date.DateTimeParser;
import org.threeten.bp.temporal.TemporalAccessor;

public class DateTimeMultiParser {
    private final DateTimeParser preferred;
    private final List<DateTimeParser> otherParsers;
    private final List<DateTimeParser> allParsers;

    DateTimeMultiParser(@NotNull List<DateTimeParser> parsers) {
        this(null, parsers);
    }

    DateTimeMultiParser(@Nullable DateTimeParser preferred, @NotNull List<DateTimeParser> otherParsers) {
        Preconditions.checkNotNull(otherParsers, (Object)"otherParsers list can not be null");
        Preconditions.checkArgument((otherParsers.size() > 0 ? 1 : 0) != 0, (Object)"otherParsers must contain at least 1 element");
        if (preferred == null) {
            Preconditions.checkArgument((otherParsers.size() > 1 ? 1 : 0) != 0, (Object)"If no preferred DateTimeParser is provided, the otherParsers list must contain more than 1 element");
        }
        this.preferred = preferred;
        this.otherParsers = Lists.newArrayList(otherParsers);
        ImmutableList.Builder immutableListBuilder = new ImmutableList.Builder();
        if (preferred != null) {
            immutableListBuilder.add((Object)preferred);
        }
        immutableListBuilder.addAll(otherParsers);
        this.allParsers = immutableListBuilder.build();
    }

    public List<DateTimeParser> getAllParsers() {
        return this.allParsers;
    }

    public MultipleParseResult parse(String input) {
        int numberParsed = 0;
        TemporalAccessor lastParsed = null;
        TemporalAccessor preferredResult = null;
        ArrayList otherResults = null;
        for (DateTimeParser currParser : this.otherParsers) {
            lastParsed = currParser.parse(input);
            if (lastParsed == null) continue;
            ++numberParsed;
            if (otherResults == null) {
                otherResults = Lists.newArrayList();
            }
            otherResults.add(lastParsed);
        }
        if (this.preferred != null && (lastParsed = this.preferred.parse(input)) != null) {
            ++numberParsed;
            preferredResult = lastParsed;
        }
        return new MultipleParseResult(numberParsed, preferredResult, otherResults);
    }

    public static class MultipleParseResult {
        private int numberParsed;
        private TemporalAccessor preferredResult;
        private List<TemporalAccessor> otherResults;

        public MultipleParseResult(int numberParsed, TemporalAccessor preferredResult, List<TemporalAccessor> otherResults) {
            this.numberParsed = numberParsed;
            this.preferredResult = preferredResult;
            this.otherResults = otherResults;
        }

        public int getNumberParsed() {
            return this.numberParsed;
        }

        public TemporalAccessor getPreferredResult() {
            return this.preferredResult;
        }

        public List<TemporalAccessor> getOtherResults() {
            return this.otherResults;
        }

        public TemporalAccessor getResult() {
            if (this.preferredResult != null) {
                return this.preferredResult;
            }
            if (this.otherResults != null && this.otherResults.size() > 0) {
                return this.otherResults.get(0);
            }
            return null;
        }
    }
}

